/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.property;

import com.google.common.collect.Range;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Register;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.property.TracePropertyMapOperations;
import ghidra.trace.util.TraceRegisterUtils;
import java.util.Collection;
import java.util.Map;

public interface TracePropertyMapSpace<T>
extends TracePropertyMapOperations<T> {
    public Trace getTrace();

    public AddressSpace getAddressSpace();

    default public void set(Range<Long> lifespan, Register register, T value) {
        this.set(lifespan, TraceRegisterUtils.rangeForRegister(register), value);
    }

    default public Collection<Map.Entry<TraceAddressSnapRange, T>> getEntries(Range<Long> lifespan, Register register) {
        return this.getEntries(lifespan, TraceRegisterUtils.rangeForRegister(register));
    }

    default public void clear(Range<Long> span, Register register) {
        this.clear(span, TraceRegisterUtils.rangeForRegister(register));
    }
}

