/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.bookmark;

import com.google.common.collect.Range;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Register;
import ghidra.trace.model.bookmark.TraceBookmark;
import ghidra.trace.model.bookmark.TraceBookmarkOperations;
import ghidra.trace.model.bookmark.TraceBookmarkType;
import ghidra.trace.util.TraceRegisterUtils;

public interface TraceBookmarkSpace
extends TraceBookmarkOperations {
    public AddressSpace getAddressSpace();

    default public TraceBookmark addBookmark(Range<Long> lifespan, Register register, TraceBookmarkType type, String category, String comment) {
        return this.addBookmark(lifespan, register.getAddress(), type, category, comment);
    }

    default public Iterable<? extends TraceBookmark> getBookmarksEnclosed(Range<Long> lifespan, Register register) {
        return this.getBookmarksEnclosed(lifespan, TraceRegisterUtils.rangeForRegister(register));
    }

    default public Iterable<? extends TraceBookmark> getBookmarksIntersecting(Range<Long> lifespan, Register register) {
        return this.getBookmarksIntersecting(lifespan, TraceRegisterUtils.rangeForRegister(register));
    }
}

