/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.target.visitors;

import com.google.common.collect.Range;
import ghidra.dbg.util.PathPredicates;
import ghidra.trace.database.target.visitors.TreeTraversal;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectValPath;
import ghidra.trace.model.target.TraceObjectValue;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;

public class AncestorsRelativeVisitor
implements TreeTraversal.SpanIntersectingVisitor {
    protected final PathPredicates predicates;

    public AncestorsRelativeVisitor(PathPredicates predicates) {
        this.predicates = predicates;
    }

    @Override
    public TraceObjectValPath composePath(TraceObjectValPath pre, TraceObjectValue value) {
        return pre == null ? TraceObjectValPath.of() : pre.prepend(value);
    }

    @Override
    public TreeTraversal.VisitResult visitValue(TraceObjectValue value, TraceObjectValPath path) {
        List<String> keyList = path.getKeyList();
        return TreeTraversal.VisitResult.result(this.predicates.matches(keyList), this.predicates.ancestorCouldMatchRight(keyList, true) && value.isObject());
    }

    @Override
    public TraceObject continueObject(TraceObjectValue value) {
        return value.getParent();
    }

    @Override
    public Stream<? extends TraceObjectValue> continueValues(TraceObject object, Range<Long> span, TraceObjectValPath pre) {
        Set prevKeys = this.predicates.getPrevKeys(pre.getKeyList());
        if (prevKeys.isEmpty()) {
            return Stream.empty();
        }
        return object.getParents().stream().filter(v -> PathPredicates.anyMatches((Set)prevKeys, (String)v.getEntryKey()));
    }
}

