/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec.trace.data;

import com.google.common.collect.Range;
import ghidra.pcode.exec.trace.data.InternalPcodeTraceDataAccess;
import ghidra.pcode.exec.trace.data.PcodeTracePropertyAccess;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSpace;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.model.property.TracePropertyMap;
import ghidra.trace.model.property.TracePropertyMapOperations;
import ghidra.trace.model.property.TracePropertyMapSpace;

public class DefaultPcodeTracePropertyAccess<T>
implements PcodeTracePropertyAccess<T> {
    protected final InternalPcodeTraceDataAccess data;
    protected final String name;
    protected final Class<T> type;
    protected TracePropertyMapOperations<T> po;

    protected DefaultPcodeTracePropertyAccess(InternalPcodeTraceDataAccess data, String name, Class<T> type) {
        this.data = data;
        this.name = name;
        this.type = type;
        this.po = data.getPropertyOps(name, type, false);
    }

    protected TracePropertyMapOperations<T> getPropertyOperations(boolean createIfAbsent) {
        if (this.po == null) {
            this.po = this.data.getPropertyOps(this.name, this.type, createIfAbsent);
            return this.po;
        }
        return this.po;
    }

    protected T whenNull(Address hostAddress) {
        return null;
    }

    @Override
    public T get(Address address) {
        Address hostAddr = this.data.getPlatform().mapGuestToHost(address);
        if (hostAddr == null) {
            return null;
        }
        TracePropertyMapOperations<T> ops = this.getPropertyOperations(false);
        if (ops == null) {
            return this.whenNull(hostAddr);
        }
        Address overlayAddr = this.toOverlay(ops, hostAddr);
        return ops.get(this.data.getSnap(), overlayAddr);
    }

    @Override
    public void put(Address address, T value) {
        Address hostAddr = this.data.getPlatform().mapGuestToHost(address);
        if (hostAddr == null) {
            return;
        }
        Range<Long> span = DBTraceUtils.atLeastMaybeScratch(this.data.getSnap());
        TracePropertyMapOperations<T> ops = this.getPropertyOperations(true);
        ops.set(span, this.toOverlay(ops, hostAddr), value);
    }

    @Override
    public void clear(AddressRange range) {
        AddressRange hostRange = this.data.getPlatform().mapGuestToHost(range);
        if (hostRange == null) {
            return;
        }
        Range<Long> span = DBTraceUtils.atLeastMaybeScratch(this.data.getSnap());
        TracePropertyMapOperations<T> ops = this.getPropertyOperations(false);
        if (ops == null) {
            return;
        }
        ops.clear(span, this.toOverlay(ops, hostRange));
    }

    protected Address toOverlay(TracePropertyMapOperations<T> ops, Address address) {
        if (ops instanceof TracePropertyMap) {
            return address;
        }
        if (ops instanceof TracePropertyMapSpace) {
            TracePropertyMapSpace mapSpace = (TracePropertyMapSpace)ops;
            return mapSpace.getAddressSpace().getOverlayAddress(address);
        }
        throw new AssertionError();
    }

    protected AddressRange toOverlay(TracePropertyMapOperations<T> ops, AddressRange range) {
        if (ops instanceof TracePropertyMap) {
            return range;
        }
        if (ops instanceof TracePropertyMapSpace) {
            TracePropertyMapSpace mapSpace = (TracePropertyMapSpace)ops;
            AddressSpace space = mapSpace.getAddressSpace();
            return new AddressRangeImpl(space.getOverlayAddress(range.getMinAddress()), space.getOverlayAddress(range.getMaxAddress()));
        }
        throw new AssertionError();
    }
}

