/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.data;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalNotification;
import ghidra.framework.data.DomainObjectChangeSupport;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.EventQueueID;
import ghidra.util.Lock;
import java.util.Map;
import java.util.NoSuchElementException;

public class DomainObjectEventQueues {
    protected final DomainObject source;
    protected final Lock lock;
    protected final DomainObjectChangeSupport eventQueue;
    protected final Map<EventQueueID, DomainObjectChangeSupport> privateEventQueues = CacheBuilder.newBuilder().removalListener(this::privateQueueRemoved).weakKeys().build().asMap();
    protected volatile boolean eventsEnabled = true;

    public DomainObjectEventQueues(DomainObject source, int timeInterval, Lock lock) {
        this.source = source;
        this.lock = lock;
        this.eventQueue = new DomainObjectChangeSupport(source, timeInterval, lock);
    }

    private void privateQueueRemoved(RemovalNotification<EventQueueID, DomainObjectChangeSupport> rn) {
        ((DomainObjectChangeSupport)rn.getValue()).dispose();
    }

    public void flushEvents() {
        this.eventQueue.flush();
        for (DomainObjectChangeSupport privateQueue : this.privateEventQueues.values()) {
            privateQueue.flush();
        }
    }

    public void addListener(DomainObjectListener l) {
        this.eventQueue.addListener(l);
    }

    public void removeListener(DomainObjectListener l) {
        this.eventQueue.removeListener(l);
    }

    public EventQueueID createPrivateEventQueue(DomainObjectListener listener, int maxDelay) {
        EventQueueID id = new EventQueueID();
        DomainObjectChangeSupport privateQueue = new DomainObjectChangeSupport(this.source, maxDelay, this.lock);
        privateQueue.addListener(listener);
        this.privateEventQueues.put(id, privateQueue);
        return id;
    }

    public boolean removePrivateEventQueue(EventQueueID id) {
        return this.privateEventQueues.remove(id) != null;
    }

    public void flushPrivateEventQueue(EventQueueID id) {
        DomainObjectChangeSupport privateQueue = this.privateEventQueues.get(id);
        if (privateQueue == null) {
            throw new NoSuchElementException("Private queue no longer exists");
        }
        privateQueue.flush();
    }

    public void fireEvent(DomainObjectChangeRecord ev) {
        if (this.eventsEnabled) {
            this.eventQueue.fireEvent(ev);
            for (DomainObjectChangeSupport privateQueue : this.privateEventQueues.values()) {
                privateQueue.fireEvent(ev);
            }
        }
    }

    public void setEventsEnabled(boolean eventsEnabled) {
        if (this.eventsEnabled == eventsEnabled) {
            return;
        }
        this.eventsEnabled = eventsEnabled;
        if (eventsEnabled) {
            DomainObjectChangeRecord restored = new DomainObjectChangeRecord(4);
            this.eventQueue.fireEvent(restored);
            for (DomainObjectChangeSupport privateQueue : this.privateEventQueues.values()) {
                privateQueue.fireEvent(restored);
            }
        }
    }

    public boolean isSendingEvents() {
        return this.eventsEnabled;
    }
}

