/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.DecompilerProvider;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.app.util.AddEditDialog;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.HelpLocation;
import ghidra.util.UndefinedFunction;
import java.util.Objects;

public class RenameFunctionAction
extends AbstractDecompilerAction {
    public RenameFunctionAction() {
        super("Rename Function");
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionRenameFunction"));
        this.setKeyBindingData(new KeyBindingData(76, 0));
        this.setPopupMenuData(new MenuData(new String[]{"Rename Function"}, "Decompile"));
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        Function func = this.getFunction(context);
        return func != null && !(func instanceof UndefinedFunction);
    }

    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        Program program = context.getProgram();
        Function function = this.getFunction(context);
        AddEditDialog dialog = new AddEditDialog("Edit Function Name", context.getTool());
        Symbol symbol = function.getSymbol();
        String originalName = symbol.getName();
        dialog.editLabel(symbol, program);
        String currentName = symbol.getName();
        if (Objects.equals(originalName, currentName)) {
            return;
        }
        DecompilerProvider provider = context.getComponentProvider();
        ClangToken tokenAtCursor = context.getTokenAtCursor();
        provider.tokenRenamed(tokenAtCursor, currentName);
    }
}

