/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.DialogComponentProvider;
import docking.action.MenuData;
import docking.widgets.OptionDialog;
import ghidra.app.decompiler.ClangFuncNameToken;
import ghidra.app.decompiler.ClangFunction;
import ghidra.app.decompiler.ClangNode;
import ghidra.app.decompiler.ClangStatement;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.app.plugin.core.function.EditFunctionSignatureDialog;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.GenericCallingConvention;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.FunctionSignature;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighFunctionDBUtil;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.PcodeOpAST;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.UndefinedFunction;
import ghidra.util.exception.CancelledException;
import java.awt.Component;
import java.util.Iterator;

public class OverridePrototypeAction
extends AbstractDecompilerAction {
    public OverridePrototypeAction() {
        super("Override Signature");
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionOverrideSignature"));
        this.setPopupMenuData(new MenuData(new String[]{"Override Signature"}, "Decompile"));
    }

    public static PcodeOp getCallOp(Program program, ClangToken tokenAtCursor) {
        PcodeOp op;
        PcodeOp op2;
        if (tokenAtCursor == null) {
            return null;
        }
        if (tokenAtCursor instanceof ClangFuncNameToken) {
            return ((ClangFuncNameToken)tokenAtCursor).getPcodeOp();
        }
        Address addr = tokenAtCursor.getMinAddress();
        if (addr != null && (op2 = OverridePrototypeAction.getOpForAddress(program, addr, tokenAtCursor)) != null) {
            return op2;
        }
        ClangNode parent = tokenAtCursor.Parent();
        if (parent instanceof ClangStatement && OverridePrototypeAction.isCallOp(op = ((ClangStatement)parent).getPcodeOp())) {
            return op;
        }
        return null;
    }

    private static PcodeOp getOpForAddress(Program program, Address addr, ClangToken token) {
        ClangFunction cfunc = token.getClangFunction();
        if (cfunc == null) {
            return null;
        }
        Instruction instr = program.getListing().getInstructionAt(addr);
        if (instr == null) {
            return null;
        }
        if (!instr.getFlowType().isCall()) {
            return null;
        }
        HighFunction hfunc = cfunc.getHighFunction();
        Iterator iter = hfunc.getPcodeOps(addr);
        while (iter.hasNext()) {
            PcodeOpAST op = (PcodeOpAST)iter.next();
            if (!OverridePrototypeAction.isCallOp((PcodeOp)op)) continue;
            return op;
        }
        return null;
    }

    private static boolean isCallOp(PcodeOp op) {
        if (op == null) {
            return false;
        }
        int opCode = op.getOpcode();
        return opCode == 7 || opCode == 8;
    }

    private Function getCalledFunction(Program program, PcodeOp op) {
        Reference[] references;
        if (op.getOpcode() != 7) {
            return null;
        }
        Address addr = op.getInput(0).getAddress();
        FunctionManager functionManager = program.getFunctionManager();
        Function function = functionManager.getFunctionAt(addr);
        if (function != null) {
            return function;
        }
        Address opAddr = op.getSeqnum().getTarget();
        for (Reference ref : references = program.getReferenceManager().getFlowReferencesFrom(opAddr)) {
            if (!ref.getReferenceType().isCall() || (function = functionManager.getFunctionAt(ref.getToAddress())) == null) continue;
            return function;
        }
        return null;
    }

    private String generateSignature(PcodeOp op, String name, Function calledfunc) {
        SourceType signatureSource;
        if (calledfunc != null && ((signatureSource = calledfunc.getSignatureSource()) == SourceType.DEFAULT || signatureSource == SourceType.ANALYSIS)) {
            calledfunc = null;
        }
        StringBuffer buf = new StringBuffer();
        Varnode vn = op.getOutput();
        DataType dt = null;
        if (calledfunc != null && Undefined.isUndefined((DataType)(dt = calledfunc.getReturnType()))) {
            dt = null;
        }
        if (dt == null && vn != null) {
            dt = vn.getHigh().getDataType();
        }
        if (dt != null) {
            buf.append(dt.getDisplayName());
        } else {
            buf.append(DataType.VOID.getDisplayName());
        }
        buf.append(' ').append(name).append('(');
        int index = 1;
        if (calledfunc != null) {
            for (Parameter p : calledfunc.getParameters()) {
                String dtName = this.getInputDataTypeName(op, index, p.getDataType());
                if (index++ != 1) {
                    buf.append(", ");
                }
                buf.append(dtName);
                if (p.getSource() == SourceType.DEFAULT) continue;
                buf.append(' ');
                buf.append(p.getName());
            }
        }
        for (int i = index; i < op.getNumInputs(); ++i) {
            if (i != 1) {
                buf.append(", ");
            }
            buf.append(this.getInputDataTypeName(op, i, null));
        }
        buf.append(')');
        return buf.toString();
    }

    private String getInputDataTypeName(PcodeOp op, int inIndex, DataType preferredDt) {
        if (preferredDt != null && !Undefined.isUndefined((DataType)preferredDt)) {
            return preferredDt.getDisplayName();
        }
        Varnode vn = op.getInput(inIndex);
        DataType dt = null;
        if (vn != null) {
            dt = vn.getHigh().getDataType();
        }
        if (dt != null) {
            return dt.getDisplayName();
        }
        return "BAD";
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        Function function = context.getFunction();
        if (function == null || function instanceof UndefinedFunction) {
            return false;
        }
        PcodeOp callOp = OverridePrototypeAction.getCallOp(context.getProgram(), context.getTokenAtCursor());
        return callOp != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        Function func = context.getFunction();
        Program program = func.getProgram();
        PcodeOp op = OverridePrototypeAction.getCallOp(program, context.getTokenAtCursor());
        Function calledfunc = this.getCalledFunction(program, op);
        boolean varargs = false;
        if (calledfunc != null) {
            varargs = calledfunc.hasVarArgs();
        }
        if (op.getOpcode() == 7 && !varargs && OptionDialog.showOptionDialog((Component)context.getDecompilerPanel(), (String)"Warning : Localized Override", (String)"Incorrect information entered here may hide other good information.\nFor direct calls, it is usually better to alter the prototype on the function\nitself, rather than overriding the local call. Proceed anyway?", (String)"Proceed") != 1) {
            return;
        }
        Address addr = op.getSeqnum().getTarget();
        String name = "func";
        String conv = program.getCompilerSpec().getDefaultCallingConvention().getName();
        if (calledfunc != null) {
            name = calledfunc.getName();
            conv = calledfunc.getCallingConventionName();
        }
        String signature = this.generateSignature(op, name, calledfunc);
        PluginTool tool = context.getTool();
        ProtoOverrideDialog dialog = new ProtoOverrideDialog(tool, calledfunc != null ? calledfunc : func, signature, conv);
        tool.showDialog((DialogComponentProvider)dialog);
        FunctionDefinition fdef = dialog.getFunctionDefinition();
        if (fdef == null) {
            return;
        }
        int transaction = program.startTransaction("Override Signature");
        boolean commit = false;
        try {
            HighFunctionDBUtil.writeOverride((Function)func, (Address)addr, (FunctionSignature)fdef);
            commit = true;
        }
        catch (Exception e) {
            Msg.showError(((Object)((Object)this)).getClass(), (Component)context.getDecompilerPanel(), (String)"Override Signature Failed", (Object)("Error overriding signature: " + e));
        }
        finally {
            program.endTransaction(transaction, commit);
        }
    }

    private class ProtoOverrideDialog
    extends EditFunctionSignatureDialog {
        private FunctionDefinition functionDefinition;
        private final String initialSignature;
        private final String initialConvention;

        public ProtoOverrideDialog(PluginTool tool, Function func, String signature, String conv) {
            super(tool, "Override Signature", func, false, false, false);
            this.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionOverrideSignature"));
            this.initialSignature = signature;
            this.initialConvention = conv;
        }

        protected String getPrototypeString() {
            return this.initialSignature;
        }

        protected String getCallingConventionName() {
            return this.initialConvention;
        }

        protected boolean applyChanges() throws CancelledException {
            return this.parseFunctionDefinition();
        }

        private boolean parseFunctionDefinition() {
            this.functionDefinition = null;
            try {
                this.functionDefinition = this.parseSignature();
            }
            catch (CancelledException cancelledException) {
                // empty catch block
            }
            if (this.functionDefinition == null) {
                return false;
            }
            GenericCallingConvention convention = GenericCallingConvention.guessFromName((String)this.getCallingConvention());
            this.functionDefinition.setGenericCallingConvention(convention);
            return true;
        }

        public FunctionDefinition getFunctionDefinition() {
            return this.functionDefinition;
        }
    }
}

