/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.ClangVariableToken;
import ghidra.app.plugin.core.decompile.DecompilePlugin;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.app.plugin.core.decompile.actions.ConvertConstantTask;
import ghidra.program.model.address.Address;
import ghidra.program.model.block.CodeBlock;
import ghidra.program.model.block.SimpleBlockModel;
import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.BooleanDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Enum;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.DynamicHash;
import ghidra.program.model.pcode.EquateSymbol;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.Equate;
import ghidra.program.model.symbol.EquateReference;
import ghidra.program.model.symbol.EquateTable;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.Iterator;
import java.util.List;
import javax.swing.JMenuItem;

public abstract class ConvertConstantAction
extends AbstractDecompilerAction {
    private static final int MAX_INSTRUCTION_WINDOW = 20;
    private static final int MAX_SCALAR_SIZE = 8;
    protected DecompilePlugin plugin;
    private FontMetrics metrics = null;
    private int convertType;

    public ConvertConstantAction(DecompilePlugin plugin, String name, int convertType) {
        super(name);
        this.plugin = plugin;
        this.convertType = convertType;
    }

    private int stringWidth(String s) {
        int w;
        if (this.metrics == null) {
            JMenuItem item = new JMenuItem();
            Font font = item.getFont();
            this.metrics = this.plugin.getTool().getActiveWindow().getFontMetrics(font);
        }
        if ((w = this.metrics.stringWidth(s)) == 0) {
            return 10 * s.length();
        }
        return w;
    }

    protected String getStandardLengthString(String baseString) {
        int spaceWidth;
        int baseWidth = this.stringWidth(baseString);
        int paddingSize = (140 - baseWidth) / (spaceWidth = this.stringWidth(" "));
        if (paddingSize <= 0) {
            return baseString;
        }
        StringBuilder buf = new StringBuilder(baseString);
        for (int i = 0; i < paddingSize; ++i) {
            buf.append(" ");
        }
        return buf.toString();
    }

    private ScalarMatch findScalarInInstruction(Instruction instr, long[] values) {
        int numOperands = instr.getNumOperands();
        ScalarMatch scalarMatch = null;
        for (int i = 0; i < numOperands; ++i) {
            for (Object obj : instr.getOpObjects(i)) {
                if (!(obj instanceof Scalar)) continue;
                Scalar scalar = (Scalar)obj;
                for (long value : values) {
                    if (scalar.getUnsignedValue() != value) continue;
                    if (scalarMatch != null) {
                        scalarMatch.opIndex = -1;
                        return scalarMatch;
                    }
                    scalarMatch = new ScalarMatch(instr.getAddress(), scalar, i);
                }
            }
        }
        return scalarMatch;
    }

    private ScalarMatch findScalarMatch(Program program, Address startAddress, Varnode constVn, TaskMonitor monitor) throws CancelledException {
        long value = constVn.getOffset();
        long mask = -1L;
        if (constVn.getSize() < 8) {
            mask >>>= (8 - constVn.getSize()) * 8;
        }
        long[] values = new long[]{value, value - 1L & mask, value + 1L & mask, -value & mask};
        int count = 0;
        ScalarMatch scalarMatch = null;
        Instruction curInst = program.getListing().getInstructionAt(startAddress);
        if (curInst == null) {
            return null;
        }
        SimpleBlockModel model = new SimpleBlockModel(program);
        CodeBlock basicBlock = model.getFirstCodeBlockContaining(startAddress, monitor);
        if (basicBlock == null) {
            return null;
        }
        while (count < 20) {
            ++count;
            ScalarMatch newMatch = this.findScalarInInstruction(curInst, values);
            if (newMatch != null) {
                if (scalarMatch != null) {
                    return null;
                }
                if (newMatch.opIndex < 0) {
                    return null;
                }
                scalarMatch = newMatch;
            }
            if ((curInst = curInst.getPrevious()) != null && basicBlock.contains(curInst.getAddress())) continue;
            break;
        }
        return scalarMatch;
    }

    protected ConvertConstantTask establishTask(DecompilerActionContext context, boolean setupFinal) {
        ClangToken tokenAtCursor = context.getTokenAtCursor();
        if (!(tokenAtCursor instanceof ClangVariableToken)) {
            return null;
        }
        Varnode convertVn = tokenAtCursor.getVarnode();
        if (convertVn == null || !convertVn.isConstant() || convertVn.getSize() > 8) {
            return null;
        }
        HighSymbol symbol = convertVn.getHigh().getSymbol();
        EquateSymbol convertSymbol = null;
        if (symbol != null) {
            if (symbol instanceof EquateSymbol) {
                convertSymbol = (EquateSymbol)symbol;
                int type = convertSymbol.getConvert();
                if (type == this.convertType || type == 0) {
                    return null;
                }
            } else {
                return null;
            }
        }
        DataType convertDataType = convertVn.getHigh().getDataType();
        boolean convertIsSigned = false;
        if (convertDataType instanceof AbstractIntegerDataType) {
            if (convertDataType instanceof BooleanDataType) {
                return null;
            }
            convertIsSigned = ((AbstractIntegerDataType)convertDataType).isSigned();
        } else if (convertDataType instanceof Enum) {
            return null;
        }
        if (!setupFinal) {
            return new ConvertConstantTask(convertVn, convertIsSigned);
        }
        ConvertConstantTask task = null;
        String equateName = this.getEquateName(convertVn.getOffset(), convertVn.getSize(), convertIsSigned, context.getProgram());
        if (equateName == null) {
            return null;
        }
        Program program = context.getProgram();
        if (convertSymbol != null) {
            Address convertAddr = convertSymbol.getPCAddress();
            long convertHash = 0L;
            int convertIndex = -1;
            boolean foundEquate = false;
            EquateTable equateTable = program.getEquateTable();
            List equates = equateTable.getEquates(convertAddr);
            for (Equate equate : equates) {
                if (equate.getValue() != convertVn.getOffset()) continue;
                Iterator iterator = equate.getReferences(convertAddr).iterator();
                if (!iterator.hasNext()) break;
                EquateReference equateRef = (EquateReference)iterator.next();
                convertHash = equateRef.getDynamicHashValue();
                convertIndex = equateRef.getOpIndex();
                foundEquate = true;
                break;
            }
            if (!foundEquate) {
                Msg.error((Object)((Object)this), (Object)"Symbol does not have matching entry in equate table");
                return null;
            }
            task = new ConvertConstantTask(context, equateName, convertAddr, convertVn, convertIsSigned, convertHash, convertIndex);
        } else {
            PcodeOp op = convertVn.getLoneDescend();
            Address convertAddr = op.getSeqnum().getTarget();
            DynamicHash dynamicHash = new DynamicHash(convertVn, 0);
            long convertHash = dynamicHash.getHash();
            task = new ConvertConstantTask(context, equateName, convertAddr, convertVn, convertIsSigned, convertHash, -1);
            try {
                ScalarMatch scalarMatch = this.findScalarMatch(context.getProgram(), convertAddr, convertVn, TaskMonitor.DUMMY);
                if (scalarMatch != null) {
                    String altName;
                    long value = scalarMatch.scalar.getUnsignedValue();
                    int size = scalarMatch.scalar.bitLength() / 8;
                    if (size == 0) {
                        size = 1;
                    }
                    if ((altName = this.getEquateName(value = ConvertConstantTask.signExtendValue(convertIsSigned, value, size), size, convertIsSigned, null)) == null) {
                        altName = equateName;
                    }
                    if (this.convertType != 0 || value == task.getValue()) {
                        task.setAlternate(altName, scalarMatch.refAddr, scalarMatch.opIndex, value);
                    }
                }
            }
            catch (CancelledException cancelledException) {
                // empty catch block
            }
        }
        return task;
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        ConvertConstantTask task = this.establishTask(context, false);
        if (task == null) {
            return false;
        }
        String convDisplay = this.getMenuDisplay(task.getValue(), task.getSize(), task.isSigned());
        if (convDisplay.equals(context.getTokenAtCursor().getText())) {
            return false;
        }
        String menuString = this.getStandardLengthString(this.getMenuPrefix()) + convDisplay;
        this.getPopupMenuData().setMenuItemNamePlain(menuString);
        return true;
    }

    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        ConvertConstantTask task = this.establishTask(context, true);
        if (task == null) {
            return;
        }
        task.runTask();
    }

    public abstract String getMenuPrefix();

    public abstract String getMenuDisplay(long var1, int var3, boolean var4);

    public abstract String getEquateName(long var1, int var3, boolean var4, Program var5);

    private static class ScalarMatch {
        Address refAddr;
        Scalar scalar;
        int opIndex;

        public ScalarMatch(Address addr, Scalar value, int index) {
            this.refAddr = addr;
            this.scalar = value;
            this.opIndex = index;
        }
    }
}

