/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractModifierMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractPointerMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.DummyMsType;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.ModifierTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.MsTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.ProcedureTypeApplier;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.util.exception.CancelledException;
import java.math.BigInteger;

public class PointerTypeApplier
extends MsTypeApplier {
    private boolean isFunctionPointer = false;

    public PointerTypeApplier(DefaultPdbApplicator applicator, AbstractPointerMsType msType) throws IllegalArgumentException {
        super(applicator, msType);
    }

    boolean isFunctionPointer() {
        return this.isFunctionPointer;
    }

    @Override
    BigInteger getSize() {
        return ((AbstractPointerMsType)this.msType).getSize();
    }

    @Override
    void apply() throws PdbException, CancelledException {
        this.dataType = this.msType instanceof DummyMsType ? new PointerDataType(this.applicator.getDataTypeManager()) : this.applyAbstractPointerMsType((AbstractPointerMsType)this.msType);
    }

    @Override
    void resolve() {
    }

    MsTypeApplier getUnmodifiedUnderlyingTypeApplier() {
        MsTypeApplier thisUnderlyingTypeApplier = this.applicator.getTypeApplier(((AbstractPointerMsType)this.msType).getUnderlyingRecordNumber());
        if (thisUnderlyingTypeApplier instanceof ModifierTypeApplier) {
            ModifierTypeApplier x = (ModifierTypeApplier)thisUnderlyingTypeApplier;
            RecordNumber recNum = ((AbstractModifierMsType)x.getMsType()).getModifiedRecordNumber();
            thisUnderlyingTypeApplier = this.applicator.getTypeApplier(recNum);
        }
        return thisUnderlyingTypeApplier;
    }

    private DataType applyAbstractPointerMsType(AbstractPointerMsType type) {
        int size;
        DataType underlyingType;
        MsTypeApplier underlyingApplier = this.applicator.getTypeApplier(type.getUnderlyingRecordNumber());
        if (underlyingApplier instanceof ProcedureTypeApplier) {
            this.isFunctionPointer = true;
        }
        if ((underlyingType = underlyingApplier.getCycleBreakType()) == null) {
            underlyingType = this.applicator.getPdbPrimitiveTypeApplicator().getVoidType();
            this.applicator.appendLogMsg("PDB Warning: No type conversion for " + underlyingApplier.getMsType().toString() + " as underlying type for pointer. Using void.");
        }
        if ((size = type.getSize().intValueExact()) == this.applicator.getDataOrganization().getPointerSize()) {
            size = -1;
        }
        PointerDataType pointer = new PointerDataType(underlyingType, size, this.applicator.getDataTypeManager());
        return pointer;
    }
}

