/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.msf;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbReaderOptions;
import ghidra.app.util.bin.format.pdb2.pdbreader.msf.Msf;
import ghidra.app.util.bin.format.pdb2.pdbreader.msf.MsfDirectoryStream;
import ghidra.app.util.bin.format.pdb2.pdbreader.msf.MsfFileReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.msf.MsfFreePageMap;
import ghidra.app.util.bin.format.pdb2.pdbreader.msf.MsfStream;
import ghidra.app.util.bin.format.pdb2.pdbreader.msf.MsfStreamTable;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Objects;

public abstract class AbstractMsf
implements Msf {
    private static final int HEADER_PAGE_NUMBER = 0;
    private static final int DIRECTORY_STREAM_NUMBER = 0;
    protected String filename;
    protected MsfFileReader fileReader;
    protected MsfFreePageMap freePageMap;
    protected MsfDirectoryStream directoryStream;
    protected MsfStreamTable streamTable;
    protected int pageSize;
    protected int log2PageSize;
    protected int freePageMapNumSequentialPage;
    protected int pageSizeModMask;
    protected int currentFreePageMapFirstPageNumber;
    protected int numPages = 1;
    protected TaskMonitor monitor;
    protected PdbReaderOptions pdbOptions;

    public AbstractMsf(RandomAccessFile file, String filename, TaskMonitor monitor, PdbReaderOptions pdbOptions) throws IOException, PdbException {
        Objects.requireNonNull(file, "file may not be null");
        this.filename = Objects.requireNonNull(filename, "filename may not be null");
        this.monitor = TaskMonitor.dummyIfNull((TaskMonitor)monitor);
        this.pdbOptions = Objects.requireNonNull(pdbOptions, "PdbOptions may not be null");
        this.pageSize = 4096;
        this.configureParameters();
        this.fileReader = new MsfFileReader(this, file);
        this.create();
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public TaskMonitor getMonitor() {
        return this.monitor;
    }

    @Override
    public void checkCanceled() throws CancelledException {
        this.monitor.checkCanceled();
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public int getNumStreams() {
        return this.streamTable.getNumStreams();
    }

    @Override
    public MsfStream getStream(int streamNumber) {
        return this.streamTable.getStream(streamNumber);
    }

    @Override
    public MsfFileReader getFileReader() {
        return this.fileReader;
    }

    @Override
    public void close() throws IOException {
        if (this.fileReader != null) {
            this.fileReader.close();
        }
    }

    @Override
    public int getLog2PageSize() {
        return this.log2PageSize;
    }

    @Override
    public int getPageSizeModMask() {
        return this.pageSizeModMask;
    }

    @Override
    public int getNumSequentialFreePageMapPages() {
        return this.freePageMapNumSequentialPage;
    }

    @Override
    public int getHeaderPageNumber() {
        return 0;
    }

    @Override
    public int getDirectoryStreamNumber() {
        return 0;
    }

    @Override
    public int getNumPages() {
        return this.numPages;
    }

    @Override
    public int getCurrentFreePageMapFirstPageNumber() {
        return this.currentFreePageMapFirstPageNumber;
    }

    @Override
    public void deserialize() throws IOException, PdbException, CancelledException {
        byte[] bytes = new byte[this.getPageSize()];
        this.fileReader.read(this.getHeaderPageNumber(), 0, this.getPageSize(), bytes, 0);
        PdbByteReader reader = new PdbByteReader(bytes);
        reader.setIndex(this.getPageSizeOffset());
        this.pageSize = reader.parseInt();
        this.parseFreePageMapPageNumber(reader);
        this.parseCurrentNumPages(reader);
        this.configureParameters();
        this.directoryStream.deserializeStreamInfo(reader);
        this.freePageMap.deserialize();
        this.streamTable.deserialize(this.directoryStream);
    }
}

