/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.ModuleInformation;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbDebugInfo;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.SymbolParser;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.util.exception.CancelledException;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public class SymbolRecords {
    private AbstractPdb pdb;
    private Map<Long, AbstractMsSymbol> symbolsByOffset;
    private List<Map<Long, AbstractMsSymbol>> moduleSymbolsByOffset = new ArrayList<Map<Long, AbstractMsSymbol>>();

    public SymbolRecords(AbstractPdb pdb) {
        Objects.requireNonNull(pdb, "pdb cannot be null");
        this.pdb = pdb;
    }

    protected Map<Long, AbstractMsSymbol> getSymbolsByOffset() {
        return this.symbolsByOffset;
    }

    protected Map<Long, AbstractMsSymbol> getModuleSymbolsByOffset(int moduleNumber) {
        return this.moduleSymbolsByOffset.get(moduleNumber);
    }

    void deserialize() throws IOException, PdbException, CancelledException {
        this.processSymbols();
        this.processModuleSymbols();
    }

    private void processSymbols() throws IOException, PdbException, CancelledException {
        PdbDebugInfo debugInfo = this.pdb.getDebugInfo();
        if (debugInfo == null) {
            return;
        }
        int streamNumber = debugInfo.getSymbolRecordsStreamNumber();
        if (streamNumber <= 0) {
            return;
        }
        PdbByteReader reader = this.pdb.getReaderForStreamNumber(streamNumber);
        this.symbolsByOffset = SymbolRecords.deserializeSymbolRecords(this.pdb, reader);
    }

    private void processModuleSymbols() throws IOException, PdbException, CancelledException {
        boolean getSig = true;
        int cvSignature = 0;
        PdbDebugInfo debugInfo = this.pdb.getDebugInfo();
        if (debugInfo == null) {
            return;
        }
        for (ModuleInformation module : debugInfo.moduleInformationList) {
            this.pdb.checkCanceled();
            int streamNumber = module.getStreamNumberDebugInformation();
            if (streamNumber == 65535) {
                this.moduleSymbolsByOffset.add(new TreeMap());
                continue;
            }
            PdbByteReader reader = this.pdb.getReaderForStreamNumber(streamNumber);
            int sizeSymbolsSection = module.getSizeLocalSymbolsDebugInformation();
            PdbByteReader symbolsReader = reader.getSubPdbByteReader(sizeSymbolsSection);
            if (getSig) {
                cvSignature = symbolsReader.parseInt();
            }
            switch (cvSignature) {
                case 1: 
                case 2: {
                    getSig = false;
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    if (cvSignature >= 65536) break;
                    throw new PdbException("Invalid module CV signature in stream " + streamNumber);
                }
            }
            Map<Long, AbstractMsSymbol> oneModuleSymbolsByOffset = SymbolRecords.deserializeSymbolRecords(this.pdb, symbolsReader);
            this.moduleSymbolsByOffset.add(oneModuleSymbolsByOffset);
        }
    }

    public static Map<Long, AbstractMsSymbol> deserializeSymbolRecords(AbstractPdb pdb, PdbByteReader reader) throws PdbException, CancelledException {
        Objects.requireNonNull(pdb, "pdb cannot be null");
        TreeMap<Long, AbstractMsSymbol> mySymbolsByOffset = new TreeMap<Long, AbstractMsSymbol>();
        while (reader.hasMore()) {
            pdb.checkCanceled();
            int offset = reader.getIndex();
            AbstractMsSymbol symbol = SymbolParser.parseLengthAndSymbol(pdb, reader);
            mySymbolsByOffset.put(Long.valueOf(offset), symbol);
        }
        return mySymbolsByOffset;
    }

    protected void dump(Writer writer) throws IOException, CancelledException {
        writer.write("SymbolRecords-----------------------------------------------\n");
        this.dumpSymbolMap(this.symbolsByOffset, writer);
        for (int i = 0; i < this.moduleSymbolsByOffset.size(); ++i) {
            this.pdb.checkCanceled();
            Map<Long, AbstractMsSymbol> map = this.moduleSymbolsByOffset.get(i);
            if (map == null) continue;
            writer.write("Module(" + i + ") List:\n");
            this.dumpSymbolMap(map, writer);
        }
        writer.write("\nEnd SymbolRecords-------------------------------------------\n");
    }

    protected void dumpSymbolMap(Map<Long, AbstractMsSymbol> mySymbolsByOffset, Writer writer) throws IOException, CancelledException {
        writer.write("SymbolMap---------------------------------------------------");
        for (Map.Entry<Long, AbstractMsSymbol> entry : mySymbolsByOffset.entrySet()) {
            this.pdb.checkCanceled();
            StringBuilder builder = new StringBuilder();
            builder.append("\n------------------------------------------------------------\n");
            builder.append(String.format("Offset: 0X%08X\n", entry.getKey()));
            builder.append(entry.getValue());
            writer.write(builder.toString());
        }
        writer.write("\nEnd SymbolMap-----------------------------------------------\n");
    }
}

