/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.C13Section;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class C13CrossScopeExports
extends C13Section {
    private List<CrossScopeExport> crossScopeExports = new ArrayList<CrossScopeExport>();

    static C13CrossScopeExports parse(PdbByteReader reader, boolean ignore, TaskMonitor monitor) throws PdbException, CancelledException {
        return new C13CrossScopeExports(reader, ignore, monitor);
    }

    protected C13CrossScopeExports(PdbByteReader reader, boolean ignore, TaskMonitor monitor) throws CancelledException, PdbException {
        super(ignore);
        while (reader.numRemaining() >= CrossScopeExport.getBaseRecordSize()) {
            monitor.checkCanceled();
            CrossScopeExport crossExport = new CrossScopeExport(reader);
            this.crossScopeExports.add(crossExport);
        }
        if (reader.hasMore()) {
            Msg.debug(C13CrossScopeExports.class, (Object)String.format("Num Extra C13CrossScopeExports bytes: %d", reader.numRemaining()));
        }
    }

    List<CrossScopeExport> getCrossScopeExports() {
        return this.crossScopeExports;
    }

    public String toString() {
        return String.format("%s: num cross-scope exports = %d", this.getClass().getSimpleName(), this.crossScopeExports.size());
    }

    @Override
    void dump(Writer writer) throws IOException {
        writer.write("C13CrossScopeExports----------------------------------------\n");
        for (CrossScopeExport crossScopeExport : this.crossScopeExports) {
            writer.write(crossScopeExport.toString());
            writer.write(10);
        }
        writer.write("End C13CrossScopeExports------------------------------------\n");
    }

    static class CrossScopeExport {
        private long localId;
        private long globalId;

        private static int getBaseRecordSize() {
            return 8;
        }

        CrossScopeExport(PdbByteReader reader) throws PdbException {
            this.localId = reader.parseUnsignedIntVal();
            this.globalId = reader.parseUnsignedIntVal();
        }

        long getLocalId() {
            return this.localId;
        }

        long getGlobalId() {
            return this.globalId;
        }

        public String toString() {
            return String.format("0x%08x, 0x%08x", this.localId, this.globalId);
        }
    }
}

