/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.relocation;

import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.RelocationInfo;
import ghidra.app.util.bin.format.macho.relocation.MachoRelocation;
import ghidra.app.util.bin.format.macho.relocation.MachoRelocationHandler;
import ghidra.program.model.address.Address;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.exception.NotFoundException;

public class X86_32_MachoRelocationHandler
extends MachoRelocationHandler {
    public boolean canRelocate(MachHeader header) {
        return header.getCpuType() == 7;
    }

    public boolean isPairedRelocation(RelocationInfo relocation) {
        return relocation.getType() == 2 || relocation.getType() == 4;
    }

    public void relocate(MachoRelocation relocation) throws MemoryAccessException, NotFoundException {
        if (!relocation.requiresRelocation()) {
            return;
        }
        RelocationInfo relocationInfo = relocation.getRelocationInfo();
        Address relocAddr = relocation.getRelocationAddress();
        Address targetAddr = relocation.getTargetAddress();
        switch (relocationInfo.getType()) {
            case 0: {
                if (relocationInfo.isPcRelocated()) {
                    X86_32_MachoRelocationHandler.write((MachoRelocation)relocation, (long)(targetAddr.subtract(relocAddr) - 4L));
                    break;
                }
                X86_32_MachoRelocationHandler.write((MachoRelocation)relocation, (long)targetAddr.getOffset());
                break;
            }
            default: {
                throw new NotFoundException("Unimplemented relocation");
            }
        }
    }
}

