/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg;

import ghidra.async.AsyncUtils;
import ghidra.async.DisposedException;
import ghidra.async.TypeSpec;
import ghidra.dbg.DebuggerModelListener;
import ghidra.dbg.DebuggerTargetObjectIface;
import ghidra.dbg.error.DebuggerIllegalArgumentException;
import ghidra.dbg.error.DebuggerModelNoSuchPathException;
import ghidra.dbg.error.DebuggerModelTerminatingException;
import ghidra.dbg.error.DebuggerModelTypeException;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.EnumerableTargetObjectSchema;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.util.PathUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.util.Msg;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Predicate;

public interface DebuggerObjectModel {
    public static final TypeSpec<Map<String, ? extends TargetObject>> ELEMENT_MAP_TYPE;
    public static final TypeSpec<Map<String, ?>> ATTRIBUTE_MAP_TYPE;

    public static String requireIfaceName(Class<? extends TargetObject> iface) {
        DebuggerTargetObjectIface annot = iface.getAnnotation(DebuggerTargetObjectIface.class);
        if (annot == null) {
            throw new IllegalArgumentException(iface + " has no @" + DebuggerTargetObjectIface.class.getSimpleName() + " annotation.");
        }
        return annot.value();
    }

    public static <T> T requireNonNull(T val, List<String> path) {
        if (val == null) {
            throw new DebuggerModelNoSuchPathException("Path " + path + " does not exist");
        }
        return val;
    }

    public static <T extends TargetObject> T requireIface(Class<T> iface, TargetObject obj, List<String> path) {
        DebuggerObjectModel.requireNonNull(obj, path);
        String name = DebuggerObjectModel.requireIfaceName(iface);
        if (iface.isAssignableFrom(obj.getClass())) {
            return (T)((TargetObject)iface.cast(obj));
        }
        throw new DebuggerModelTypeException("Object " + path + " is missing " + name);
    }

    default public String getBrief() {
        return this.toString();
    }

    public void addModelListener(DebuggerModelListener var1, boolean var2);

    default public void addModelListener(DebuggerModelListener listener) {
        this.addModelListener(listener, false);
    }

    public void removeModelListener(DebuggerModelListener var1);

    public boolean isAlive();

    default public TargetObjectSchema getRootSchema() {
        return EnumerableTargetObjectSchema.OBJECT;
    }

    public CompletableFuture<Void> ping(String var1);

    default public <T extends TargetObject> T assertMine(Class<T> cls, TargetObject obj) {
        if (obj.getModel() != this) {
            throw new DebuggerIllegalArgumentException("TargetObject " + obj + " does not belong to this model");
        }
        return (T)((TargetObject)cls.cast(obj));
    }

    public CompletableFuture<? extends Map<String, ?>> fetchObjectAttributes(List<String> var1, boolean var2);

    default public CompletableFuture<? extends Map<String, ?>> fetchObjectAttributes(List<String> path) {
        return this.fetchObjectAttributes(path, false);
    }

    default public CompletableFuture<? extends Map<String, ?>> fetchObjectAttributes(String ... path) {
        return this.fetchObjectAttributes(List.of(path));
    }

    public CompletableFuture<? extends Map<String, ? extends TargetObject>> fetchObjectElements(List<String> var1, boolean var2);

    default public CompletableFuture<? extends Map<String, ? extends TargetObject>> fetchObjectElements(List<String> path) {
        return this.fetchObjectElements(path, false);
    }

    default public CompletableFuture<? extends Map<String, ? extends TargetObject>> fetchObjectElements(String ... path) {
        return this.fetchObjectElements(List.of(path));
    }

    public CompletableFuture<? extends TargetObject> fetchModelRoot();

    public TargetObject getModelRoot();

    public CompletableFuture<?> fetchModelValue(List<String> var1);

    public CompletableFuture<?> fetchModelValue(List<String> var1, boolean var2);

    default public CompletableFuture<?> fetchModelValue(String ... path) {
        return this.fetchModelValue(List.of(path));
    }

    default public Object getModelValue(List<String> path) {
        Object cur = this.getModelRoot();
        for (String key : path) {
            if (cur == null) {
                return null;
            }
            if (!(cur instanceof TargetObject)) {
                Msg.error((Object)this, (Object)("Primitive " + cur + " cannot have child '" + key + "'"));
                return null;
            }
            TargetObject obj = cur;
            if (PathUtils.isIndex(key)) {
                cur = obj.getCachedElements().get(PathUtils.parseIndex(key));
                continue;
            }
            if (!1.$assertionsDisabled && !PathUtils.isName(key)) {
                throw new AssertionError();
            }
            cur = obj.getCachedAttribute(key);
        }
        return cur;
    }

    default public CompletableFuture<? extends TargetObject> fetchModelObject(List<String> path, boolean refresh) {
        return this.fetchModelValue(path, refresh).thenApply(v -> {
            if (v == null) {
                return null;
            }
            if (!(v instanceof TargetObject)) {
                throw DebuggerModelTypeException.typeRequired(v, path, TargetObject.class);
            }
            return (TargetObject)v;
        });
    }

    @Deprecated
    default public CompletableFuture<? extends TargetObject> fetchModelObject(List<String> path) {
        return this.fetchModelObject(path, false);
    }

    public TargetObject getModelObject(List<String> var1);

    public Set<TargetObject> getModelObjects(Predicate<? super TargetObject> var1);

    @Deprecated
    default public CompletableFuture<? extends TargetObject> fetchModelObject(String ... path) {
        return this.fetchModelObject(List.of(path));
    }

    default public TargetObject getModelObject(String ... path) {
        return this.getModelObject(List.of(path));
    }

    default public CompletableFuture<?> fetchObjectAttribute(List<String> path) {
        return this.fetchModelObject(PathUtils.parent(path)).thenApply(parent -> parent == null ? null : parent.fetchAttribute(PathUtils.getKey(path)));
    }

    default public CompletableFuture<?> getObjectAttribute(String ... path) {
        return this.fetchObjectAttribute(List.of(path));
    }

    public AddressFactory getAddressFactory();

    default public AddressSpace getAddressSpace(String name) {
        return this.getAddressFactory().getAddressSpace(name);
    }

    default public Address getAddress(String space, long offset) {
        if (Address.NO_ADDRESS.getAddressSpace().getName().equals(space)) {
            return Address.NO_ADDRESS;
        }
        return this.getAddressSpace(space).getAddress(offset);
    }

    public void invalidateAllLocalCaches();

    public CompletableFuture<Void> close();

    default public void reportError(Object origin, String message, Throwable ex) {
        Throwable unwrapped = AsyncUtils.unwrapThrowable((Throwable)ex);
        if (ex == null || DebuggerModelTerminatingException.isIgnorable(ex)) {
            Msg.warn((Object)origin, (Object)(message + ": " + ex));
        } else if (unwrapped instanceof RejectedExecutionException) {
            Msg.trace((Object)origin, (Object)"Ignoring rejection", (Throwable)ex);
        } else if (unwrapped instanceof DisposedException) {
            Msg.trace((Object)origin, (Object)"Ignoring disposal", (Throwable)ex);
        } else {
            Msg.error((Object)origin, (Object)message, (Throwable)ex);
        }
    }

    public CompletableFuture<Void> flushEvents();

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        ELEMENT_MAP_TYPE = TypeSpec.auto();
        ATTRIBUTE_MAP_TYPE = TypeSpec.auto();
    }
}

