/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.model.impl;

import agent.gdb.manager.impl.GdbMinimalSymbol;
import agent.gdb.model.impl.GdbModelImpl;
import agent.gdb.model.impl.GdbModelTargetModule;
import agent.gdb.model.impl.GdbModelTargetSymbol;
import ghidra.dbg.agent.AbstractDebuggerObjectModel;
import ghidra.dbg.agent.DefaultTargetObject;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetSymbolNamespace;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@TargetObjectSchemaInfo(name="SymbolContainer", elementResync=TargetObjectSchema.ResyncMode.ONCE, attributes={@TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class GdbModelTargetSymbolContainer
extends DefaultTargetObject<GdbModelTargetSymbol, GdbModelTargetModule>
implements TargetSymbolNamespace {
    public static final String NAME = "Symbols";
    protected final GdbModelImpl impl;
    protected final GdbModelTargetModule module;

    public GdbModelTargetSymbolContainer(GdbModelTargetModule module) {
        super((AbstractDebuggerObjectModel)module.impl, (TargetObject)module, NAME, "SymbolContainer");
        this.impl = module.impl;
        this.module = module;
    }

    public CompletableFuture<Void> requestElements(boolean refresh) {
        return this.module.module.listMinimalSymbols().thenAccept(byName -> {
            List symbols;
            GdbModelTargetSymbolContainer gdbModelTargetSymbolContainer = this;
            synchronized (gdbModelTargetSymbolContainer) {
                symbols = byName.values().stream().map(this::getTargetSymbol).collect(Collectors.toList());
            }
            this.setElements(symbols, "Refreshed");
        });
    }

    protected synchronized GdbModelTargetSymbol getTargetSymbol(GdbMinimalSymbol symbol) {
        TargetObject modelObject = this.impl.getModelObject(symbol);
        if (modelObject != null) {
            return (GdbModelTargetSymbol)modelObject;
        }
        return new GdbModelTargetSymbol(this, symbol);
    }
}

