/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database.spatial;

import ghidra.util.database.spatial.BoundedShape;

public interface BoundingShape<S extends BoundingShape<S>>
extends BoundedShape<S> {
    public double getArea();

    public double getMargin();

    public double computeCentroidDistance(S var1);

    public double computeAreaUnionBounds(S var1);

    public boolean encloses(S var1);

    public double computeAreaIntersection(S var1);

    public S unionBounds(S var1);

    public static <S extends BoundingShape<S>> S boundsUnion(Iterable<? extends S> shapes) {
        BoundingShape result = null;
        for (BoundingShape s : shapes) {
            if (result == null) {
                result = s;
                continue;
            }
            result = result.unionBounds(s);
        }
        return (S)result;
    }
}

