/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec;

import ghidra.app.plugin.processors.sleigh.ParserWalker;
import ghidra.app.plugin.processors.sleigh.PcodeEmitObjects;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.SleighParserContext;
import ghidra.app.plugin.processors.sleigh.UniqueLayout;
import ghidra.app.plugin.processors.sleigh.template.ConstructTpl;
import ghidra.pcode.exec.PcodeExpression;
import ghidra.pcode.exec.PcodeProgram;
import ghidra.pcode.exec.PcodeUseropLibrary;
import ghidra.pcodeCPort.pcoderaw.VarnodeData;
import ghidra.pcodeCPort.sleighbase.SleighBase;
import ghidra.pcodeCPort.slghsymbol.SleighSymbol;
import ghidra.pcodeCPort.slghsymbol.UserOpSymbol;
import ghidra.pcodeCPort.slghsymbol.VarnodeSymbol;
import ghidra.pcodeCPort.space.AddrSpace;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.PcodeParser;
import ghidra.program.model.lang.UnknownInstructionException;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import ghidra.sleigh.grammar.Location;
import ghidra.util.Msg;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class SleighProgramCompiler {
    private static final String EXPRESSION_SOURCE_NAME = "expression";
    public static final String NIL_SYMBOL_NAME = "__nil";

    public static PcodeParser createParser(SleighLanguage language) {
        return new PcodeParser(language, UniqueLayout.INJECT.getOffset(language));
    }

    public static ConstructTpl compileTemplate(Language language, PcodeParser parser, String sourceName, String source) {
        return parser.compilePcode(source, EXPRESSION_SOURCE_NAME, 1);
    }

    public static List<PcodeOp> buildOps(Language language, ConstructTpl template) throws UnknownInstructionException, MemoryAccessException, IOException {
        Address zero = language.getDefaultSpace().getAddress(0L);
        SleighParserContext c = new SleighParserContext(zero, zero, zero, zero);
        ParserWalker walk = new ParserWalker(c);
        PcodeEmitObjects emit = new PcodeEmitObjects(walk);
        emit.build(template, 0);
        emit.resolveRelatives();
        return List.of(emit.getPcodeOp());
    }

    protected static void addParserSymbols(PcodeParser parser, Map<Integer, UserOpSymbol> symbols) {
        for (UserOpSymbol sym : symbols.values()) {
            parser.addSymbol((SleighSymbol)sym);
        }
    }

    protected static VarnodeSymbol addNilSymbol(PcodeParser parser) {
        SleighSymbol exists = parser.findSymbol(NIL_SYMBOL_NAME);
        if (exists != null) {
            return (VarnodeSymbol)exists;
        }
        long offset = parser.allocateTemp();
        VarnodeSymbol nil = new VarnodeSymbol(new Location("<util>", 0), NIL_SYMBOL_NAME, parser.getUniqueSpace(), offset, 1);
        parser.addSymbol((SleighSymbol)nil);
        return nil;
    }

    public static <T extends PcodeProgram> T constructProgram(PcodeProgramConstructor<T> ctor, SleighLanguage language, ConstructTpl template, Map<Integer, UserOpSymbol> libSyms) {
        try {
            return ctor.construct(language, SleighProgramCompiler.buildOps((Language)language, template), libSyms);
        }
        catch (UnknownInstructionException | MemoryAccessException | IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static PcodeProgram compileProgram(SleighLanguage language, String sourceName, String source, PcodeUseropLibrary<?> library) {
        PcodeParser parser = SleighProgramCompiler.createParser(language);
        Map<Integer, UserOpSymbol> symbols = library.getSymbols(language);
        SleighProgramCompiler.addParserSymbols(parser, symbols);
        ConstructTpl template = SleighProgramCompiler.compileTemplate((Language)language, parser, sourceName, source);
        return SleighProgramCompiler.constructProgram(PcodeProgram::new, language, template, symbols);
    }

    public static PcodeExpression compileExpression(SleighLanguage language, String expression) {
        PcodeParser parser = SleighProgramCompiler.createParser(language);
        Map<Integer, UserOpSymbol> symbols = PcodeExpression.CAPTURING.getSymbols(language);
        SleighProgramCompiler.addParserSymbols(parser, symbols);
        ConstructTpl template = SleighProgramCompiler.compileTemplate((Language)language, parser, EXPRESSION_SOURCE_NAME, "___result(" + expression + ");");
        return SleighProgramCompiler.constructProgram(PcodeExpression::new, language, template, symbols);
    }

    public static VarnodeSymbol paramSym(Language language, SleighBase sleigh, String opName, String paramName, Varnode arg) {
        AddressSpace gSpace = language.getAddressFactory().getAddressSpace(arg.getSpace());
        AddrSpace sSpace = sleigh.getSpace(gSpace.getUnique());
        return new VarnodeSymbol(new Location(opName, 0), paramName, sSpace, arg.getOffset(), arg.getSize());
    }

    public static PcodeProgram compileUserop(SleighLanguage language, String opName, List<String> params, String source, PcodeUseropLibrary<?> library, List<Varnode> args) {
        PcodeParser parser = SleighProgramCompiler.createParser(language);
        Map<Integer, UserOpSymbol> symbols = library.getSymbols(language);
        SleighProgramCompiler.addParserSymbols(parser, symbols);
        SleighBase sleigh = parser.getSleigh();
        int count = params.size();
        if (args.size() != count) {
            throw new IllegalArgumentException("Mismatch of params and args sizes");
        }
        VarnodeSymbol nil = SleighProgramCompiler.addNilSymbol(parser);
        VarnodeData nilVnData = nil.getFixedVarnode();
        for (int i = 0; i < count; ++i) {
            String p = params.get(i);
            Varnode a = args.get(i);
            if (a == null && i == 0) {
                parser.addSymbol((SleighSymbol)new VarnodeSymbol(nil.getLocation(), p, nilVnData.space, nilVnData.offset, nilVnData.size));
                continue;
            }
            parser.addSymbol((SleighSymbol)SleighProgramCompiler.paramSym((Language)language, sleigh, opName, p, a));
        }
        try {
            ConstructTpl template = SleighProgramCompiler.compileTemplate((Language)language, parser, opName, source);
            return SleighProgramCompiler.constructProgram(PcodeProgram::new, language, template, symbols);
        }
        catch (Throwable t) {
            Msg.error(SleighProgramCompiler.class, (Object)("Error trying to compile userop:\n" + source));
            throw t;
        }
    }

    public static interface PcodeProgramConstructor<T extends PcodeProgram> {
        public T construct(SleighLanguage var1, List<PcodeOp> var2, Map<Integer, UserOpSymbol> var3);
    }
}

