/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec;

import ghidra.pcode.exec.AddressOfPcodeArithmetic;
import ghidra.pcode.exec.BytesPcodeArithmetic;
import ghidra.pcode.exec.ConcretionError;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.mem.MemBuffer;
import java.util.HashMap;
import java.util.Map;

public class AddressOfPcodeExecutorStatePiece
implements PcodeExecutorStatePiece<byte[], Address> {
    private final Language language;
    private final BytesPcodeArithmetic addressArithmetic;
    private final Map<Long, Address> unique = new HashMap<Long, Address>();

    public AddressOfPcodeExecutorStatePiece(Language language) {
        this.language = language;
        this.addressArithmetic = BytesPcodeArithmetic.forEndian(language.isBigEndian());
    }

    @Override
    public Language getLanguage() {
        return this.language;
    }

    @Override
    public PcodeArithmetic<byte[]> getAddressArithmetic() {
        return this.addressArithmetic;
    }

    @Override
    public PcodeArithmetic<Address> getArithmetic() {
        return AddressOfPcodeArithmetic.INSTANCE;
    }

    @Override
    public void setVar(AddressSpace space, byte[] offset, int size, boolean quantize, Address val) {
        if (!space.isUniqueSpace()) {
            return;
        }
        long lOffset = this.addressArithmetic.toLong(offset, PcodeArithmetic.Purpose.STORE);
        this.unique.put(lOffset, val);
    }

    @Override
    public Address getVar(AddressSpace space, byte[] offset, int size, boolean quantize, PcodeExecutorStatePiece.Reason reason) {
        long lOffset = this.addressArithmetic.toLong(offset, PcodeArithmetic.Purpose.LOAD);
        if (!space.isUniqueSpace()) {
            return space.getAddress(lOffset);
        }
        return this.unique.get(lOffset);
    }

    @Override
    public MemBuffer getConcreteBuffer(Address address, PcodeArithmetic.Purpose purpose) {
        throw new ConcretionError("Cannot make 'address of' concrete buffers", purpose);
    }

    @Override
    public void clear() {
        this.unique.clear();
    }
}

