/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu;

import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.pcode.emu.PcodeMachine;
import ghidra.pcode.emu.ThreadPcodeExecutorState;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.PcodeExecutor;
import ghidra.pcode.exec.PcodeFrame;
import ghidra.pcode.exec.PcodeUseropLibrary;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.Instruction;

public interface PcodeThread<T> {
    public String getName();

    public PcodeMachine<T> getMachine();

    public void setCounter(Address var1);

    public Address getCounter();

    public void overrideCounter(Address var1);

    public void assignContext(RegisterValue var1);

    public RegisterValue getContext();

    public void overrideContext(RegisterValue var1);

    public void overrideContextWithDefault();

    public void reInitialize();

    public void stepInstruction();

    default public void stepInstruction(long count) {
        for (long i = 0L; i < count; ++i) {
            this.stepInstruction();
        }
    }

    public void stepPcodeOp();

    default public void stepPcodeOp(long count) {
        for (long i = 0L; i < count; ++i) {
            this.stepPcodeOp();
        }
    }

    public void skipPcodeOp();

    public PcodeFrame getFrame();

    public Instruction getInstruction();

    public void executeInstruction();

    public void finishInstruction();

    public void skipInstruction();

    public void dropInstruction();

    public void run();

    public void setSuspended(boolean var1);

    public SleighLanguage getLanguage();

    public PcodeArithmetic<T> getArithmetic();

    public PcodeExecutor<T> getExecutor();

    public PcodeUseropLibrary<T> getUseropLibrary();

    public ThreadPcodeExecutorState<T> getState();

    public void inject(Address var1, String var2);

    public void clearInject(Address var1);

    public void clearAllInjects();
}

