/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu;

import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.pcode.emu.AbstractPcodeMachine;
import ghidra.pcode.emu.DefaultPcodeThread;
import ghidra.pcode.emulate.BreakTable;
import ghidra.pcode.emulate.BreakTableCallBack;
import ghidra.pcode.emulate.Emulate;
import ghidra.pcode.emulate.EmulateInstructionStateModifier;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.memstate.MemoryState;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.util.Msg;
import java.lang.reflect.Constructor;

public class ModifiedPcodeThread<T>
extends DefaultPcodeThread<T> {
    protected final EmulateInstructionStateModifier modifier;
    protected final Emulate emulate;
    protected Address savedCounter;

    public ModifiedPcodeThread(String name, AbstractPcodeMachine<T> machine) {
        super(name, machine);
        this.emulate = new GlueEmulate(this.language, new GlueMemoryState((Language)this.language), (BreakTable)new BreakTableCallBack(this.language));
        this.modifier = this.createModifier();
    }

    protected EmulateInstructionStateModifier createModifier() {
        String classname = this.language.getProperty("emulateInstructionStateModifierClass");
        if (classname == null) {
            return null;
        }
        try {
            Class<?> c = Class.forName(classname);
            if (!EmulateInstructionStateModifier.class.isAssignableFrom(c)) {
                Msg.error((Object)this, (Object)("Language " + this.language.getLanguageID() + " does not specify a valid emulateInstructionStateModifierClass"));
                throw new RuntimeException(classname + " does not implement interface " + EmulateInstructionStateModifier.class.getName());
            }
            Constructor<?> constructor = c.getConstructor(Emulate.class);
            return (EmulateInstructionStateModifier)constructor.newInstance(this.emulate);
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)("Language " + this.language.getLanguageID() + " does not specify a valid emulateInstructionStateModifierClass"));
            throw new RuntimeException("Failed to instantiate " + classname + " for language " + this.language.getLanguageID(), e);
        }
    }

    protected int getBytesChunk(byte[] res, AddressSpace spc, long off, int size, boolean stopOnUnintialized) {
        long t = this.state.getVar(spc, off, size, true, this.executor.getReason());
        byte[] val = this.arithmetic.toConcrete(t, PcodeArithmetic.Purpose.OTHER);
        System.arraycopy(val, 0, res, 0, val.length);
        return val.length;
    }

    protected void setBytesChunk(byte[] val, AddressSpace spc, long off, int size) {
        Object t = this.arithmetic.fromConst(val);
        this.state.setVar(spc, off, size, true, t);
    }

    @Override
    protected void preExecuteInstruction() {
        if (this.modifier != null) {
            this.savedCounter = this.getCounter();
            this.modifier.initialExecuteCallback(this.emulate, this.savedCounter, this.getContext());
        }
    }

    @Override
    protected void postExecuteInstruction() {
        if (this.modifier != null) {
            this.modifier.postExecuteCallback(this.emulate, this.savedCounter, this.frame.copyCode(), this.frame.getBranched(), this.getCounter());
        }
    }

    @Override
    protected boolean onMissingUseropDef(PcodeOp op, String opName) {
        if (this.modifier != null) {
            return this.modifier.executeCallOther(op);
        }
        return super.onMissingUseropDef(op, opName);
    }

    protected class GlueEmulate
    extends Emulate {
        public GlueEmulate(SleighLanguage lang, MemoryState s, BreakTable b) {
            super(lang, s, b);
        }

        public Language getLanguage() {
            return ModifiedPcodeThread.this.language;
        }

        public void setExecuteAddress(Address addr) {
            ModifiedPcodeThread.this.overrideCounter(addr);
        }

        public Address getExecuteAddress() {
            return ModifiedPcodeThread.this.getCounter();
        }

        public void setContextRegisterValue(RegisterValue regValue) {
            ModifiedPcodeThread.this.overrideContext(regValue);
        }

        public RegisterValue getContextRegisterValue() {
            return ModifiedPcodeThread.this.getContext();
        }
    }

    protected class GlueMemoryState
    extends MemoryState {
        public GlueMemoryState(Language language) {
            super(language);
        }

        public int getChunk(byte[] res, AddressSpace spc, long off, int size, boolean stopOnUnintialized) {
            return ModifiedPcodeThread.this.getBytesChunk(res, spc, off, size, stopOnUnintialized);
        }

        public void setChunk(byte[] val, AddressSpace spc, long off, int size) {
            ModifiedPcodeThread.this.setBytesChunk(val, spc, off, size);
        }

        public void setInitialized(boolean initialized, AddressSpace spc, long off, int size) {
        }
    }
}

