/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import com.google.common.collect.Range;
import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.RangedRenderer;
import ghidra.docking.settings.Settings;
import ghidra.util.table.column.AbstractGColumnRenderer;
import java.awt.Component;
import java.awt.Graphics;

public class RangeTableCellRenderer<N extends Number>
extends AbstractGColumnRenderer<Range<N>>
implements RangedRenderer<N> {
    protected Range<Double> fullRangeDouble = Range.closed((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0));
    protected double span = 1.0;
    protected Range<N> fullRange;
    protected Range<N> dataRange;

    @Override
    public void setFullRange(Range<N> fullRange) {
        this.fullRange = fullRange;
        this.fullRangeDouble = RangedRenderer.validateViewRange(fullRange);
        this.span = (Double)this.fullRangeDouble.upperEndpoint() - (Double)this.fullRangeDouble.lowerEndpoint();
    }

    public String getFilterString(Range<N> t, Settings settings) {
        return "";
    }

    public Component getTableCellRendererComponent(GTableCellRenderingData data) {
        this.dataRange = (Range)data.getValue();
        super.getTableCellRendererComponent(data);
        this.setText("");
        return this;
    }

    protected void paintComponent(Graphics parentG) {
        super.paintComponent(parentG);
        if (this.dataRange == null) {
            return;
        }
        Graphics g = parentG.create();
        g.setColor(this.getForeground());
        this.paintRange(g, this.dataRange);
    }

    @Override
    public Range<N> getFullRange() {
        return this.fullRange;
    }

    @Override
    public Range<Double> getFullRangeDouble() {
        return this.fullRangeDouble;
    }

    @Override
    public double getSpan() {
        return this.span;
    }
}

