/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.RangedRenderer;
import ghidra.docking.settings.Settings;
import ghidra.util.table.column.AbstractGColumnRenderer;
import java.awt.Component;
import java.awt.Graphics;

public class RangeSetTableCellRenderer<N extends Number>
extends AbstractGColumnRenderer<RangeSet<N>>
implements RangedRenderer<N> {
    protected Range<Double> fullRangeDouble = Range.closed((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0));
    protected double span = 1.0;
    protected Range<N> fullRange;
    protected RangeSet<N> dataRangeSet;

    @Override
    public void setFullRange(Range<N> fullRange) {
        this.fullRange = fullRange;
        this.fullRangeDouble = RangedRenderer.validateViewRange(fullRange);
        this.span = (Double)this.fullRangeDouble.upperEndpoint() - (Double)this.fullRangeDouble.lowerEndpoint();
    }

    public String getFilterString(RangeSet<N> t, Settings settings) {
        return "";
    }

    public Component getTableCellRendererComponent(GTableCellRenderingData data) {
        this.dataRangeSet = (RangeSet)data.getValue();
        super.getTableCellRendererComponent(data);
        this.setText("");
        return this;
    }

    protected void paintComponent(Graphics parentG) {
        super.paintComponent(parentG);
        if (this.dataRangeSet == null || this.dataRangeSet.isEmpty()) {
            return;
        }
        Graphics g = parentG.create();
        g.setColor(this.getForeground());
        for (Range range : this.dataRangeSet.asRanges()) {
            this.paintRange(g, range);
        }
    }

    @Override
    public Range<N> getFullRange() {
        return this.fullRange;
    }

    @Override
    public Range<Double> getFullRangeDouble() {
        return this.fullRangeDouble;
    }

    @Override
    public double getSpan() {
        return this.span;
    }
}

