/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.relocation;

import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.RelocationInfo;
import ghidra.app.util.bin.format.macho.relocation.MachoRelocation;
import ghidra.app.util.bin.format.macho.relocation.MachoRelocationHandler;
import ghidra.program.model.address.Address;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.exception.NotFoundException;

public class AARCH64_MachoRelocationHandler
extends MachoRelocationHandler {
    public boolean canRelocate(MachHeader header) {
        return header.getCpuType() == 0x100000C;
    }

    public boolean isPairedRelocation(RelocationInfo relocation) {
        return relocation.getType() == 1 || relocation.getType() == 10;
    }

    public void relocate(MachoRelocation relocation) throws MemoryAccessException, NotFoundException {
        long addendFromReloc;
        Address targetAddr;
        if (!relocation.requiresRelocation()) {
            return;
        }
        RelocationInfo relocationInfo = relocation.getRelocationInfo();
        Address relocAddr = relocation.getRelocationAddress();
        if (relocationInfo.getType() == 10) {
            targetAddr = relocation.getTargetAddressExtra();
            addendFromReloc = relocationInfo.getValue();
            relocationInfo = relocation.getRelocationInfoExtra();
        } else {
            targetAddr = relocation.getTargetAddress();
            addendFromReloc = 0L;
        }
        long orig = AARCH64_MachoRelocationHandler.read((MachoRelocation)relocation);
        switch (relocationInfo.getType()) {
            case 0: 
            case 7: {
                long addend = orig;
                long value = targetAddr.getOffset() + addend;
                AARCH64_MachoRelocationHandler.write((MachoRelocation)relocation, (long)value);
                break;
            }
            case 1: {
                Address targetAddrExtra = relocation.getTargetAddressExtra();
                if (orig > 0L) {
                    AARCH64_MachoRelocationHandler.write((MachoRelocation)relocation, (long)targetAddrExtra.add(orig).subtract(targetAddr));
                    break;
                }
                AARCH64_MachoRelocationHandler.write((MachoRelocation)relocation, (long)targetAddr.add(orig).subtract(targetAddrExtra));
                break;
            }
            case 2: {
                long addend = orig & 0x3FFFFFFL;
                long value = (targetAddr.subtract(relocAddr) >> 2) + addend;
                long instr = orig | value & 0x3FFFFFFL;
                AARCH64_MachoRelocationHandler.write((MachoRelocation)relocation, (long)instr);
                break;
            }
            case 3: 
            case 5: {
                long immlo = orig >> 29 & 3L;
                long immhi = orig >> 5 & 0x7FFFFL;
                long addend = (immhi << 2 | immlo) << 12;
                long pageTarget = this.PG(targetAddr.getOffset() + (addend += addendFromReloc));
                long pageReloc = this.PG(relocAddr.getOffset());
                long value = pageTarget - pageReloc >> 12 & 0x1FFFFFL;
                long instr = orig & 0xFFFFFFFF9F00001FL | value << 3 & 0x7FFFFE0L | (value & 3L) << 29;
                AARCH64_MachoRelocationHandler.write((MachoRelocation)relocation, (long)instr);
                break;
            }
            case 4: 
            case 6: {
                long instr;
                long addend = addendFromReloc;
                if ((orig & 0x8000000L) > 0L) {
                    long size = orig >> 30 & 3L;
                    long value = (targetAddr.getOffset() + (addend += orig >> 10 & 0xFFFL) & 0xFFFL) >> (int)size;
                    instr = orig | value << 10;
                } else {
                    long value = targetAddr.getOffset() + (addend += orig >> 10 & 0xFFFL) & 0xFFFL;
                    instr = orig | value << 10;
                }
                AARCH64_MachoRelocationHandler.write((MachoRelocation)relocation, (long)instr);
                break;
            }
            case 11: {
                long addend = orig & 0xFFFFFFFFL;
                long value = targetAddr.getOffset() + addend;
                AARCH64_MachoRelocationHandler.write((MachoRelocation)relocation, (long)value);
                break;
            }
            default: {
                throw new NotFoundException("Unimplemented relocation");
            }
        }
    }

    private long PG(long addr) {
        return addr & 0xFFFFFFFFFFFFF000L;
    }
}

