/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.model.iface2;

import agent.dbgeng.dbgeng.DebugSystemObjects;
import agent.dbgeng.dbgeng.DebugThreadId;
import agent.dbgeng.manager.DbgEventsListenerAdapter;
import agent.dbgeng.manager.DbgReason;
import agent.dbgeng.manager.DbgState;
import agent.dbgeng.manager.DbgThread;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import agent.dbgeng.manager.impl.DbgProcessImpl;
import agent.dbgeng.manager.impl.DbgThreadImpl;
import agent.dbgeng.model.iface1.DbgModelSelectableObject;
import agent.dbgeng.model.iface1.DbgModelTargetAccessConditioned;
import agent.dbgeng.model.iface1.DbgModelTargetExecutionStateful;
import agent.dbgeng.model.iface1.DbgModelTargetSteppable;
import agent.dbgeng.model.iface2.DbgModelTargetProcess;
import agent.dbgeng.model.impl.DbgModelTargetStackImpl;
import ghidra.dbg.target.TargetThread;
import ghidra.dbg.util.PathUtils;
import java.util.concurrent.CompletableFuture;

public interface DbgModelTargetThread
extends TargetThread,
DbgModelTargetAccessConditioned,
DbgModelTargetExecutionStateful,
DbgModelTargetSteppable,
DbgEventsListenerAdapter,
DbgModelSelectableObject {
    default public DbgThread getThread() {
        return this.getThread(false);
    }

    default public DbgThread getThread(boolean fire) {
        DbgManagerImpl manager = this.getManager();
        DebugSystemObjects so = manager.getSystemObjects();
        try {
            String index = PathUtils.parseIndex((String)this.getName());
            int tid = Integer.decode(index);
            DebugThreadId id = so.getThreadIdBySystemId(tid);
            if (id == null) {
                id = so.getCurrentThreadId();
            }
            DbgModelTargetProcess parentProcess = this.getParentProcess();
            DbgProcessImpl process = (DbgProcessImpl)parentProcess.getProcess();
            DbgThreadImpl thread = manager.getThreadComputeIfAbsent(id, process, tid, fire);
            return thread;
        }
        catch (IllegalArgumentException e) {
            return manager.getCurrentThread();
        }
    }

    @Override
    default public CompletableFuture<Void> setActive() {
        DbgManagerImpl manager = this.getManager();
        DbgProcessImpl process = (DbgProcessImpl)this.getParentProcess().getProcess();
        manager.setActiveProcess(process);
        return manager.setActiveThread(this.getThread());
    }

    public DbgModelTargetStackImpl getStack();

    public String getExecutingProcessorType();

    public void threadStateChangedSpecific(DbgState var1, DbgReason var2);
}

