/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.model.iface2;

import agent.dbgeng.manager.DbgEventsListenerAdapter;
import agent.dbgeng.manager.breakpoint.DbgBreakpointType;
import agent.dbgeng.model.iface2.DbgModelTargetBreakpointSpec;
import agent.dbgeng.model.iface2.DbgModelTargetObject;
import ghidra.async.AsyncFence;
import ghidra.dbg.target.TargetBreakpointLocationContainer;
import ghidra.dbg.target.TargetBreakpointSpec;
import ghidra.dbg.target.TargetBreakpointSpecContainer;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.program.model.address.AddressRange;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

@TargetObjectSchemaInfo(name="BreakpointContainer", elements={@TargetElementType(type=DbgModelTargetBreakpointSpec.class)}, attributes={@TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public interface DbgModelTargetBreakpointContainer
extends DbgModelTargetObject,
TargetBreakpointSpecContainer,
TargetBreakpointLocationContainer,
DbgEventsListenerAdapter {
    default public CompletableFuture<Void> doPlaceBreakpoint(Set<TargetBreakpointSpec.TargetBreakpointKind> kinds, Function<DbgBreakpointType, CompletableFuture<?>> placer) {
        AsyncFence fence = new AsyncFence();
        if (kinds.contains(TargetBreakpointSpec.TargetBreakpointKind.READ) && kinds.contains(TargetBreakpointSpec.TargetBreakpointKind.WRITE)) {
            fence.include(placer.apply(DbgBreakpointType.ACCESS_WATCHPOINT));
        } else if (kinds.contains(TargetBreakpointSpec.TargetBreakpointKind.READ)) {
            fence.include(placer.apply(DbgBreakpointType.READ_WATCHPOINT));
        } else if (kinds.contains(TargetBreakpointSpec.TargetBreakpointKind.WRITE)) {
            fence.include(placer.apply(DbgBreakpointType.HW_WATCHPOINT));
        }
        if (kinds.contains(TargetBreakpointSpec.TargetBreakpointKind.HW_EXECUTE)) {
            fence.include(placer.apply(DbgBreakpointType.HW_BREAKPOINT));
        }
        if (kinds.contains(TargetBreakpointSpec.TargetBreakpointKind.SW_EXECUTE)) {
            fence.include(placer.apply(DbgBreakpointType.BREAKPOINT));
        }
        return this.getModel().gateFuture(fence.ready());
    }

    default public CompletableFuture<Void> placeBreakpoint(String expression, Set<TargetBreakpointSpec.TargetBreakpointKind> kinds) {
        return this.doPlaceBreakpoint(kinds, t -> this.getManager().insertBreakpoint(expression, (DbgBreakpointType)((Object)t)));
    }

    default public CompletableFuture<Void> placeBreakpoint(AddressRange range, Set<TargetBreakpointSpec.TargetBreakpointKind> kinds) {
        long offset = range.getMinAddress().getOffset();
        int len = (int)range.getLength();
        return this.doPlaceBreakpoint(kinds, t -> this.getManager().insertBreakpoint(offset, len, (DbgBreakpointType)((Object)t)));
    }
}

