/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.manager;

import agent.dbgeng.dbgeng.DebugEventInformation;
import agent.dbgeng.dbgeng.DebugProcessId;
import agent.dbgeng.dbgeng.DebugSessionId;
import agent.dbgeng.dbgeng.DebugThreadId;
import agent.dbgeng.manager.DbgCommand;
import agent.dbgeng.manager.DbgEventsListener;
import agent.dbgeng.manager.DbgModuleMemory;
import agent.dbgeng.manager.DbgProcess;
import agent.dbgeng.manager.DbgSession;
import agent.dbgeng.manager.DbgState;
import agent.dbgeng.manager.DbgStateListener;
import agent.dbgeng.manager.DbgThread;
import agent.dbgeng.manager.breakpoint.DbgBreakpointInfo;
import agent.dbgeng.manager.breakpoint.DbgBreakpointInsertions;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.tuple.Pair;

public interface DbgManager
extends AutoCloseable,
DbgBreakpointInsertions {
    public static DbgManager newInstance() {
        return new DbgManagerImpl();
    }

    public CompletableFuture<Void> start(String[] var1);

    public void terminate();

    public boolean isRunning();

    public void addStateListener(DbgStateListener var1);

    public void removeStateListener(DbgStateListener var1);

    public void addEventsListener(DbgEventsListener var1);

    public void removeEventsListener(DbgEventsListener var1);

    public DbgThread getThread(DebugThreadId var1);

    public DbgProcess getProcess(DebugProcessId var1);

    public DbgSession getSession(DebugSessionId var1);

    public Map<DebugThreadId, DbgThread> getKnownThreads();

    public Map<DebugProcessId, DbgProcess> getKnownProcesses();

    public Map<DebugSessionId, DbgSession> getKnownSessions();

    public Map<Long, DbgBreakpointInfo> getKnownBreakpoints();

    public Map<Long, DbgModuleMemory> getKnownMemoryRegions();

    public void sendInterruptNow();

    public DbgState getState();

    public CompletableFuture<DbgProcess> addProcess();

    public CompletableFuture<Void> removeProcess(DbgProcess var1);

    public CompletableFuture<DbgSession> addSession();

    public CompletableFuture<Void> removeSession(DbgSession var1);

    public CompletableFuture<Void> addMemory(DbgModuleMemory var1);

    public CompletableFuture<Void> removeMemory(Long var1);

    public CompletableFuture<Void> console(String var1);

    public CompletableFuture<String> consoleCapture(String var1);

    public CompletableFuture<Map<DebugProcessId, DbgProcess>> listProcesses();

    public CompletableFuture<List<Pair<Integer, String>>> listAvailableProcesses();

    public CompletableFuture<Map<String, DbgSession>> listSessions();

    public CompletableFuture<Map<Long, DbgBreakpointInfo>> listBreakpoints();

    public CompletableFuture<Void> disableBreakpoints(long ... var1);

    public CompletableFuture<Void> enableBreakpoints(long ... var1);

    public CompletableFuture<Void> deleteBreakpoints(long ... var1);

    public CompletableFuture<?> launch(List<String> var1);

    public CompletableFuture<Void> launch(Map<String, ?> var1);

    public DbgProcess currentProcess();

    public CompletableFuture<Void> waitForState(DbgState var1);

    public CompletableFuture<Void> waitForPrompt();

    public CompletableFuture<Void> waitForEventEx();

    public <T> CompletableFuture<T> execute(DbgCommand<? extends T> var1);

    public DebugEventInformation getLastEventInformation();

    public DbgSession getSessionComputeIfAbsent(DebugSessionId var1, boolean var2);

    public static enum ExecSuffix {
        FINISH("finish"),
        NEXT("next"),
        NEXT_INSTRUCTION("next-instruction"),
        RETURN("return"),
        STEP("step"),
        STEP_INSTRUCTION("step-instruction"),
        UNTIL("until"),
        EXTENDED("ext");

        final String str;

        private ExecSuffix(String str) {
            this.str = str;
        }

        public String toString() {
            return this.str;
        }
    }
}

