/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.gadp;

import agent.dbgeng.gadp.DbgEngGadpServer;
import ghidra.dbg.gadp.server.AbstractGadpLocalDebuggerModelFactory;
import ghidra.dbg.util.ConfigurableFactory;
import ghidra.util.classfinder.ExtensionPointProperties;
import java.util.List;

@ConfigurableFactory.FactoryDescription(brief="MS dbgeng.dll (WinDbg) local agent via GADP/TCP", htmlDetails="Launch a new agent using the Microsoft Debug Engine.")
@ExtensionPointProperties(priority=100)
public class DbgEngLocalDebuggerModelFactory
extends AbstractGadpLocalDebuggerModelFactory {
    protected String remote = "none";
    @ConfigurableFactory.FactoryOption(value="DebugConnect options (.server)")
    public final ConfigurableFactory.Property<String> agentRemoteOption = ConfigurableFactory.Property.fromAccessors(String.class, this::getAgentRemote, this::setAgentRemote);
    protected String transport = "none";
    @ConfigurableFactory.FactoryOption(value="Remote process server options (untested)")
    public final ConfigurableFactory.Property<String> agentTransportOption = ConfigurableFactory.Property.fromAccessors(String.class, this::getAgentTransport, this::setAgentTransport);

    public boolean isCompatible() {
        return System.getProperty("os.name").toLowerCase().contains("windows");
    }

    public String getAgentTransport() {
        return this.transport;
    }

    public void setAgentTransport(String transport) {
        this.transport = transport;
    }

    public String getAgentRemote() {
        return this.remote;
    }

    public void setAgentRemote(String remote) {
        this.remote = remote;
    }

    protected String getThreadName() {
        return "Local dbgeng.dll Agent stdout";
    }

    protected Class<?> getServerClass() {
        return DbgEngGadpServer.class;
    }

    protected void completeCommandLine(List<String> cmd) {
        cmd.add(this.getServerClass().getCanonicalName());
        cmd.addAll(List.of("-H", this.host));
        cmd.addAll(List.of("-p", Integer.toString(this.port)));
        if (!this.remote.equals("none")) {
            cmd.addAll(List.of("-r", this.remote));
        }
        if (!this.transport.equals("none")) {
            cmd.addAll(List.of("-t", this.transport));
        }
    }
}

