/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.disassemble.Disassembler;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.FlowType;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.math.BigInteger;

public class MipsPreAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = "MIPS UnAlligned Instruction Fix";
    private static final String DESCRIPTION = "Analyze MIPS Instructions for unaligned load pairs ldl/ldr sdl/sdr lwl/lwr swl/swr.";
    private static final int NOTIFICATION_INTERVAL = 1024;
    Register pairBitRegister;
    private Register isamode;
    private Register ismbit;
    private Register rel6bit;
    private Register micro16bit;
    Register alternateReg = null;

    public MipsPreAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.INSTRUCTION_ANALYZER);
        this.setPriority(AnalysisPriority.BLOCK_ANALYSIS.after());
        this.setDefaultEnablement(true);
    }

    public boolean canAnalyze(Program program) {
        Processor processor = program.getLanguage().getProcessor();
        return processor.equals((Object)Processor.findOrPossiblyCreateProcessor((String)"MIPS"));
    }

    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        this.pairBitRegister = program.getProgramContext().getRegister("PAIR_INSTRUCTION_FLAG");
        this.isamode = program.getProgramContext().getRegister("ISA_MODE");
        this.ismbit = program.getProgramContext().getRegister("ISAModeSwitch");
        this.rel6bit = program.getProgramContext().getRegister("REL6");
        this.micro16bit = program.getProgramContext().getRegister("RELP");
        long locationCount = (set = this.removeUninitializedBlock(program, set)).getNumAddresses();
        if (locationCount > 1024L) {
            monitor.initialize(locationCount);
        }
        AddressIterator addresses = set.getAddresses(true);
        int count = 0;
        AddressSet pairSet = new AddressSet();
        while (addresses.hasNext()) {
            Instruction instr;
            monitor.checkCanceled();
            Address addr = addresses.next();
            if (locationCount > 1024L) {
                if (count % 1024 == 0) {
                    monitor.setMaximum(locationCount);
                    monitor.setProgress((long)count);
                }
                ++count;
            }
            if ((addr.getOffset() & 3L) != 0L || pairSet.contains(addr) || !this.checkPossiblePairInstruction(program, addr) || (instr = program.getListing().getInstructionAt(addr)) == null || this.skipif16orR6(program, instr)) continue;
            this.findPair(program, pairSet, instr, monitor);
        }
        this.redoAllPairs(program, pairSet, monitor);
        return true;
    }

    private boolean skipif16orR6(Program program, Instruction start_inst) {
        BigInteger curval4;
        boolean rval = false;
        BigInteger curval1 = this.isamode == null ? null : program.getProgramContext().getValue(this.isamode, start_inst.getMinAddress(), false);
        BigInteger curval2 = this.ismbit == null ? null : program.getProgramContext().getValue(this.ismbit, start_inst.getMinAddress(), false);
        BigInteger curval3 = this.rel6bit == null ? null : program.getProgramContext().getValue(this.rel6bit, start_inst.getMinAddress(), false);
        BigInteger bigInteger = curval4 = this.micro16bit == null ? null : program.getProgramContext().getValue(this.micro16bit, start_inst.getMinAddress(), false);
        if (curval1 != null && curval4 != null && curval1.intValue() == 1 && curval4.intValue() == 1) {
            rval = true;
        }
        if (curval2 != null && curval4 != null && curval2.intValue() == 1 && curval4.intValue() == 1) {
            rval = true;
        }
        if (curval3 != null && curval3.intValue() == 1) {
            rval = true;
        }
        return rval;
    }

    private boolean checkPossiblePairInstruction(Program program, Address addr) {
        int primeOpcode = 0;
        try {
            byte b = 0;
            if (!program.getLanguage().isBigEndian()) {
                addr = addr.add(3L);
            }
            b = program.getMemory().getByte(addr);
            primeOpcode = b >> 2 & 0x3F;
        }
        catch (MemoryAccessException exc) {
            return false;
        }
        catch (AddressOutOfBoundsException exc) {
            return false;
        }
        return primeOpcode == 34 || primeOpcode == 38 || primeOpcode == 42 || primeOpcode == 46 || primeOpcode == 26 || primeOpcode == 27 || primeOpcode == 44 || primeOpcode == 45;
    }

    private AddressSetView removeUninitializedBlock(Program program, AddressSetView set) {
        MemoryBlock[] blocks;
        for (MemoryBlock block : blocks = program.getMemory().getBlocks()) {
            if (block.isInitialized() && block.isLoaded()) continue;
            AddressSet blocksSet = new AddressSet();
            blocksSet.addRange(block.getStart(), block.getEnd());
            set = set.subtract((AddressSetView)blocksSet);
        }
        return set;
    }

    private void findPair(Program program, AddressSet pairSet, Instruction start_inst, TaskMonitor monitor) {
        Address minPairAddr = start_inst.getMinAddress();
        BigInteger curvalue = program.getProgramContext().getValue(this.pairBitRegister, start_inst.getMinAddress(), false);
        boolean inPairBit = false;
        if (curvalue != null) {
            boolean bl = inPairBit = curvalue.intValue() == 1;
        }
        if (inPairBit) {
            return;
        }
        Instruction curr_inst = start_inst;
        this.alternateReg = null;
        for (int count = 0; count < 5; ++count) {
            Instruction pairInstr;
            Instruction next_instr = this.getNextInstruction(program, curr_inst);
            if (next_instr == null) {
                return;
            }
            curr_inst = next_instr;
            this.alternateReg = this.checkForMove(start_inst, curr_inst);
            if (!this.checkPossiblePairInstruction(program, curr_inst.getMinAddress()) || (pairInstr = this.getPairInstruction(start_inst, curr_inst)) == null) continue;
            pairSet.add(this.getInstPairRange(start_inst));
            pairSet.add(this.getInstPairRange(pairInstr));
            break;
        }
    }

    private Register checkForMove(Instruction start_inst, Instruction curr_inst) {
        if (curr_inst.getMnemonicString().equals("move")) {
            Register reg = start_inst.getRegister(0);
            Register alt = curr_inst.getRegister(1);
            if (reg != null && reg.equals((Object)alt)) {
                return curr_inst.getRegister(0);
            }
        }
        return this.alternateReg;
    }

    private AddressRange getInstPairRange(Instruction inst) {
        Address start = inst.getMinAddress();
        Address end = inst.getMinAddress();
        if (inst.isInDelaySlot()) {
            start = inst.getPrevious().getMinAddress();
        }
        return new AddressRangeImpl(start, end);
    }

    private Instruction getNextInstruction(Program program, Instruction curr_inst) {
        if (curr_inst.getDelaySlotDepth() > 0) {
            return curr_inst.getNext();
        }
        while (curr_inst.isInDelaySlot()) {
            curr_inst = curr_inst.getPrevious();
        }
        FlowType flowType = curr_inst.getFlowType();
        if (flowType.isJump() && !flowType.isConditional()) {
            Address[] flows = curr_inst.getFlows();
            if (flows.length == 0) {
                return null;
            }
            curr_inst = program.getListing().getInstructionAt(flows[0]);
            return curr_inst;
        }
        Address fallThrough = curr_inst.getFallThrough();
        if (fallThrough == null) {
            return null;
        }
        curr_inst = program.getListing().getInstructionAt(fallThrough);
        return curr_inst;
    }

    private Instruction getPairInstruction(Instruction start_inst, Instruction curr_inst) {
        Object[] obj1 = this.getInstObjs(start_inst);
        if (obj1 == null || obj1.length != 3) {
            return null;
        }
        Register destReg1 = (Register)obj1[0];
        Register base1 = (Register)obj1[1];
        Scalar offset1 = (Scalar)obj1[2];
        if (base1 == null || offset1 == null) {
            return null;
        }
        Object[] obj2 = this.getInstObjs(curr_inst);
        if (obj2 == null || obj2.length != 3) {
            return null;
        }
        Register destReg2 = (Register)obj2[0];
        Register base2 = (Register)obj2[1];
        Scalar offset2 = (Scalar)obj2[2];
        if (base2 == null || offset2 == null) {
            return null;
        }
        Instruction pairInstr = this.checkPair(offset1, offset2, base1, base2, destReg1, destReg2, start_inst, curr_inst);
        return pairInstr;
    }

    private void redoAllPairs(Program program, AddressSet pairSet, TaskMonitor monitor) throws CancelledException {
        int locationCount = pairSet.getNumAddressRanges();
        int count = 0;
        if (locationCount > 1024) {
            monitor.initialize((long)locationCount);
        }
        Disassembler dis = Disassembler.getDisassembler((Program)program, (TaskMonitor)monitor, null);
        for (AddressRange addressRange : pairSet) {
            monitor.checkCanceled();
            if (locationCount > 1024) {
                if (count % 1024 == 0) {
                    monitor.setProgress((long)count);
                }
                ++count;
            }
            program.getListing().clearCodeUnits(addressRange.getMinAddress(), addressRange.getMaxAddress(), false);
            try {
                program.getProgramContext().setValue(this.pairBitRegister, addressRange.getMinAddress(), addressRange.getMaxAddress(), BigInteger.valueOf(1L));
                AddressSet rangeSet = new AddressSet(addressRange);
                dis.disassemble((AddressSetView)rangeSet, (AddressSetView)rangeSet, false);
            }
            catch (ContextChangeException e) {
                Msg.error((Object)((Object)this), (Object)"Unexpected Exception", (Throwable)e);
            }
        }
    }

    private Object[] getInstObjs(Instruction inst) {
        Object[] obj;
        Object[] retObjs = new Object[3];
        Object[] outputs = inst.getOpObjects(0);
        if (outputs.length != 1 || !(outputs[0] instanceof Register)) {
            return null;
        }
        retObjs[0] = outputs[0];
        for (Object element : obj = inst.getOpObjects(1)) {
            if (element instanceof Register) {
                retObjs[1] = element;
            }
            if (!(element instanceof Scalar)) continue;
            retObjs[2] = element;
        }
        return retObjs;
    }

    private Instruction checkPair(Scalar offset1, Scalar offset2, Register base1, Register base2, Register destReg1, Register destReg2, Instruction start_inst, Instruction curr_inst) {
        int start_index1 = 0;
        int start_index2 = 0;
        String str = start_inst.getMnemonicString();
        String str2 = curr_inst.getMnemonicString();
        if (str.charAt(0) == '_') {
            start_index1 = 1;
        }
        if (str2.charAt(0) == '_') {
            start_index2 = 1;
        }
        if (!str.substring(start_index1, start_index1 + 2).equals(str2.substring(start_index2, start_index2 + 2))) {
            return null;
        }
        long diff = Math.abs(offset2.getSignedValue() - offset1.getSignedValue());
        if ((str.endsWith("wl") || str.endsWith("wr")) && diff != 3L) {
            return null;
        }
        if ((str.endsWith("dl") || str.endsWith("dr")) && diff != 7L) {
            return null;
        }
        if (base1.equals((Object)base2) && destReg1.equals((Object)destReg2) | destReg2.equals((Object)this.alternateReg)) {
            return curr_inst;
        }
        return null;
    }
}

