/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.extend;

import ghidra.app.util.bin.format.elf.ElfDefaultGotPltMarkup;
import ghidra.app.util.bin.format.elf.ElfDynamicTable;
import ghidra.app.util.bin.format.elf.ElfDynamicType;
import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfLoadHelper;
import ghidra.app.util.bin.format.elf.ElfSectionHeader;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.extend.ElfExtension;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.QWordDataType;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.exception.NotFoundException;
import ghidra.util.task.TaskMonitor;
import java.math.BigInteger;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class PowerPC64_ElfExtension
extends ElfExtension {
    private static final int PLT_ENTRY_SIZE = 8;
    private static final int PLT_HEAD_SIZE = 16;
    public static final ElfDynamicType DT_PPC64_GLINK = new ElfDynamicType(0x70000000, "DT_PPC64_GLINK", "Specify the start of the .glink section", ElfDynamicType.ElfDynamicValueType.ADDRESS);
    public static final ElfDynamicType DT_PPC64_OPD = new ElfDynamicType(0x70000001, "DT_PPC64_OPD", "Specify the start of the .opd section", ElfDynamicType.ElfDynamicValueType.ADDRESS);
    public static final ElfDynamicType DT_PPC64_OPDSZ = new ElfDynamicType(0x70000002, "DT_PPC64_OPDSZ", "Specify the size of the .opd section", ElfDynamicType.ElfDynamicValueType.ADDRESS);
    public static final ElfDynamicType DT_PPC64_OPT = new ElfDynamicType(0x70000003, "DT_PPC64_OPT", "Specify whether various optimizations are possible", ElfDynamicType.ElfDynamicValueType.VALUE);
    private static final int EF_PPC64_ABI = 3;
    private static final int PPC64_OPT_TLS = 1;
    private static final int PPC64_OPT_MULTI_TOC = 2;
    private static final int PPC64_OPT_LOCALENTRY = 4;
    private static final int STO_PPC64_LOCAL_BIT = 5;
    private static final int STO_PPC64_LOCAL_MASK = 224;
    public static final String TOC_BASE = "TOC_BASE";
    private static int[] PPC64_ABIV2_GLOBAL_ENTRY_OFFSET = new int[]{0, 0, 1, 2, 4, 8, 16, 0};

    public boolean canHandle(ElfHeader elf) {
        return elf.e_machine() == 21 && elf.is64Bit();
    }

    public boolean canHandle(ElfLoadHelper elfLoadHelper) {
        Language language = elfLoadHelper.getProgram().getLanguage();
        return this.canHandle(elfLoadHelper.getElfHeader()) && "PowerPC".equals(language.getProcessor().toString()) && language.getLanguageDescription().getSize() == 64;
    }

    public String getDataTypeSuffix() {
        return "_PPC64";
    }

    public void processElf(ElfLoadHelper elfLoadHelper, TaskMonitor monitor) throws CancelledException {
        if (!this.canHandle(elfLoadHelper)) {
            return;
        }
        this.findTocBase(elfLoadHelper, monitor);
    }

    public void processGotPlt(ElfLoadHelper elfLoadHelper, TaskMonitor monitor) throws CancelledException {
        if (!this.canHandle(elfLoadHelper)) {
            return;
        }
        this.setEntryPointContext(elfLoadHelper, monitor);
        this.processOPDSection(elfLoadHelper, monitor);
        super.processGotPlt(elfLoadHelper, monitor);
        this.processPpc64v2PltPointerTable(elfLoadHelper, monitor);
        this.processPpc64PltGotPointerTable(elfLoadHelper, monitor);
    }

    private void findTocBase(ElfLoadHelper elfLoadHelper, TaskMonitor monitor) {
        Program program = elfLoadHelper.getProgram();
        try {
            Address tocAddr = null;
            MemoryBlock tocBlock = program.getMemory().getBlock(".toc");
            if (tocBlock != null) {
                tocAddr = tocBlock.getStart();
            } else {
                MemoryBlock gotBlock = program.getMemory().getBlock(".got");
                if (gotBlock != null) {
                    tocAddr = gotBlock.getStart().addNoWrap(32768L);
                }
            }
            if (tocAddr != null) {
                elfLoadHelper.createSymbol(tocAddr, TOC_BASE, false, false, null);
            }
        }
        catch (AddressOverflowException | InvalidInputException throwable) {
            // empty catch block
        }
    }

    private void processPpc64PltGotPointerTable(ElfLoadHelper elfLoadHelper, TaskMonitor monitor) throws CancelledException {
        ElfHeader elf = elfLoadHelper.getElfHeader();
        if (PowerPC64_ElfExtension.getPpc64ABIVersion(elf) == 2) {
            Symbol tocSymbol = SymbolUtilities.getLabelOrFunctionSymbol((Program)elfLoadHelper.getProgram(), (String)TOC_BASE, err -> elfLoadHelper.getLog().error("PowerPC64_ELF", err));
            if (tocSymbol != null) {
                this.paintTocAsR2value(tocSymbol.getAddress().getOffset(), elfLoadHelper, monitor);
            }
            return;
        }
        ElfDynamicTable dynamicTable = elf.getDynamicTable();
        if (!(dynamicTable != null && dynamicTable.containsDynamicValue(ElfDynamicType.DT_PLTGOT) && dynamicTable.containsDynamicValue(ElfDynamicType.DT_PLTRELSZ) && dynamicTable.containsDynamicValue(ElfDynamicType.DT_PLTREL))) {
            return;
        }
        try {
            long pltgotOffset = elf.adjustAddressForPrelink(dynamicTable.getDynamicValue(ElfDynamicType.DT_PLTGOT));
            Address pltAddr = elfLoadHelper.getDefaultAddress(pltgotOffset);
            Program program = elfLoadHelper.getProgram();
            MemoryBlock pltBlock = program.getMemory().getBlock(pltAddr);
            if (pltBlock == null || pltBlock.isExecute()) {
                return;
            }
            int relEntrySize = dynamicTable.getDynamicValue(ElfDynamicType.DT_PLTREL) == (long)ElfDynamicType.DT_RELA.value ? 24 : 16;
            long pltEntryCount = dynamicTable.getDynamicValue(ElfDynamicType.DT_PLTRELSZ) / (long)relEntrySize;
            int i = 0;
            while ((long)i < pltEntryCount) {
                monitor.checkCanceled();
                pltAddr = pltAddr.addNoWrap(24L);
                Symbol refSymbol = this.markupDescriptorEntry(pltAddr, false, elfLoadHelper);
                if (refSymbol != null && refSymbol.getSymbolType() == SymbolType.FUNCTION && refSymbol.getSource() == SourceType.DEFAULT) {
                    try {
                        refSymbol.setName(".pltgot." + refSymbol.getName(), SourceType.IMPORTED);
                    }
                    catch (DuplicateNameException | InvalidInputException throwable) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        catch (NotFoundException e) {
            throw new AssertException("unexpected", (Throwable)e);
        }
        catch (AddressOverflowException e) {
            elfLoadHelper.log("Failed to process PltGot entries: " + e.getMessage());
        }
    }

    private void paintTocAsR2value(long tocBaseOffset, ElfLoadHelper elfLoadHelper, TaskMonitor monitor) {
        Program program = elfLoadHelper.getProgram();
        ProgramContext programContext = program.getProgramContext();
        Register r2reg = program.getRegister("r2");
        RegisterValue tocValue = new RegisterValue(r2reg, BigInteger.valueOf(tocBaseOffset));
        for (MemoryBlock block : program.getMemory().getBlocks()) {
            if (!block.isExecute()) continue;
            try {
                programContext.setRegisterValue(block.getStart(), block.getEnd(), tocValue);
            }
            catch (ContextChangeException e) {
                String msg = "Failed to set r2 as TOC_BASE on memory block " + block.getName();
                Msg.error((Object)((Object)this), (Object)(msg + ": " + e.getMessage()));
                elfLoadHelper.log(msg);
            }
        }
    }

    private void processPpc64v2PltPointerTable(ElfLoadHelper elfLoadHelper, TaskMonitor monitor) throws CancelledException {
        ElfHeader elf = elfLoadHelper.getElfHeader();
        ElfSectionHeader pltSection = elf.getSection(".plt");
        if (pltSection == null) {
            return;
        }
        Program program = elfLoadHelper.getProgram();
        MemoryBlock pltBlock = program.getMemory().getBlock(pltSection.getNameAsString());
        if (pltBlock == null) {
            return;
        }
        if (pltSection.isExecutable()) {
            return;
        }
        pltBlock.setWrite(false);
        if (PowerPC64_ElfExtension.getPpc64ABIVersion(elf) != 2) {
            return;
        }
        Address addr = pltBlock.getStart().add(16L);
        try {
            while (addr.compareTo((Object)pltBlock.getEnd()) < 0) {
                monitor.checkCanceled();
                if (elfLoadHelper.createData(addr, (DataType)PointerDataType.dataType) != null) {
                    addr = addr.addNoWrap(8L);
                    continue;
                }
                break;
            }
        }
        catch (AddressOverflowException addressOverflowException) {
            // empty catch block
        }
    }

    private void processOPDSection(ElfLoadHelper elfLoadHelper, TaskMonitor monitor) throws CancelledException {
        MemoryBlock opdBlock = elfLoadHelper.getProgram().getMemory().getBlock(".opd");
        if (opdBlock == null) {
            return;
        }
        monitor.setMessage("Processing Function Descriptor Symbols...");
        Address addr = opdBlock.getStart();
        Address endAddr = opdBlock.getEnd();
        monitor.setShowProgressValue(true);
        monitor.setProgress(0L);
        monitor.setMaximum((endAddr.subtract(addr) + 1L) / 24L);
        int count = 0;
        try {
            while (addr.compareTo((Object)endAddr) < 0) {
                monitor.checkCanceled();
                monitor.setProgress((long)(++count));
                this.processOPDEntry(elfLoadHelper, addr);
                addr = addr.addNoWrap(24L);
            }
        }
        catch (AddressOverflowException addressOverflowException) {
            // empty catch block
        }
        opdBlock.setWrite(false);
    }

    private void processOPDEntry(ElfLoadHelper elfLoadHelper, Address opdAddr) {
        Symbol[] symbols;
        Program program = elfLoadHelper.getProgram();
        SymbolTable symbolTable = program.getSymbolTable();
        boolean isGlobal = symbolTable.isExternalEntryPoint(opdAddr);
        Symbol refSymbol = this.markupDescriptorEntry(opdAddr, isGlobal, elfLoadHelper);
        if (refSymbol == null) {
            return;
        }
        Address refAddr = refSymbol.getAddress();
        Function f = program.getFunctionManager().getFunctionAt(opdAddr);
        if (f == null) {
            if (refSymbol.getSymbolType() == SymbolType.FUNCTION && refSymbol.getSource() == SourceType.DEFAULT) {
                try {
                    refSymbol.setName(".opd." + refSymbol.getName(), SourceType.IMPORTED);
                }
                catch (DuplicateNameException | InvalidInputException throwable) {
                    // empty catch block
                }
            }
            return;
        }
        f.getSymbol().delete();
        for (Symbol symbol : symbols = program.getSymbolTable().getSymbols(opdAddr)) {
            if (symbol.isDynamic()) continue;
            String name = symbol.getName();
            symbol.delete();
            try {
                elfLoadHelper.createSymbol(refAddr, name, false, false, null);
            }
            catch (InvalidInputException e) {
                Msg.error((Object)((Object)this), (Object)("Failed to move function descriptor symbol properly: " + name));
            }
        }
    }

    private Symbol markupDescriptorEntry(Address entryAddr, boolean isGlobal, ElfLoadHelper elfLoadHelper) {
        Address tocAddr;
        Program program = elfLoadHelper.getProgram();
        Data refPtr = elfLoadHelper.createData(entryAddr, (DataType)PointerDataType.dataType);
        Data tocPtr = elfLoadHelper.createData(entryAddr.add((long)program.getDefaultPointerSize()), (DataType)PointerDataType.dataType);
        elfLoadHelper.createData(entryAddr.add((long)(2 * program.getDefaultPointerSize())), (DataType)QWordDataType.dataType);
        if (refPtr == null || tocPtr == null) {
            Msg.error((Object)((Object)this), (Object)("Failed to process PPC64 descriptor at " + entryAddr));
            return null;
        }
        Address refAddr = (Address)refPtr.getValue();
        if (refAddr == null || program.getMemory().getBlock(refAddr) == null) {
            return null;
        }
        ElfDefaultGotPltMarkup.setConstant((Data)refPtr);
        ElfDefaultGotPltMarkup.setConstant((Data)tocPtr);
        Function function = program.getListing().getFunctionAt(refAddr);
        if (function == null) {
            List relocations = program.getRelocationTable().getRelocations(refAddr);
            if (!relocations.isEmpty() && ((Relocation)relocations.get(0)).getType() == 22) {
                return program.getSymbolTable().getPrimarySymbol(refAddr);
            }
            function = elfLoadHelper.createOneByteFunction(null, refAddr, isGlobal);
        }
        if ((tocAddr = (Address)tocPtr.getValue()) != null) {
            Register r2reg = program.getRegister("r2");
            RegisterValue tocValue = new RegisterValue(r2reg, tocAddr.getOffsetAsBigInteger());
            try {
                program.getProgramContext().setRegisterValue(refAddr, refAddr, tocValue);
            }
            catch (ContextChangeException e) {
                throw new AssertException((Throwable)e);
            }
        }
        return function.getSymbol();
    }

    private void setPPC64v2GlobalFunctionR12Context(Program program, Address functionAddr) {
        RegisterValue entryOffset = new RegisterValue(program.getRegister("r12"), BigInteger.valueOf(functionAddr.getOffset()));
        ProgramContext programContext = program.getProgramContext();
        try {
            programContext.setRegisterValue(functionAddr, functionAddr, entryOffset);
        }
        catch (ContextChangeException e) {
            throw new AssertException((Throwable)e);
        }
    }

    private void setEntryPointContext(ElfLoadHelper elfLoadHelper, TaskMonitor monitor) throws CancelledException {
        Program program = elfLoadHelper.getProgram();
        if (PowerPC64_ElfExtension.getPpc64ABIVersion(elfLoadHelper.getElfHeader()) == 2) {
            monitor.setMessage("Assuming r12 for global functions...");
            FunctionManager functionMgr = program.getFunctionManager();
            for (Address addr : program.getSymbolTable().getExternalEntryPointIterator()) {
                monitor.checkCanceled();
                if (functionMgr.getFunctionAt(addr) == null) continue;
                this.setPPC64v2GlobalFunctionR12Context(program, addr);
            }
            Symbol entrySymbol = SymbolUtilities.getLabelOrFunctionSymbol((Program)elfLoadHelper.getProgram(), (String)"entry", err -> elfLoadHelper.getLog().error("PowerPC64_ELF", err));
            if (entrySymbol != null && entrySymbol.getSymbolType() == SymbolType.FUNCTION) {
                this.setPPC64v2GlobalFunctionR12Context(program, entrySymbol.getAddress());
            }
        }
    }

    public Address evaluateElfSymbol(ElfLoadHelper elfLoadHelper, ElfSymbol elfSymbol, Address address, boolean isExternal) {
        Function f;
        ElfHeader elfHeader = elfLoadHelper.getElfHeader();
        if (isExternal || elfSymbol.getType() != 2 || PowerPC64_ElfExtension.getPpc64ABIVersion(elfHeader) != 2) {
            return address;
        }
        Language language = elfLoadHelper.getProgram().getLanguage();
        if (!this.canHandle(elfLoadHelper) || elfHeader.e_machine() != 21 || language.getLanguageDescription().getSize() != 64) {
            return address;
        }
        String name = elfSymbol.getNameAsString();
        Function localFunction = null;
        int localOffset = PPC64_ABIV2_GLOBAL_ENTRY_OFFSET[(elfSymbol.getOther() & 0xE0) >>> 5] * 4;
        if (localOffset != 0) {
            Object localName = "";
            if (!StringUtils.isBlank((CharSequence)name)) {
                localName = "." + name;
            }
            try {
                Address localFunctionAddr = address.add((long)localOffset);
                localFunction = elfLoadHelper.createOneByteFunction((String)localName, localFunctionAddr, false);
                String cmt = "local function entry for global function " + name + " at {@address " + address + "}";
                elfLoadHelper.getProgram().getListing().setComment(localFunctionAddr, 1, cmt);
            }
            catch (Exception e) {
                elfLoadHelper.log("Failed to generate local function symbol " + (String)localName + " at " + address + "+" + localOffset);
            }
        }
        if ((f = elfLoadHelper.createOneByteFunction(name, address, false)) != null && localFunction != null) {
            f.setThunkedFunction(localFunction);
            return null;
        }
        return address;
    }

    public static int getPpc64ABIVersion(ElfHeader elf) {
        if (elf.e_machine() != 21) {
            return 0;
        }
        return elf.e_flags() & 3;
    }
}

