/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.plugin.core.analysis.ConstantPropagationAnalyzer;
import ghidra.app.plugin.core.analysis.ConstantPropagationContextEvaluator;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.options.Options;
import ghidra.program.disassemble.Disassembler;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.util.ContextEvaluator;
import ghidra.program.util.SymbolicPropogator;
import ghidra.program.util.VarnodeContext;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.math.BigInteger;

public class SH4AddressAnalyzer
extends ConstantPropagationAnalyzer {
    private static final String OPTION_NAME_PROPAGATE_R12 = "Propagate constant R12";
    private static final String OPTION_DESCRIPTION_PROPAGATE_R12 = "R12 can be used as a pointer to the GOT table. If it is a constant value propagate the value into called functions.";
    private static final boolean OPTION_DEFAULT_PROPAGATE_R12 = true;
    protected boolean propagateR12 = true;
    protected Register r12;
    private static final String PROCESSOR_NAME = "SuperH4";

    public SH4AddressAnalyzer() {
        super(PROCESSOR_NAME);
    }

    public boolean canAnalyze(Program program) {
        boolean canAnalyze = program.getLanguage().getProcessor().equals((Object)Processor.findOrPossiblyCreateProcessor((String)PROCESSOR_NAME));
        if (!canAnalyze) {
            return false;
        }
        this.r12 = program.getRegister("r12");
        return true;
    }

    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        return super.added(program, set, monitor, log);
    }

    public AddressSetView flowConstants(final Program program, Address flowStart, AddressSetView flowSet, SymbolicPropogator symEval, final TaskMonitor monitor) throws CancelledException {
        ConstantPropagationContextEvaluator eval = new ConstantPropagationContextEvaluator(this.trustWriteMemOption){

            public boolean evaluateReference(VarnodeContext context, Instruction instr, int pcodeop, Address address, int size, RefType refType) {
                boolean doRef;
                if (address.isExternalAddress()) {
                    return true;
                }
                if (refType.isCall() && instr.getFlowType().isCall()) {
                    SH4AddressAnalyzer.this.propagateR12ToCall(program, context, address);
                }
                if (!(doRef = super.evaluateReference(context, instr, pcodeop, address, size, refType))) {
                    return false;
                }
                if (SH4AddressAnalyzer.this.checkComputedRelativeBranch(program, monitor, instr, address, refType, pcodeop)) {
                    return false;
                }
                return doRef;
            }
        };
        AddressSet resultSet = symEval.flowConstants(flowStart, null, (ContextEvaluator)eval, true, monitor);
        return resultSet;
    }

    protected boolean checkComputedRelativeBranch(Program program, TaskMonitor monitor, Instruction instr, Address address, RefType refType, int pcodeop) {
        if (pcodeop == 0) {
            return false;
        }
        if (!refType.isComputed()) {
            return false;
        }
        String mnemonic = instr.getMnemonicString();
        if (mnemonic.equals("bsrf") || mnemonic.equals("braf")) {
            instr.addOperandReference(0, address, refType, SourceType.ANALYSIS);
            Disassembler dis = Disassembler.getDisassembler((Program)program, (TaskMonitor)monitor, null);
            AddressSet disassembleAddrs = dis.disassemble(address, null);
            AutoAnalysisManager.getAnalysisManager((Program)program).codeDefined((AddressSetView)disassembleAddrs);
            return true;
        }
        return false;
    }

    protected void propagateR12ToCall(Program program, VarnodeContext context, Address address) {
        if (!this.propagateR12) {
            return;
        }
        RegisterValue registerValue = context.getRegisterValue(this.r12);
        if (registerValue != null) {
            BigInteger value = registerValue.getUnsignedValue();
            ProgramContext progContext = program.getProgramContext();
            try {
                progContext.setValue(this.r12, address, address, value);
            }
            catch (ContextChangeException contextChangeException) {
                // empty catch block
            }
        }
    }

    public void optionsChanged(Options options, Program program) {
        super.optionsChanged(options, program);
        options.registerOption(OPTION_NAME_PROPAGATE_R12, (Object)true, null, OPTION_DESCRIPTION_PROPAGATE_R12);
        this.propagateR12 = options.getBoolean(OPTION_NAME_PROPAGATE_R12, true);
    }
}

