/*
 * Decompiled with CFR 0.152.
 */
package ghidra.bitpatterns.gui;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.TableColumnDescriptor;
import docking.widgets.table.threaded.ThreadedTableModelStub;
import ghidra.bitpatterns.gui.ClosedPatternRowObject;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.column.AbstractGColumnRenderer;
import ghidra.util.table.column.GColumnRenderer;
import ghidra.util.task.TaskMonitor;
import java.awt.Font;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class ClosedPatternTableModel
extends ThreadedTableModelStub<ClosedPatternRowObject> {
    private List<ClosedPatternRowObject> rowObjects;
    private static final String MODEL_NAME = "Closed Patterns";
    private static final int MONOSPACE_FONT_SIZE = 16;
    protected GColumnRenderer<String> monospacedRenderer = new AbstractGColumnRenderer<String>(){

        protected void configureFont(JTable table, TableModel model, int column) {
            Font f = new Font("monospaced", this.getFixedWidthFont().getStyle(), 16);
            this.setFont(f);
        }

        public String getFilterString(String t, Settings settings) {
            return t;
        }
    };

    public ClosedPatternTableModel(List<ClosedPatternRowObject> rowObjects, ServiceProvider serviceProvider) {
        super(MODEL_NAME, serviceProvider);
        this.rowObjects = rowObjects;
    }

    protected void doLoad(Accumulator<ClosedPatternRowObject> accumulator, TaskMonitor monitor) throws CancelledException {
        if (this.rowObjects != null) {
            accumulator.addAll(this.rowObjects);
        }
    }

    protected TableColumnDescriptor<ClosedPatternRowObject> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn((DynamicTableColumn)new ClosedPatternTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new ClosedPatternFixedBitsTableColumn(), 0, false);
        descriptor.addVisibleColumn((DynamicTableColumn)new ClosedPatternNumOccurrencesTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new ClosedPatternPercentageTableColumn());
        return descriptor;
    }

    class ClosedPatternTableColumn
    extends AbstractDynamicTableColumn<ClosedPatternRowObject, String, Object> {
        ClosedPatternTableColumn() {
        }

        public String getColumnName() {
            return "Byte Sequence";
        }

        public GColumnRenderer<String> getColumnRenderer() {
            return ClosedPatternTableModel.this.monospacedRenderer;
        }

        public String getValue(ClosedPatternRowObject rowObject, Settings settings, Object data, ServiceProvider sProvider) throws IllegalArgumentException {
            return rowObject.getDittedString();
        }
    }

    class ClosedPatternFixedBitsTableColumn
    extends AbstractDynamicTableColumn<ClosedPatternRowObject, Integer, Object> {
        ClosedPatternFixedBitsTableColumn() {
        }

        public String getColumnName() {
            return "Fixed Bits";
        }

        public Integer getValue(ClosedPatternRowObject rowObject, Settings settings, Object data, ServiceProvider sProvider) throws IllegalArgumentException {
            return rowObject.getNumFixedBits();
        }
    }

    class ClosedPatternNumOccurrencesTableColumn
    extends AbstractDynamicTableColumn<ClosedPatternRowObject, Integer, Object> {
        ClosedPatternNumOccurrencesTableColumn() {
        }

        public String getColumnName() {
            return "Number of Occurrences";
        }

        public Integer getValue(ClosedPatternRowObject rowObject, Settings settings, Object data, ServiceProvider sProvider) throws IllegalArgumentException {
            return rowObject.getNumOccurrences();
        }
    }

    class ClosedPatternPercentageTableColumn
    extends AbstractDynamicTableColumn<ClosedPatternRowObject, Double, Object> {
        ClosedPatternPercentageTableColumn() {
        }

        public String getColumnName() {
            return "Percentage";
        }

        public Double getValue(ClosedPatternRowObject rowObject, Settings settings, Object data, ServiceProvider services) throws IllegalArgumentException {
            return rowObject.getPercentage();
        }
    }
}

