/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.model.impl;

import agent.frida.manager.FridaCause;
import agent.frida.manager.FridaSession;
import agent.frida.model.iface2.FridaModelTargetRoot;
import agent.frida.model.iface2.FridaModelTargetSession;
import agent.frida.model.iface2.FridaModelTargetSessionContainer;
import agent.frida.model.impl.FridaModelTargetObjectImpl;
import agent.frida.model.impl.FridaModelTargetSessionImpl;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@TargetObjectSchemaInfo(name="SessionContainer", elements={@TargetElementType(type=FridaModelTargetSessionImpl.class)}, attributes={@TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class FridaModelTargetSessionContainerImpl
extends FridaModelTargetObjectImpl
implements FridaModelTargetSessionContainer {
    public FridaModelTargetSessionContainerImpl(FridaModelTargetRoot root) {
        super(root.getModel(), (TargetObject)root, "Sessions", "SessionContainer");
        this.getManager().addEventsListener(this);
    }

    @Override
    public void sessionAdded(FridaSession sess, FridaCause cause) {
        FridaModelTargetSession session = this.getTargetSession(sess);
        this.changeElements(List.of(), List.of(session), Map.of(), "Added");
    }

    @Override
    public void sessionReplaced(FridaSession sess, FridaCause cause) {
        FridaModelTargetSession session = this.getTargetSession(sess);
        this.changeElements(List.of(), List.of(session), Map.of(), "Replaced");
    }

    @Override
    public void sessionRemoved(String sessionId, FridaCause cause) {
        this.changeElements(List.of(sessionId), List.of(), Map.of(), "Removed");
    }

    @Override
    public synchronized FridaModelTargetSession getTargetSession(FridaSession session) {
        TargetObject targetObject = this.getMapObject(session);
        if (targetObject != null) {
            FridaModelTargetSession targetSession = (FridaModelTargetSession)targetObject;
            targetSession.setModelObject(session);
            return targetSession;
        }
        return new FridaModelTargetSessionImpl(this, session);
    }

    public CompletableFuture<Void> requestElements(boolean refresh) {
        return this.getManager().listSessions().thenAccept(byIID -> {
            List sessions;
            FridaModelTargetSessionContainerImpl fridaModelTargetSessionContainerImpl = this;
            synchronized (fridaModelTargetSessionContainerImpl) {
                sessions = byIID.values().stream().map(this::getTargetSession).collect(Collectors.toList());
            }
            this.setElements(sessions, "Refreshed");
        });
    }
}

