/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.vdex.headers;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.ByteProviderWrapper;
import ghidra.file.formats.android.dex.DexHeaderFactory;
import ghidra.file.formats.android.dex.format.DexHeader;
import ghidra.file.formats.android.vdex.UnsupportedVdexVersionException;
import ghidra.file.formats.android.vdex.VdexHeader;
import ghidra.file.formats.android.vdex.sections.DexSectionHeader_002;
import ghidra.file.formats.android.vdex.sections.VdexSectionHeader_S_T;
import ghidra.file.formats.android.vdex.sections.VdexSection_S_T;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Structure;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public class VdexHeader_027
extends VdexHeader {
    private String vdex_version_;
    private int number_of_sections_;
    private List<VdexSectionHeader_S_T> sections = new ArrayList<VdexSectionHeader_S_T>();
    private List<Integer> checksums = new ArrayList<Integer>();

    public VdexHeader_027(BinaryReader reader) throws IOException, UnsupportedVdexVersionException {
        super(reader);
        this.vdex_version_ = reader.readNextAsciiString(4);
        this.number_of_sections_ = reader.readNextInt();
    }

    @Override
    public String getVersion() {
        return this.vdex_version_;
    }

    @Override
    public void parse(BinaryReader reader, TaskMonitor monitor) throws IOException, CancelledException {
        for (int i = 0; i < this.number_of_sections_; ++i) {
            monitor.checkCanceled();
            this.sections.add(new VdexSectionHeader_S_T(reader));
        }
        this.parseChecksums(reader, monitor);
        this.parseDexFiles(reader, monitor);
        this.parseVerifierDeps(reader, monitor);
        this.parseTypeLookupTable(reader, monitor);
    }

    private void parseChecksums(BinaryReader reader, TaskMonitor monitor) throws CancelledException, IOException {
        VdexSectionHeader_S_T checksumSection = this.sections.get(VdexSection_S_T.kChecksumSection.ordinal());
        if (checksumSection.getSectionSize() > 0) {
            reader.setPointerIndex(checksumSection.getSectionOffset());
            for (int i = 0; i < checksumSection.getSectionSize() / 4; ++i) {
                monitor.checkCanceled();
                this.checksums.add(reader.readNextInt());
            }
        }
    }

    private void parseDexFiles(BinaryReader reader, TaskMonitor monitor) throws CancelledException, IOException {
        VdexSectionHeader_S_T dexFileSection = this.sections.get(VdexSection_S_T.kDexFileSection.ordinal());
        if (dexFileSection.getSectionSize() > 0) {
            reader.setPointerIndex(dexFileSection.getSectionOffset());
            this.dexHeaderStartsList.add(Integer.toUnsignedLong(dexFileSection.getSectionOffset()));
            ByteProviderWrapper wrappedProvider = new ByteProviderWrapper(reader.getByteProvider(), (long)dexFileSection.getSectionOffset(), (long)dexFileSection.getSectionSize());
            BinaryReader wrappedReader = new BinaryReader((ByteProvider)wrappedProvider, reader.isLittleEndian());
            DexHeader cdexHeader = DexHeaderFactory.getDexHeader(wrappedReader);
            this.dexHeaderList.add(cdexHeader);
        }
    }

    private void parseVerifierDeps(BinaryReader reader, TaskMonitor monitor) throws CancelledException, IOException {
        VdexSectionHeader_S_T verifierDepsSection = this.sections.get(VdexSection_S_T.kVerifierDepsSection.ordinal());
        if (verifierDepsSection.getSectionSize() > 0) {
            reader.setPointerIndex(verifierDepsSection.getSectionOffset());
        }
    }

    private void parseTypeLookupTable(BinaryReader reader, TaskMonitor monitor) throws CancelledException, IOException {
        VdexSectionHeader_S_T typeLookupTableSection = this.sections.get(VdexSection_S_T.kTypeLookupTableSection.ordinal());
        if (typeLookupTableSection.getSectionSize() > 0) {
            reader.setPointerIndex(typeLookupTableSection.getSectionOffset());
        }
    }

    @Override
    public int getVerifierDepsSize() {
        return 0;
    }

    @Override
    public int getQuickeningInfoSize() {
        return 0;
    }

    @Override
    public int[] getDexChecksums() {
        return ArrayUtils.toPrimitive((Integer[])this.checksums.toArray(new Integer[this.checksums.size()]));
    }

    @Override
    public boolean isDexHeaderEmbeddedInDataType() {
        return true;
    }

    @Override
    public DexSectionHeader_002 getDexSectionHeader_002() {
        return null;
    }

    public String getVdexVersion() {
        return this.vdex_version_;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        int i;
        Structure structure = (Structure)super.toDataType();
        structure.add(STRING, 4, "vdex_version_", null);
        structure.add(DWORD, "number_of_sections_", null);
        for (i = 0; i < this.sections.size(); ++i) {
            structure.add(this.sections.get(i).toDataType(), "section_" + i, null);
        }
        for (i = 0; i < this.checksums.size(); ++i) {
            structure.add(DWORD, "checksum_" + i, null);
        }
        this.toDataTypeDexFile(structure);
        this.toDataTypeVerifierDeps(structure);
        this.toDataTypeTypeLookupTable(structure);
        return structure;
    }

    private void toDataTypeDexFile(Structure structure) {
        VdexSectionHeader_S_T dexFileSection = this.sections.get(VdexSection_S_T.kDexFileSection.ordinal());
        if (dexFileSection.getSectionSize() > 0) {
            ArrayDataType array = new ArrayDataType(BYTE, dexFileSection.getSectionSize(), BYTE.getLength());
            structure.add((DataType)array, "cdex", null);
        }
    }

    private void toDataTypeVerifierDeps(Structure structure) {
        VdexSectionHeader_S_T verifierDepsSection = this.sections.get(VdexSection_S_T.kVerifierDepsSection.ordinal());
        if (verifierDepsSection.getSectionSize() > 0) {
            ArrayDataType array = new ArrayDataType(BYTE, verifierDepsSection.getSectionSize(), BYTE.getLength());
            structure.add((DataType)array, "verifier_deps", null);
        }
    }

    private void toDataTypeTypeLookupTable(Structure structure) {
        VdexSectionHeader_S_T typeLookupTableSection = this.sections.get(VdexSection_S_T.kTypeLookupTableSection.ordinal());
        if (typeLookupTableSection.getSectionSize() > 0) {
            ArrayDataType array = new ArrayDataType(BYTE, typeLookupTableSection.getSectionSize(), BYTE.getLength());
            structure.add((DataType)array, "type_lookup_table", null);
        }
    }
}

