/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.odex;

import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.file.analyzers.FileFormatAnalyzer;
import ghidra.file.formats.android.odex.OdexConstants;
import ghidra.file.formats.android.odex.OdexHeader;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.task.TaskMonitor;

public class OdexHeaderFormatAnalyzer
extends FileFormatAnalyzer {
    @Override
    public boolean analyze(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws Exception {
        Address address = this.toAddr(program, 0L);
        if (this.getDataAt(program, address) != null) {
            log.appendMsg("data already exists.");
            return true;
        }
        Memory memory = program.getMemory();
        MemoryBlock block = memory.getBlock("ram");
        block.setRead(true);
        block.setWrite(false);
        block.setExecute(false);
        MemoryByteProvider provider = MemoryByteProvider.createProgramHeaderByteProvider((Program)program, (boolean)false);
        BinaryReader reader = new BinaryReader((ByteProvider)provider, true);
        OdexHeader header = new OdexHeader(reader);
        DataType headerDataType = header.toDataType();
        this.createData(program, address, headerDataType);
        this.createFragment(program, "header", address, address.add((long)headerDataType.getLength()));
        Address dexAddress = this.toAddr(program, header.getDexOffset());
        this.createFragment(program, "dex", dexAddress, dexAddress.add((long)header.getDexLength()));
        Address depsAddress = this.toAddr(program, header.getDepsOffset());
        this.createFragment(program, "deps", depsAddress, depsAddress.add((long)header.getDepsLength()));
        this.processDeps(program, header, monitor, log);
        Address auxAddress = this.toAddr(program, header.getAuxOffset());
        this.createFragment(program, "aux", auxAddress, auxAddress.add((long)header.getAuxLength()));
        monitor.setMessage("ODEX: cleaning up tree");
        this.removeEmptyFragments(program);
        return true;
    }

    public boolean canAnalyze(Program program) {
        MemoryByteProvider provider = MemoryByteProvider.createProgramHeaderByteProvider((Program)program, (boolean)false);
        return OdexConstants.isOdexFile((ByteProvider)provider);
    }

    @Override
    public AnalyzerType getAnalysisType() {
        return AnalyzerType.BYTE_ANALYZER;
    }

    public boolean getDefaultEnablement(Program program) {
        return true;
    }

    public String getDescription() {
        return "Android ODEX Header Format";
    }

    public String getName() {
        return "Android ODEX Header Format";
    }

    @Override
    public AnalysisPriority getPriority() {
        return new AnalysisPriority(0);
    }

    public boolean isPrototype() {
        return false;
    }

    private void processDeps(Program program, OdexHeader header, TaskMonitor monitor, MessageLog log) throws Exception {
        int depsOffset = header.getDepsOffset();
        int depsLength = header.getDepsLength();
        Address depsAddress = this.toAddr(program, depsOffset);
        Address depsEndAddress = depsAddress.add((long)depsLength);
        this.createData(program, depsAddress, (DataType)new DWordDataType());
        depsAddress = depsAddress.add(4L);
        this.createData(program, depsAddress, (DataType)new DWordDataType());
        depsAddress = depsAddress.add(4L);
        this.createData(program, depsAddress, (DataType)new DWordDataType());
        depsAddress = depsAddress.add(4L);
        this.createData(program, depsAddress, (DataType)new DWordDataType());
        depsAddress = depsAddress.add(4L);
        while (depsAddress.compareTo((Object)depsEndAddress) < 0) {
            monitor.checkCanceled();
            this.createData(program, depsAddress, (DataType)new DWordDataType());
            int stringLength = program.getMemory().getInt(depsAddress);
            depsAddress = depsAddress.add(4L);
            program.getListing().createData(depsAddress, (DataType)new StringDataType(), stringLength);
            depsAddress = depsAddress.add((long)stringLength);
            for (int i = 0; i < 5; ++i) {
                this.createData(program, depsAddress, (DataType)new DWordDataType());
                depsAddress = depsAddress.add(4L);
            }
        }
    }
}

