/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex.analyzer;

import ghidra.app.util.importer.MessageLog;
import ghidra.file.formats.android.dex.format.DexHeader;
import ghidra.program.flatapi.FlatProgramAPI;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.NotFoundException;
import ghidra.util.task.TaskMonitor;

class DexHeaderFragmentManager {
    private Program program;
    private Address baseAddress;
    private FlatProgramAPI api;
    private boolean isCreateFragments;
    AddressSet classesAddressSet = new AddressSet();
    AddressSet classStaticValuesAddressSet = new AddressSet();
    AddressSet classDataAddressSet = new AddressSet();
    AddressSet codeItemAddressSet = new AddressSet();
    AddressSet encodedFieldsAddressSet = new AddressSet();
    AddressSet encodedMethodsAddressSet = new AddressSet();
    AddressSet debugInfoAddressSet = new AddressSet();
    AddressSet handlersAddressSet = new AddressSet();
    AddressSet tryAddressSet = new AddressSet();
    AddressSet annotationsAddressSet = new AddressSet();
    AddressSet classAnnotationsAddressSet = new AddressSet();
    AddressSet annotationFieldsAddressSet = new AddressSet();
    AddressSet annotationMethodsAddressSet = new AddressSet();
    AddressSet annotationParametersAddressSet = new AddressSet();
    AddressSet annotationItemAddressSet = new AddressSet();
    AddressSet interfacesAddressSet = new AddressSet();
    AddressSet methodsAddressSet = new AddressSet();
    AddressSet fieldsAddressSet = new AddressSet();
    AddressSet prototypesAddressSet = new AddressSet();
    AddressSet typesAddressSet = new AddressSet();
    AddressSet mapAddressSet = new AddressSet();
    AddressSet stringDataAddressSet = new AddressSet();
    AddressSet stringsDataSet = new AddressSet();
    AddressSet[] addressSets = new AddressSet[]{this.classesAddressSet, this.classStaticValuesAddressSet, this.classDataAddressSet, this.codeItemAddressSet, this.encodedFieldsAddressSet, this.encodedMethodsAddressSet, this.debugInfoAddressSet, this.handlersAddressSet, this.tryAddressSet, this.annotationsAddressSet, this.classAnnotationsAddressSet, this.annotationFieldsAddressSet, this.annotationMethodsAddressSet, this.annotationParametersAddressSet, this.annotationItemAddressSet, this.interfacesAddressSet, this.methodsAddressSet, this.fieldsAddressSet, this.prototypesAddressSet, this.typesAddressSet, this.mapAddressSet, this.stringDataAddressSet, this.stringsDataSet};
    private String[] addressSetNames = new String[]{"classes", "class_static_values", "class_data", "code_item", "encoded_fields", "encoded_methods", "debug_info", "handlers", "try", "annotations", "class_annotations", "annotation_fields", "annotation_methods", "annotation_parameters", "annotation_item", "interfaces", "methods", "fields", "prototypes", "types", "map", "string_data", "strings"};

    DexHeaderFragmentManager(Program program, Address baseAddress, FlatProgramAPI api, boolean isCreateFragments) {
        this.program = program;
        this.baseAddress = baseAddress;
        this.api = api;
        this.isCreateFragments = isCreateFragments;
    }

    void createFragments(TaskMonitor monitor, MessageLog log) throws CancelledException {
        if (!this.isCreateFragments) {
            return;
        }
        monitor.initialize((long)this.addressSetNames.length);
        for (int i = 0; i < this.addressSetNames.length; ++i) {
            this.createFragment(this.addressSetNames[i], this.addressSets[i], monitor, log);
        }
    }

    void createFragment(String fragmentName, AddressSet addressSet, TaskMonitor monitor, MessageLog log) throws CancelledException {
        if (!this.isCreateFragments) {
            return;
        }
        monitor.incrementProgress(1L);
        monitor.checkCanceled();
        monitor.setMessage("DEX: creating fragment: " + fragmentName + " ...");
        try {
            ProgramModule module = this.program.getListing().getDefaultRootModule();
            ProgramFragment fragment = this.api.getFragment(module, fragmentName);
            if (fragment == null) {
                fragment = module.createFragment(fragmentName);
            }
            for (AddressRange range : addressSet) {
                monitor.checkCanceled();
                fragment.move(range.getMinAddress(), range.getMaxAddress());
            }
        }
        catch (Exception e) {
            log.appendMsg(e.getMessage());
        }
    }

    void createInitialFragments(DexHeader header, TaskMonitor monitor) throws Exception {
        if (!this.isCreateFragments) {
            return;
        }
        monitor.setMessage("DEX: creating fragments");
        if (header.getDataSize() > 0) {
            Address start = this.baseAddress.add((long)header.getDataOffset());
            try {
                this.api.createFragment("data", start, (long)header.getDataSize());
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
    }

    void createHeaderFragment(Address headerAddress, DataType headerDataType) throws DuplicateNameException, NotFoundException {
        if (!this.isCreateFragments) {
            return;
        }
        this.api.createFragment("header", headerAddress, (long)headerDataType.getLength());
    }
}

