/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.workflow;

import ghidra.app.plugin.core.debug.workflow.AbstractMapDebuggerBot;
import ghidra.app.services.DebuggerBotInfo;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.app.services.MapProposal;
import ghidra.app.services.ModuleMapProposal;
import ghidra.framework.options.annotation.HelpInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Program;
import ghidra.trace.model.Trace;
import ghidra.trace.model.modules.TraceModule;
import ghidra.trace.util.TraceChangeType;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

@DebuggerBotInfo(description="Map modules to open programs", details="Monitors open traces and programs, attempting to map modules by \"best\" match.", help=@HelpInfo(anchor="map_modules"), enabledByDefault=true)
public class MapModulesDebuggerBot
extends AbstractMapDebuggerBot {
    @Override
    protected Collection<TraceChangeType<?, ?>> getChangeTypes() {
        return List.of(Trace.TraceModuleChangeType.ADDED, Trace.TraceModuleChangeType.CHANGED, Trace.TraceMemoryRegionChangeType.ADDED, Trace.TraceMemoryRegionChangeType.CHANGED);
    }

    @Override
    protected void doAnalysis(PluginTool tool, Trace trace, Set<Program> programs, TaskMonitor monitor) throws CancelledException {
        DebuggerStaticMappingService mappingService = (DebuggerStaticMappingService)tool.getService(DebuggerStaticMappingService.class);
        if (mappingService != null) {
            Map<TraceModule, ModuleMapProposal> maps = mappingService.proposeModuleMaps(trace.getModuleManager().getAllModules(), programs);
            Collection<ModuleMapProposal.ModuleMapEntry> entries = MapProposal.flatten(maps.values());
            entries = MapProposal.removeOverlapping(entries);
            mappingService.addModuleMappings(entries, monitor, false);
        }
    }
}

