/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.tracemgr;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.Tool;
import docking.action.DockingAction;
import docking.action.ToggleDockingAction;
import docking.action.builder.ActionBuilder;
import docking.action.builder.ToggleActionBuilder;
import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.core.debug.event.DebuggerPlatformPluginEvent;
import ghidra.app.plugin.core.debug.event.ModelObjectFocusedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceActivatedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceClosedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceOpenedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceRecorderAdvancedPluginEvent;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.mapping.DebuggerPlatformMapper;
import ghidra.app.services.DebuggerEmulationService;
import ghidra.app.services.DebuggerModelService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.app.services.TraceRecorder;
import ghidra.async.AsyncConfigFieldCodec;
import ghidra.async.AsyncReference;
import ghidra.async.AsyncUtils;
import ghidra.async.SwingExecutorService;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetStackFrame;
import ghidra.dbg.target.TargetThread;
import ghidra.framework.client.ClientUtil;
import ghidra.framework.client.NotConnectedException;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.main.DataTreeDialog;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFileFilter;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.AutoConfigState;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoConfigStateField;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.lifecycle.Internal;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceDomainObjectListener;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.trace.model.program.TraceVariableSnapProgramView;
import ghidra.trace.model.stack.TraceStackFrame;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectKeyPath;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.model.time.TraceSnapshot;
import ghidra.trace.model.time.schedule.TraceSchedule;
import ghidra.trace.util.TraceChangeType;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.TriConsumer;
import ghidra.util.VersionExceptionHandler;
import ghidra.util.datastruct.CollectionChangeListener;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateFileException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;

@PluginInfo(shortDescription="Debugger Trace View Management Plugin", description="Manages UI Components, Wrappers, Focus, etc.", category="Debugger", packageName="Debugger", status=PluginStatus.RELEASED, eventsProduced={TraceActivatedPluginEvent.class}, eventsConsumed={TraceActivatedPluginEvent.class, TraceClosedPluginEvent.class, ModelObjectFocusedPluginEvent.class, TraceRecorderAdvancedPluginEvent.class, DebuggerPlatformPluginEvent.class}, servicesRequired={}, servicesProvided={DebuggerTraceManagerService.class})
public class DebuggerTraceManagerServicePlugin
extends Plugin
implements DebuggerTraceManagerService {
    private static final AutoConfigState.ClassHandler<DebuggerTraceManagerServicePlugin> CONFIG_STATE_HANDLER = AutoConfigState.wireHandler(DebuggerTraceManagerServicePlugin.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final String KEY_TRACE_COUNT = "NUM_TRACES";
    private static final String PREFIX_OPEN_TRACE = "OPEN_TRACE_";
    private static final String KEY_CURRENT_COORDS = "CURRENT_COORDS";
    public static final String NEW_TRACES_FOLDER_NAME = "New Traces";
    protected final Map<Trace, DebuggerCoordinates> lastCoordsByTrace = new WeakHashMap<Trace, DebuggerCoordinates>();
    protected final Map<Trace, ListenerForTraceChanges> listenersByTrace = new WeakHashMap<Trace, ListenerForTraceChanges>();
    protected final Set<Trace> tracesView = Collections.unmodifiableSet(this.listenersByTrace.keySet());
    private final ForRecordersListener forRecordersListener = new ForRecordersListener();
    protected DebuggerCoordinates current = DebuggerCoordinates.NOWHERE;
    protected TargetObject curObj;
    @AutoConfigStateField(codec=AsyncConfigFieldCodec.BooleanAsyncConfigFieldCodec.class)
    protected final AsyncReference<Boolean, Void> autoActivatePresent = new AsyncReference((Object)true);
    @AutoConfigStateField(codec=AsyncConfigFieldCodec.BooleanAsyncConfigFieldCodec.class)
    protected final AsyncReference<Boolean, Void> saveTracesByDefault = new AsyncReference((Object)true);
    @AutoConfigStateField(codec=AsyncConfigFieldCodec.BooleanAsyncConfigFieldCodec.class)
    protected final AsyncReference<Boolean, Void> synchronizeFocus = new AsyncReference((Object)true);
    @AutoConfigStateField(codec=AsyncConfigFieldCodec.BooleanAsyncConfigFieldCodec.class)
    protected final AsyncReference<Boolean, Void> autoCloseOnTerminate = new AsyncReference((Object)true);
    private DebuggerModelService modelService;
    @AutoServiceConsumed
    private DebuggerEmulationService emulationService;
    private final AutoService.Wiring autoServiceWiring;
    private DataTreeDialog traceChooserDialog;
    DockingAction actionCloseTrace;
    DockingAction actionCloseAllTraces;
    DockingAction actionCloseOtherTraces;
    DockingAction actionCloseDeadTraces;
    DockingAction actionSaveTrace;
    DockingAction actionOpenTrace;
    ToggleDockingAction actionSaveByDefault;
    ToggleDockingAction actionCloseOnTerminate;
    Set<Object> strongRefs = new HashSet<Object>();

    public DebuggerTraceManagerServicePlugin(PluginTool plugintool) {
        super(plugintool);
        this.autoServiceWiring = AutoService.wireServicesProvidedAndConsumed((Plugin)this);
    }

    private <T> T strongRef(T t) {
        this.strongRefs.add(t);
        return t;
    }

    protected <T> CompletableFuture<T> tryHarder(Supplier<CompletableFuture<T>> action, int retries, long retryAfterMillis) {
        Executor exe = CompletableFuture.delayedExecutor(retryAfterMillis, TimeUnit.MILLISECONDS);
        CompletionStage result = CompletableFuture.supplyAsync(action, AsyncUtils.SWING_EXECUTOR).thenCompose(f -> f);
        if (retries > 0) {
            return ((CompletableFuture)((CompletableFuture)((CompletableFuture)result).thenApply(CompletableFuture::completedFuture)).exceptionally(ex -> CompletableFuture.supplyAsync(() -> this.lambda$tryHarder$1((Supplier)action, retries, retryAfterMillis), exe).thenCompose(f -> f))).thenCompose(f -> f);
        }
        return result;
    }

    protected void init() {
        super.init();
        this.createActions();
    }

    protected void createActions() {
        this.actionSaveTrace = (DockingAction)((ActionBuilder)((ActionBuilder)DebuggerResources.SaveTraceAction.builder(this).enabledWhen(c -> this.current.getTrace() != null)).onAction(this::activatedSaveTrace)).buildAndInstall((Tool)this.tool);
        this.actionOpenTrace = (DockingAction)((ActionBuilder)((ActionBuilder)DebuggerResources.OpenTraceAction.builder(this).enabledWhen(ctx -> true)).onAction(this::activatedOpenTrace)).buildAndInstall((Tool)this.tool);
        this.actionCloseTrace = (DockingAction)((ActionBuilder)((ActionBuilder)DebuggerResources.CloseTraceAction.builder(this).enabledWhen(ctx -> this.current.getTrace() != null)).onAction(this::activatedCloseTrace)).buildAndInstall((Tool)this.tool);
        this.actionCloseAllTraces = (DockingAction)((ActionBuilder)((ActionBuilder)DebuggerResources.CloseAllTracesAction.builder(this).enabledWhen(ctx -> !this.tracesView.isEmpty())).onAction(this::activatedCloseAllTraces)).buildAndInstall((Tool)this.tool);
        this.actionCloseOtherTraces = (DockingAction)((ActionBuilder)((ActionBuilder)DebuggerResources.CloseOtherTracesAction.builder(this).enabledWhen(ctx -> this.tracesView.size() > 1 && this.current.getTrace() != null)).onAction(this::activatedCloseOtherTraces)).buildAndInstall((Tool)this.tool);
        this.actionCloseDeadTraces = (DockingAction)((ActionBuilder)((ActionBuilder)DebuggerResources.CloseDeadTracesAction.builder(this).enabledWhen(ctx -> !this.tracesView.isEmpty() && this.modelService != null)).onAction(this::activatedCloseDeadTraces)).buildAndInstall((Tool)this.tool);
        this.actionSaveByDefault = (ToggleDockingAction)((ToggleActionBuilder)DebuggerResources.SaveByDefaultAction.builder(this).selected(this.isSaveTracesByDefault()).onAction(c -> this.setSaveTracesByDefault(this.actionSaveByDefault.isSelected()))).buildAndInstall((Tool)this.tool);
        this.addSaveTracesByDefaultChangeListener(this.strongRef(new DebuggerResources.ToToggleSelectionListener(this.actionSaveByDefault)));
        this.actionCloseOnTerminate = (ToggleDockingAction)((ToggleActionBuilder)DebuggerResources.CloseOnTerminateAction.builder(this).selected(this.isAutoCloseOnTerminate()).onAction(c -> this.setAutoCloseOnTerminate(this.actionCloseOnTerminate.isSelected()))).buildAndInstall((Tool)this.tool);
        this.addAutoCloseOnTerminateChangeListener(this.strongRef(new DebuggerResources.ToToggleSelectionListener(this.actionCloseOnTerminate)));
    }

    private void activatedSaveTrace(ActionContext ctx) {
        Trace trace = this.current.getTrace();
        if (trace == null) {
            return;
        }
        this.saveTrace(trace);
    }

    private void activatedOpenTrace(ActionContext ctx) {
        DomainFile df = this.askTrace(this.current.getTrace());
        if (df != null) {
            Trace trace = this.openTrace(df, -1);
            this.activateTrace(trace);
        }
    }

    private void activatedCloseTrace(ActionContext ctx) {
        Trace trace = this.current.getTrace();
        if (trace == null) {
            return;
        }
        this.closeTrace(trace);
    }

    private void activatedCloseAllTraces(ActionContext ctx) {
        this.closeAllTraces();
    }

    private void activatedCloseOtherTraces(ActionContext ctx) {
        Trace trace = this.current.getTrace();
        if (trace == null) {
            return;
        }
        this.closeOtherTraces(trace);
    }

    private void activatedCloseDeadTraces(ActionContext ctx) {
        this.closeDeadTraces();
    }

    protected DataTreeDialog getTraceChooserDialog() {
        if (this.traceChooserDialog != null) {
            return this.traceChooserDialog;
        }
        DomainFileFilter filter = df -> Trace.class.isAssignableFrom(df.getDomainObjectClass());
        this.traceChooserDialog = new DataTreeDialog(null, "Open Trace", 0, filter){
            {
                this.dialogShown();
            }
        };
        return this.traceChooserDialog;
    }

    public DomainFile askTrace(Trace trace) {
        this.getTraceChooserDialog();
        if (trace != null) {
            this.traceChooserDialog.selectDomainFile(trace.getDomainFile());
        }
        this.tool.showDialog((DialogComponentProvider)this.traceChooserDialog);
        return this.traceChooserDialog.getDomainFile();
    }

    @Override
    public void closeAllTraces() {
        Swing.runIfSwingOrRunLater(() -> {
            for (Trace trace : this.getOpenTraces()) {
                this.closeTrace(trace);
            }
        });
    }

    @Override
    public void closeOtherTraces(Trace keep) {
        Swing.runIfSwingOrRunLater(() -> {
            for (Trace trace : this.getOpenTraces()) {
                if (trace == keep) continue;
                this.closeTrace(trace);
            }
        });
    }

    @Override
    public void closeDeadTraces() {
        Swing.runIfSwingOrRunLater(() -> {
            if (this.modelService == null) {
                return;
            }
            for (Trace trace : this.getOpenTraces()) {
                TraceRecorder recorder = this.modelService.getRecorder(trace);
                if (recorder != null) continue;
                this.closeTrace(trace);
            }
        });
    }

    @AutoServiceConsumed
    private void setModelService(DebuggerModelService modelService) {
        if (this.modelService != null) {
            this.modelService.removeTraceRecordersChangedListener(this.forRecordersListener);
        }
        this.modelService = modelService;
        if (this.modelService != null) {
            this.modelService.addTraceRecordersChangedListener(this.forRecordersListener);
        }
    }

    public Class<?>[] getSupportedDataTypes() {
        return new Class[]{Trace.class};
    }

    public boolean acceptData(DomainFile[] data) {
        if (data == null || data.length == 0) {
            return false;
        }
        List<DomainFile> toOpen = Arrays.asList(data).stream().filter(f -> Trace.class.isAssignableFrom(f.getDomainObjectClass())).collect(Collectors.toList());
        Collection<Trace> openTraces = this.openTraces(toOpen);
        if (!openTraces.isEmpty()) {
            this.activateTrace(openTraces.iterator().next());
            return true;
        }
        return false;
    }

    protected TraceThread threadFromTargetFocus(TraceRecorder recorder, TargetObject focus) {
        return focus == null ? null : recorder.getTraceThreadForSuccessor(focus);
    }

    protected TraceObject objectFromTargetFocus(TraceRecorder recorder, TargetObject focus) {
        return focus == null ? null : recorder.getTrace().getObjectManager().getObjectByCanonicalPath(TraceObjectKeyPath.of((List)focus.getPath()));
    }

    protected TraceStackFrame frameFromTargetFocus(TraceRecorder recorder, TargetObject focus) {
        return focus == null ? null : recorder.getTraceStackFrameForSuccessor(focus);
    }

    protected boolean supportsFocus(TraceRecorder recorder) {
        return recorder != null && recorder.isSupportsFocus();
    }

    protected DebuggerCoordinates fillInRecorder(Trace trace, DebuggerCoordinates coordinates) {
        if (trace == null) {
            return DebuggerCoordinates.NOWHERE;
        }
        if (coordinates.getRecorder() != null) {
            return coordinates;
        }
        TraceRecorder recorder = this.computeRecorder(trace);
        if (recorder == null) {
            return coordinates;
        }
        return coordinates.recorder(recorder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DebuggerCoordinates doSetCurrent(DebuggerCoordinates newCurrent) {
        newCurrent = newCurrent == null ? DebuggerCoordinates.NOWHERE : newCurrent;
        Map<Trace, ListenerForTraceChanges> map = this.listenersByTrace;
        synchronized (map) {
            DebuggerCoordinates resolved = this.fillInRecorder(newCurrent.getTrace(), newCurrent);
            if (this.current.equals(resolved)) {
                return null;
            }
            this.current = resolved;
            this.contextChanged();
            if (resolved.getTrace() != null) {
                this.lastCoordsByTrace.put(resolved.getTrace(), resolved);
            }
            return resolved;
        }
    }

    protected void contextChanged() {
        Trace trace = this.current.getTrace();
        String itemName = trace == null ? "..." : trace.getName();
        this.actionCloseTrace.getMenuBarData().setMenuItemName("Close " + itemName);
        this.actionSaveTrace.getMenuBarData().setMenuItemName("Save " + itemName);
        this.tool.contextChanged(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doModelObjectFocused(TargetObject obj, boolean requirePresent) {
        this.curObj = obj;
        if (!((Boolean)this.synchronizeFocus.get()).booleanValue()) {
            return false;
        }
        if (requirePresent && !this.current.isDeadOrPresent()) {
            return false;
        }
        if (this.modelService == null) {
            return false;
        }
        TraceRecorder recorder = this.modelService.getRecorderForSuccessor(obj);
        if (recorder == null) {
            return false;
        }
        Trace trace = recorder.getTrace();
        Map<Trace, ListenerForTraceChanges> map = this.listenersByTrace;
        synchronized (map) {
            if (!this.listenersByTrace.containsKey(trace)) {
                return false;
            }
        }
        this.activateNoFocus(this.getCurrentFor(trace).object(obj));
        return true;
    }

    protected void doTraceRecorderAdvanced(TraceRecorder recorder, long snap) {
        if (!((Boolean)this.autoActivatePresent.get()).booleanValue()) {
            return;
        }
        if (recorder.getTrace() != this.current.getTrace()) {
            return;
        }
        this.activateSnap(snap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPlatformMapperSelected(Trace trace, DebuggerPlatformMapper mapper) {
        Map<Trace, ListenerForTraceChanges> map = this.listenersByTrace;
        synchronized (map) {
            if (!this.listenersByTrace.containsKey(trace)) {
                return;
            }
            DebuggerCoordinates cur = this.lastCoordsByTrace.getOrDefault(trace, DebuggerCoordinates.NOWHERE);
            DebuggerCoordinates adj = cur.platform(trace.getPlatformManager().getPlatform(mapper.getCompilerSpec(cur.getObject())));
            this.lastCoordsByTrace.put(trace, adj);
            if (trace == this.current.getTrace()) {
                this.current = adj;
                this.fireLocationEvent(adj);
            }
        }
    }

    protected TraceRecorder computeRecorder(Trace trace) {
        if (this.modelService == null) {
            return null;
        }
        if (trace == null) {
            return null;
        }
        return this.modelService.getRecorder(trace);
    }

    protected void updateCurrentRecorder() {
        TraceRecorder recorder = this.computeRecorder(this.current.getTrace());
        if (recorder == null) {
            return;
        }
        DebuggerCoordinates toActivate = this.current.recorder(recorder);
        if (((Boolean)this.autoActivatePresent.get()).booleanValue()) {
            this.activate(toActivate.snap(recorder.getSnap()));
        } else {
            this.activate(toActivate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvent(PluginEvent event) {
        super.processEvent(event);
        if (event instanceof TraceActivatedPluginEvent) {
            TraceActivatedPluginEvent ev = (TraceActivatedPluginEvent)event;
            Map<Trace, ListenerForTraceChanges> map = this.listenersByTrace;
            synchronized (map) {
                this.doSetCurrent(ev.getActiveCoordinates());
            }
        } else if (event instanceof TraceClosedPluginEvent) {
            TraceClosedPluginEvent ev = (TraceClosedPluginEvent)event;
            this.doTraceClosed(ev.getTrace());
        } else if (event instanceof ModelObjectFocusedPluginEvent) {
            ModelObjectFocusedPluginEvent ev = (ModelObjectFocusedPluginEvent)event;
            this.doModelObjectFocused(ev.getFocus(), true);
        } else if (event instanceof TraceRecorderAdvancedPluginEvent) {
            TraceRecorderAdvancedPluginEvent ev = (TraceRecorderAdvancedPluginEvent)event;
            this.doTraceRecorderAdvanced(ev.getRecorder(), ev.getSnap());
        } else if (event instanceof DebuggerPlatformPluginEvent) {
            DebuggerPlatformPluginEvent ev = (DebuggerPlatformPluginEvent)event;
            this.doPlatformMapperSelected(ev.getTrace(), ev.getMapper());
        }
    }

    @Override
    public synchronized Collection<Trace> getOpenTraces() {
        return Set.copyOf(this.tracesView);
    }

    @Override
    public DebuggerCoordinates getCurrent() {
        return this.current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DebuggerCoordinates getCurrentFor(Trace trace) {
        Map<Trace, ListenerForTraceChanges> map = this.listenersByTrace;
        synchronized (map) {
            return this.fillInRecorder(trace, this.lastCoordsByTrace.getOrDefault(trace, DebuggerCoordinates.NOWHERE));
        }
    }

    @Override
    public Trace getCurrentTrace() {
        return this.current.getTrace();
    }

    @Override
    public TracePlatform getCurrentPlatform() {
        return this.current.getPlatform();
    }

    @Override
    public TraceProgramView getCurrentView() {
        return this.current.getView();
    }

    @Override
    public TraceThread getCurrentThread() {
        return this.current.getThread();
    }

    @Override
    public long getCurrentSnap() {
        return this.current.getSnap();
    }

    @Override
    public int getCurrentFrame() {
        return this.current.getFrame();
    }

    @Override
    public TraceObject getCurrentObject() {
        return this.current.getObject();
    }

    @Override
    public Long findSnapshot(DebuggerCoordinates coordinates) {
        if (coordinates.getTime().isSnapOnly()) {
            return coordinates.getSnap();
        }
        Collection suitable = coordinates.getTrace().getTimeManager().getSnapshotsWithSchedule(coordinates.getTime());
        if (!suitable.isEmpty()) {
            TraceSnapshot found = (TraceSnapshot)suitable.iterator().next();
            return found.getKey();
        }
        return null;
    }

    @Override
    public CompletableFuture<Long> materialize(DebuggerCoordinates coordinates) {
        Long found = this.findSnapshot(coordinates);
        if (found != null) {
            return CompletableFuture.completedFuture(found);
        }
        if (this.emulationService == null) {
            throw new IllegalStateException("Cannot navigate to coordinates with execution schedules, because the emulation service is not available.");
        }
        return this.emulationService.backgroundEmulate(coordinates.getPlatform(), coordinates.getTime());
    }

    protected CompletableFuture<Void> prepareViewAndFireEvent(DebuggerCoordinates coordinates) {
        TraceVariableSnapProgramView varView = (TraceVariableSnapProgramView)coordinates.getView();
        if (varView == null) {
            this.fireLocationEvent(coordinates);
            return AsyncUtils.NIL;
        }
        return this.materialize(coordinates).thenAcceptAsync(snap -> {
            if (!coordinates.equals(this.current)) {
                return;
            }
            varView.setSnap(snap.longValue());
            this.fireLocationEvent(coordinates);
        }, (Executor)SwingExecutorService.MAYBE_NOW);
    }

    protected void fireLocationEvent(DebuggerCoordinates coordinates) {
        this.firePluginEvent(new TraceActivatedPluginEvent(this.getName(), coordinates));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openTrace(Trace trace) {
        if (trace.getConsumerList().contains(this)) {
            return;
        }
        trace.addConsumer((Object)this);
        Map<Trace, ListenerForTraceChanges> map = this.listenersByTrace;
        synchronized (map) {
            if (this.listenersByTrace.containsKey(trace)) {
                return;
            }
            ListenerForTraceChanges listener = new ListenerForTraceChanges(trace);
            this.listenersByTrace.put(trace, listener);
            trace.addListener((DomainObjectListener)listener);
        }
        this.contextChanged();
        this.firePluginEvent(new TraceOpenedPluginEvent(this.getName(), trace));
    }

    @Override
    public Trace openTrace(DomainFile file, int version) {
        try {
            return this.doOpenTrace(file, version, new Object(), TaskMonitor.DUMMY);
        }
        catch (CancelledException e) {
            throw new AssertionError((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Trace doOpenTrace(DomainFile file, int version, Object consumer, TaskMonitor monitor) throws CancelledException {
        DomainObject obj = null;
        try {
            obj = version == -1 ? file.getDomainObject(consumer, true, true, monitor) : file.getReadOnlyDomainObject(consumer, version, monitor);
            Trace trace = (Trace)obj;
            this.openTrace(trace);
            Trace trace2 = trace;
            return trace2;
        }
        catch (VersionException e) {
            e = new VersionException(e.getVersionIndicator(), false).combine(e);
            VersionExceptionHandler.showVersionError(null, (String)file.getName(), (String)file.getContentType(), (String)"Open", (VersionException)e);
            Trace trace = null;
            return trace;
        }
        catch (IOException e) {
            if (file.isInWritableProject()) {
                ClientUtil.handleException((RepositoryAdapter)this.tool.getProject().getRepository(), (Exception)e, (String)"Open Trace", null);
            } else {
                Msg.showError((Object)this, null, (String)"Error Opening Trace", (Object)("Could not open " + file.getName()), (Throwable)e);
            }
            Trace trace = null;
            return trace;
        }
        finally {
            if (obj != null) {
                obj.release(consumer);
            }
        }
    }

    @Override
    public Collection<Trace> openTraces(final Collection<DomainFile> files) {
        final ArrayList<Trace> result = new ArrayList<Trace>();
        new TaskLauncher(new Task("Open Traces", true, true, true){

            public void run(TaskMonitor monitor) throws CancelledException {
                for (DomainFile f : files) {
                    try {
                        result.add(DebuggerTraceManagerServicePlugin.this.doOpenTrace(f, -1, (Object)this, monitor));
                    }
                    catch (ClassCastException e) {
                        Msg.error((Object)((Object)this), (Object)("Attempted to open non-Trace domain file: " + f));
                    }
                }
            }
        });
        return result;
    }

    public static DomainFolder createOrGetFolder(PluginTool tool, String operation, DomainFolder parent, String name) throws InvalidNameException {
        try {
            return parent.createFolder(name);
        }
        catch (DuplicateFileException e) {
            return parent.getFolder(name);
        }
        catch (NotConnectedException | ConnectException e) {
            ClientUtil.promptForReconnect((RepositoryAdapter)tool.getProject().getRepository(), (Component)tool.getToolFrame());
            return null;
        }
        catch (IOException e) {
            ClientUtil.handleException((RepositoryAdapter)tool.getProject().getRepository(), (Exception)e, (String)operation, (Component)tool.getToolFrame());
            return null;
        }
    }

    public static CompletableFuture<Void> saveTrace(final PluginTool tool, final Trace trace) {
        tool.prepareToSave((DomainObject)trace);
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (trace.getDomainFile().getParent() != null) {
            new TaskLauncher(new Task("Save Trace", true, true, true){

                public void run(TaskMonitor monitor) throws CancelledException {
                    try {
                        trace.getDomainFile().save(monitor);
                        future.complete(null);
                    }
                    catch (CancelledException e) {
                        future.completeExceptionally(e);
                    }
                    catch (NotConnectedException | ConnectException e) {
                        ClientUtil.promptForReconnect((RepositoryAdapter)tool.getProject().getRepository(), (Component)tool.getToolFrame());
                        future.completeExceptionally(e);
                    }
                    catch (IOException e) {
                        ClientUtil.handleException((RepositoryAdapter)tool.getProject().getRepository(), (Exception)e, (String)"Save Trace", (Component)tool.getToolFrame());
                        future.completeExceptionally(e);
                    }
                    catch (Throwable e) {
                        future.completeExceptionally(e);
                    }
                }
            });
        } else {
            DomainFolder traces;
            Object filename = trace.getName();
            DomainFolder root = tool.getProject().getProjectData().getRootFolder();
            DomainFile existing = root.getFile((String)filename);
            int i = 1;
            while (existing != null) {
                filename = trace.getName() + "." + i;
                existing = root.getFile((String)filename);
                ++i;
            }
            try {
                traces = DebuggerTraceManagerServicePlugin.createOrGetFolder(tool, "Save New Trace", root, NEW_TRACES_FOLDER_NAME);
            }
            catch (InvalidNameException e) {
                throw new AssertionError((Object)e);
            }
            Object finalFilename = filename;
            new TaskLauncher(new Task("Save New Trace", true, true, true, (String)finalFilename, trace, future, tool){
                final /* synthetic */ String val$finalFilename;
                final /* synthetic */ Trace val$trace;
                final /* synthetic */ CompletableFuture val$future;
                final /* synthetic */ PluginTool val$tool;
                {
                    this.val$finalFilename = string;
                    this.val$trace = trace;
                    this.val$future = completableFuture;
                    this.val$tool = pluginTool;
                    super(arg0, arg1, arg2, arg3);
                }

                public void run(TaskMonitor monitor) throws CancelledException {
                    try {
                        traces.createFile(this.val$finalFilename, (DomainObject)this.val$trace, monitor);
                        this.val$trace.save("Initial save", monitor);
                        this.val$future.complete(null);
                    }
                    catch (CancelledException e) {
                        this.val$future.completeExceptionally(e);
                    }
                    catch (NotConnectedException | ConnectException e) {
                        ClientUtil.promptForReconnect((RepositoryAdapter)this.val$tool.getProject().getRepository(), (Component)this.val$tool.getToolFrame());
                        this.val$future.completeExceptionally(e);
                    }
                    catch (IOException e) {
                        ClientUtil.handleException((RepositoryAdapter)this.val$tool.getProject().getRepository(), (Exception)e, (String)"Save New Trace", (Component)this.val$tool.getToolFrame());
                        this.val$future.completeExceptionally(e);
                    }
                    catch (InvalidNameException e) {
                        Msg.showError(DebuggerTraceManagerServicePlugin.class, null, (String)"Save New Trace Error", (Object)e.getMessage());
                        this.val$future.completeExceptionally(e);
                    }
                    catch (Throwable e) {
                        Msg.showError(DebuggerTraceManagerServicePlugin.class, null, (String)"Save New Trace Error", (Object)e.getMessage(), (Throwable)e);
                        this.val$future.completeExceptionally(e);
                    }
                }
            });
        }
        return future;
    }

    @Override
    public CompletableFuture<Void> saveTrace(Trace trace) {
        if (this.isDisposed()) {
            Msg.error((Object)this, (Object)"Cannot save trace after manager disposal! Data may have been lost.");
            return AsyncUtils.NIL;
        }
        return DebuggerTraceManagerServicePlugin.saveTrace(this.tool, trace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doTraceClosed(Trace trace) {
        Map<Trace, ListenerForTraceChanges> map = this.listenersByTrace;
        synchronized (map) {
            trace.release((Object)this);
            this.lastCoordsByTrace.remove(trace);
            trace.removeListener((DomainObjectListener)this.listenersByTrace.remove(trace));
        }
        if (this.current.getTrace() == trace) {
            this.activate(DebuggerCoordinates.NOWHERE);
        } else {
            this.contextChanged();
        }
    }

    @Override
    public void closeTrace(Trace trace) {
        Swing.runIfSwingOrRunLater(() -> {
            if (trace.getConsumerList().contains(this)) {
                this.firePluginEvent(new TraceClosedPluginEvent(this.getName(), trace));
                this.doTraceClosed(trace);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispose() {
        super.dispose();
        this.activate(DebuggerCoordinates.NOWHERE);
        Map<Trace, ListenerForTraceChanges> map = this.listenersByTrace;
        synchronized (map) {
            Iterator<Trace> it = this.listenersByTrace.keySet().iterator();
            while (it.hasNext()) {
                Trace trace = it.next();
                trace.release((Object)this);
                this.lastCoordsByTrace.remove(trace);
                trace.removeListener((DomainObjectListener)this.listenersByTrace.get(trace));
                it.remove();
            }
            this.lastCoordsByTrace.clear();
        }
        this.autoServiceWiring.dispose();
    }

    @Internal
    private String stackTraceUp(int levels) {
        StackTraceElement elem = new Throwable().getStackTrace()[levels += 2];
        return elem.toString();
    }

    protected void activateNoFocus(DebuggerCoordinates coordinates) {
        DebuggerCoordinates resolved = this.doSetCurrent(coordinates);
        if (resolved == null) {
            return;
        }
        this.prepareViewAndFireEvent(resolved);
    }

    protected static boolean isSameFocus(DebuggerCoordinates prev, DebuggerCoordinates resolved) {
        if (!Objects.equals(prev.getObject(), resolved.getObject())) {
            return false;
        }
        if (!Objects.equals(prev.getFrame(), resolved.getFrame())) {
            return false;
        }
        if (!Objects.equals(prev.getThread(), resolved.getThread())) {
            return false;
        }
        return Objects.equals(prev.getTrace(), resolved.getTrace());
    }

    protected static TargetObject translateToFocus(DebuggerCoordinates prev, DebuggerCoordinates resolved) {
        TargetObject object;
        if (!resolved.isAliveAndPresent()) {
            return null;
        }
        if (DebuggerTraceManagerServicePlugin.isSameFocus(prev, resolved)) {
            return null;
        }
        TraceRecorder recorder = resolved.getRecorder();
        TraceObject obj = resolved.getObject();
        if (obj != null && (object = recorder.getTarget().getSuccessor(obj.getCanonicalPath().getKeyList())) != null) {
            return object;
        }
        TargetStackFrame frame = recorder.getTargetStackFrame(resolved.getThread(), resolved.getFrame());
        if (frame != null) {
            return frame;
        }
        TargetThread thread = recorder.getTargetThread(resolved.getThread());
        if (thread != null) {
            return thread;
        }
        return recorder.getTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> activateAndNotify(DebuggerCoordinates coordinates, boolean syncTargetFocus) {
        DebuggerCoordinates resolved;
        DebuggerCoordinates prev;
        Map<Trace, ListenerForTraceChanges> map = this.listenersByTrace;
        synchronized (map) {
            prev = this.current;
            resolved = this.doSetCurrent(coordinates);
        }
        if (resolved == null) {
            return AsyncUtils.NIL;
        }
        CompletableFuture<Void> future = this.prepareViewAndFireEvent(resolved);
        if (!syncTargetFocus) {
            return future;
        }
        if (!((Boolean)this.synchronizeFocus.get()).booleanValue()) {
            return future;
        }
        TraceRecorder recorder = resolved.getRecorder();
        if (recorder == null) {
            return future;
        }
        TargetObject focus = DebuggerTraceManagerServicePlugin.translateToFocus(prev, resolved);
        if (focus == null || !focus.isValid()) {
            return future;
        }
        recorder.requestFocus(focus);
        return future;
    }

    @Override
    public void activate(DebuggerCoordinates coordinates) {
        this.activateAndNotify(coordinates, true);
    }

    public void activateNoFocusChange(DebuggerCoordinates coordinates) {
        this.activateAndNotify(coordinates, false);
    }

    @Override
    public DebuggerCoordinates resolveTrace(Trace trace) {
        return this.getCurrentFor(trace).trace(trace);
    }

    @Override
    public DebuggerCoordinates resolvePlatform(TracePlatform platform) {
        Trace trace = platform == null ? null : platform.getTrace();
        return this.getCurrentFor(trace).platform(platform);
    }

    @Override
    public DebuggerCoordinates resolveThread(TraceThread thread) {
        Trace trace = thread == null ? null : thread.getTrace();
        return this.getCurrentFor(trace).thread(thread);
    }

    @Override
    public DebuggerCoordinates resolveSnap(long snap) {
        return this.current.snap(snap);
    }

    @Override
    public DebuggerCoordinates resolveTime(TraceSchedule time) {
        return this.current.time(time);
    }

    @Override
    public DebuggerCoordinates resolveView(TraceProgramView view) {
        Trace trace = view == null ? null : view.getTrace();
        return this.getCurrentFor(trace).view(view);
    }

    @Override
    public DebuggerCoordinates resolveFrame(int frameLevel) {
        return this.current.frame(frameLevel);
    }

    @Override
    public DebuggerCoordinates resolveObject(TraceObject object) {
        return this.current.object(object);
    }

    @Override
    public void setAutoActivatePresent(boolean enabled) {
        this.autoActivatePresent.set((Object)enabled, null);
        TraceRecorder curRecorder = this.current.getRecorder();
        if (enabled && curRecorder != null) {
            this.activateNoFocus(this.current.snap(curRecorder.getSnap()));
        }
    }

    @Override
    public boolean isAutoActivatePresent() {
        return (Boolean)this.autoActivatePresent.get();
    }

    @Override
    public void addAutoActivatePresentChangeListener(DebuggerTraceManagerService.BooleanChangeAdapter listener) {
        this.autoActivatePresent.addChangeListener((TriConsumer)listener);
    }

    @Override
    public void removeAutoActivatePresentChangeListener(DebuggerTraceManagerService.BooleanChangeAdapter listener) {
        this.autoActivatePresent.removeChangeListener((TriConsumer)listener);
    }

    @Override
    public void setSynchronizeFocus(boolean enabled) {
        this.synchronizeFocus.set((Object)enabled, null);
    }

    @Override
    public boolean isSynchronizeFocus() {
        return (Boolean)this.synchronizeFocus.get();
    }

    @Override
    public void addSynchronizeFocusChangeListener(DebuggerTraceManagerService.BooleanChangeAdapter listener) {
        this.synchronizeFocus.addChangeListener((TriConsumer)listener);
    }

    @Override
    public void removeSynchronizeFocusChangeListener(DebuggerTraceManagerService.BooleanChangeAdapter listener) {
        this.synchronizeFocus.removeChangeListener((TriConsumer)listener);
    }

    @Override
    public void setSaveTracesByDefault(boolean enabled) {
        this.saveTracesByDefault.set((Object)enabled, null);
    }

    @Override
    public boolean isSaveTracesByDefault() {
        return (Boolean)this.saveTracesByDefault.get();
    }

    @Override
    public void addSaveTracesByDefaultChangeListener(DebuggerTraceManagerService.BooleanChangeAdapter listener) {
        this.saveTracesByDefault.addChangeListener((TriConsumer)listener);
    }

    @Override
    public void removeSaveTracesByDefaultChangeListener(DebuggerTraceManagerService.BooleanChangeAdapter listener) {
        this.saveTracesByDefault.removeChangeListener((TriConsumer)listener);
    }

    @Override
    public void setAutoCloseOnTerminate(boolean enabled) {
        this.autoCloseOnTerminate.set((Object)enabled, null);
    }

    @Override
    public boolean isAutoCloseOnTerminate() {
        return (Boolean)this.autoCloseOnTerminate.get();
    }

    @Override
    public void addAutoCloseOnTerminateChangeListener(DebuggerTraceManagerService.BooleanChangeAdapter listener) {
        this.autoCloseOnTerminate.addChangeListener((TriConsumer)listener);
    }

    @Override
    public void removeAutoCloseOnTerminateChangeListener(DebuggerTraceManagerService.BooleanChangeAdapter listener) {
        this.autoCloseOnTerminate.removeChangeListener((TriConsumer)listener);
    }

    public boolean canClose() {
        if (this.isSaveTracesByDefault()) {
            for (Trace trace : this.tracesView) {
                ProjectLocator loc = trace.getDomainFile().getProjectLocator();
                if (loc != null && !loc.isTransient()) continue;
                this.saveTrace(trace);
            }
        }
        return true;
    }

    public void writeConfigState(SaveState saveState) {
        CONFIG_STATE_HANDLER.writeConfigState((Object)this, saveState);
    }

    public void readConfigState(SaveState saveState) {
        CONFIG_STATE_HANDLER.readConfigState((Object)this, saveState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDataState(SaveState saveState) {
        Map<Trace, DebuggerCoordinates> coordsByTrace;
        List traces;
        DebuggerCoordinates currentCoords;
        if (!this.isSaveTracesByDefault()) {
            return;
        }
        Map<Trace, ListenerForTraceChanges> map = this.listenersByTrace;
        synchronized (map) {
            currentCoords = this.current;
            traces = this.tracesView.stream().filter(t -> {
                ProjectLocator loc = t.getDomainFile().getProjectLocator();
                return loc != null && !loc.isTransient();
            }).collect(Collectors.toList());
            coordsByTrace = Map.copyOf(this.lastCoordsByTrace);
        }
        saveState.putInt(KEY_TRACE_COUNT, traces.size());
        for (int index = 0; index < traces.size(); ++index) {
            Trace t2 = (Trace)traces.get(index);
            DebuggerCoordinates coords = coordsByTrace.get(t2);
            String stateName = PREFIX_OPEN_TRACE + index;
            coords.writeDataState(this.tool, saveState, stateName);
        }
        currentCoords.writeDataState(this.tool, saveState, KEY_CURRENT_COORDS);
    }

    public void readDataState(SaveState saveState) {
        int traceCount = saveState.getInt(KEY_TRACE_COUNT, 0);
        for (int index = 0; index < traceCount; ++index) {
            String stateName = PREFIX_OPEN_TRACE + index;
            DebuggerCoordinates coords = DebuggerCoordinates.readDataState(this.tool, saveState, stateName);
            if (coords.getTrace() == null) continue;
            this.lastCoordsByTrace.put(coords.getTrace(), coords);
        }
        this.activate(DebuggerCoordinates.readDataState(this.tool, saveState, KEY_CURRENT_COORDS));
    }

    private /* synthetic */ CompletableFuture lambda$tryHarder$1(Supplier action, int retries, long retryAfterMillis) {
        return this.tryHarder(action, retries - 1, retryAfterMillis);
    }

    class ForRecordersListener
    implements CollectionChangeListener<TraceRecorder> {
        ForRecordersListener() {
        }

        public void elementAdded(TraceRecorder recorder) {
            Swing.runLater(() -> DebuggerTraceManagerServicePlugin.this.updateCurrentRecorder());
        }

        public void elementRemoved(TraceRecorder recorder) {
            Swing.runLater(() -> {
                DebuggerTraceManagerServicePlugin.this.updateCurrentRecorder();
                if (!DebuggerTraceManagerServicePlugin.this.isAutoCloseOnTerminate()) {
                    return;
                }
                Trace trace = recorder.getTrace();
                Map<Trace, ListenerForTraceChanges> map = DebuggerTraceManagerServicePlugin.this.listenersByTrace;
                synchronized (map) {
                    if (!DebuggerTraceManagerServicePlugin.this.listenersByTrace.containsKey(trace)) {
                        return;
                    }
                }
                if (!DebuggerTraceManagerServicePlugin.this.isSaveTracesByDefault()) {
                    DebuggerTraceManagerServicePlugin.this.closeTrace(trace);
                    return;
                }
                DebuggerTraceManagerServicePlugin.this.tryHarder(() -> DebuggerTraceManagerServicePlugin.this.saveTrace(trace), 3, 100L).thenRun(() -> DebuggerTraceManagerServicePlugin.this.closeTrace(trace));
            });
        }
    }

    class ListenerForTraceChanges
    extends TraceDomainObjectListener {
        private final Trace trace;

        public ListenerForTraceChanges(Trace trace) {
            this.trace = trace;
            this.listenFor((TraceChangeType)Trace.TraceThreadChangeType.ADDED, this::threadAdded);
            this.listenFor((TraceChangeType)Trace.TraceThreadChangeType.DELETED, this::threadDeleted);
        }

        private void threadAdded(TraceThread thread) {
            TraceRecorder recorder = DebuggerTraceManagerServicePlugin.this.current.getRecorder();
            if (DebuggerTraceManagerServicePlugin.this.supportsFocus(recorder)) {
                if (thread == recorder.getTraceThreadForSuccessor(recorder.getFocus())) {
                    DebuggerTraceManagerServicePlugin.this.activate(DebuggerTraceManagerServicePlugin.this.current.thread(thread));
                }
                return;
            }
            if (DebuggerTraceManagerServicePlugin.this.current.getTrace() != this.trace) {
                return;
            }
            if (DebuggerTraceManagerServicePlugin.this.current.getThread() != null) {
                return;
            }
            DebuggerTraceManagerServicePlugin.this.activate(DebuggerTraceManagerServicePlugin.this.current.thread(thread));
        }

        private void threadDeleted(TraceThread thread) {
            DebuggerCoordinates last = DebuggerTraceManagerServicePlugin.this.lastCoordsByTrace.get(this.trace);
            if (last != null && last.getThread() == thread) {
                DebuggerTraceManagerServicePlugin.this.lastCoordsByTrace.remove(this.trace);
            }
            if (DebuggerTraceManagerServicePlugin.this.current.getThread() == thread) {
                DebuggerTraceManagerServicePlugin.this.activate(DebuggerTraceManagerServicePlugin.this.current.thread(null));
            }
        }
    }
}

