/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.emulation;

import com.google.common.collect.Range;
import docking.Tool;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.ToggleDockingAction;
import docking.action.builder.ToggleActionBuilder;
import ghidra.app.context.ProgramLocationActionContext;
import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.core.debug.event.TraceClosedPluginEvent;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.service.emulation.BytesDebuggerPcodeEmulatorFactory;
import ghidra.app.plugin.core.debug.service.emulation.DebuggerPcodeEmulatorFactory;
import ghidra.app.plugin.core.debug.service.emulation.DebuggerPcodeMachine;
import ghidra.app.plugin.core.debug.service.emulation.ProgramEmulationUtils;
import ghidra.app.services.DebuggerEmulationService;
import ghidra.app.services.DebuggerModelService;
import ghidra.app.services.DebuggerPlatformService;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.async.AsyncLazyMap;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.DefaultTraceLocation;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceLocation;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.model.time.TraceSnapshot;
import ghidra.trace.model.time.schedule.CompareResult;
import ghidra.trace.model.time.schedule.TraceSchedule;
import ghidra.util.Msg;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.database.UndoableTransaction;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang3.exception.ExceptionUtils;

@PluginInfo(shortDescription="Debugger Emulation Service Plugin", description="Manages and cache trace emulation states", category="Debugger", packageName="Debugger", status=PluginStatus.RELEASED, eventsConsumed={TraceClosedPluginEvent.class, ProgramActivatedPluginEvent.class, ProgramClosedPluginEvent.class}, servicesRequired={DebuggerTraceManagerService.class, DebuggerStaticMappingService.class}, servicesProvided={DebuggerEmulationService.class})
public class DebuggerEmulationServicePlugin
extends Plugin
implements DebuggerEmulationService {
    protected static final int MAX_CACHE_SIZE = 5;
    protected DebuggerPcodeEmulatorFactory emulatorFactory = new BytesDebuggerPcodeEmulatorFactory();
    protected final Set<CacheKey> eldest = new LinkedHashSet<CacheKey>();
    protected final NavigableMap<CacheKey, CachedEmulator> cache = new TreeMap<CacheKey, CachedEmulator>();
    protected final AsyncLazyMap<CacheKey, Long> requests = new AsyncLazyMap(new HashMap(), this::doBackgroundEmulate).forgetErrors((key, t) -> true).forgetValues((key, l) -> true);
    @AutoServiceConsumed
    private DebuggerTraceManagerService traceManager;
    @AutoServiceConsumed
    private DebuggerModelService modelService;
    @AutoServiceConsumed
    private DebuggerPlatformService platformService;
    @AutoServiceConsumed
    private DebuggerStaticMappingService staticMappings;
    private AutoService.Wiring autoServiceWiring;
    DockingAction actionEmulateProgram;
    DockingAction actionEmulateAddThread;
    Map<Class<? extends DebuggerPcodeEmulatorFactory>, ToggleDockingAction> actionsChooseEmulatorFactory = new HashMap<Class<? extends DebuggerPcodeEmulatorFactory>, ToggleDockingAction>();
    final ChangeListener classChangeListener = this::classesChanged;

    public DebuggerEmulationServicePlugin(PluginTool tool) {
        super(tool);
        this.autoServiceWiring = AutoService.wireServicesProvidedAndConsumed((Plugin)this);
    }

    protected void init() {
        super.init();
        this.createActions();
    }

    protected void createActions() {
        this.actionEmulateProgram = (DockingAction)DebuggerResources.EmulateProgramAction.builder(this).withContext(ProgramLocationActionContext.class).enabledWhen(this::emulateProgramEnabled).popupWhen(this::emulateProgramEnabled).onAction(this::emulateProgramActivated).buildAndInstall((Tool)this.tool);
        this.actionEmulateAddThread = (DockingAction)DebuggerResources.EmulateAddThreadAction.builder(this).withContext(ProgramLocationActionContext.class).enabledWhen(this::emulateAddThreadEnabled).popupWhen(this::emulateAddThreadEnabled).onAction(this::emulateAddThreadActivated).buildAndInstall((Tool)this.tool);
        ClassSearcher.addChangeListener((ChangeListener)this.classChangeListener);
        this.updateConfigureEmulatorStates();
    }

    private void classesChanged(ChangeEvent e) {
        this.updateConfigureEmulatorStates();
    }

    private ToggleDockingAction createActionChooseEmulator(DebuggerPcodeEmulatorFactory factory) {
        ToggleDockingAction action = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)DebuggerResources.ConfigureEmulatorAction.builder(this).menuPath(new String[]{"Debugger", "Configure Emulator", factory.getTitle()})).onAction(ctx -> this.configureEmulatorActivated(factory))).buildAndInstall((Tool)this.tool);
        String[] path = action.getMenuBarData().getMenuPath();
        this.tool.setMenuGroup(Arrays.copyOf(path, path.length - 1), "zz");
        return action;
    }

    private void updateConfigureEmulatorStates() {
        Map<Class, DebuggerPcodeEmulatorFactory> byClass = this.getEmulatorFactories().stream().collect(Collectors.toMap(Object::getClass, Objects::requireNonNull));
        for (Map.Entry<Class<? extends DebuggerPcodeEmulatorFactory>, ToggleDockingAction> ent : this.actionsChooseEmulatorFactory.entrySet()) {
            if (byClass.keySet().contains(ent.getKey())) continue;
            this.tool.removeAction((DockingActionIf)ent.getValue());
        }
        for (Map.Entry<Class, DebuggerPcodeEmulatorFactory> ent : byClass.entrySet()) {
            if (this.actionsChooseEmulatorFactory.containsKey(ent.getKey())) continue;
            ToggleDockingAction action = this.createActionChooseEmulator(ent.getValue());
            action.setSelected(ent.getKey() == this.emulatorFactory.getClass());
            this.actionsChooseEmulatorFactory.put(ent.getKey(), action);
        }
    }

    private boolean emulateProgramEnabled(ProgramLocationActionContext ctx) {
        Program program = ctx.getProgram();
        return program != null && !(program instanceof TraceProgramView);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emulateProgramActivated(ProgramLocationActionContext ctx) {
        Program program = ctx.getProgram();
        if (program == null) {
            return;
        }
        Trace trace = null;
        try {
            trace = ProgramEmulationUtils.launchEmulationTrace(program, ctx.getAddress(), this);
            this.traceManager.openTrace(trace);
            this.traceManager.activateTrace(trace);
        }
        catch (IOException e) {
            Msg.showError((Object)this, null, (String)this.actionEmulateProgram.getDescription(), (Object)"Could not create trace for emulation", (Throwable)e);
        }
        finally {
            if (trace != null) {
                trace.release((Object)this);
            }
        }
    }

    private boolean emulateAddThreadEnabled(ProgramLocationActionContext ctx) {
        Program programOrView = ctx.getProgram();
        if (programOrView instanceof TraceProgramView) {
            TraceProgramView view = (TraceProgramView)programOrView;
            return ProgramEmulationUtils.isEmulatedProgram(view.getTrace());
        }
        DebuggerCoordinates current = this.traceManager.getCurrent();
        if (current.getTrace() == null || !ProgramEmulationUtils.isEmulatedProgram(current.getTrace())) {
            return false;
        }
        TraceLocation traceLoc = this.staticMappings.getOpenMappedLocation(current.getTrace(), ctx.getLocation(), current.getSnap());
        return traceLoc != null;
    }

    private void emulateAddThreadActivated(ProgramLocationActionContext ctx) {
        Program programOrView = ctx.getProgram();
        if (programOrView instanceof TraceProgramView) {
            TraceProgramView view = (TraceProgramView)programOrView;
            Trace trace = view.getTrace();
            Address tracePc = ctx.getAddress();
            ProgramLocation progLoc = this.staticMappings.getOpenMappedLocation((TraceLocation)new DefaultTraceLocation(view.getTrace(), null, Range.singleton((Comparable)Long.valueOf(view.getSnap())), tracePc));
            Program program = progLoc == null ? null : progLoc.getProgram();
            Address programPc = progLoc == null ? null : progLoc.getAddress();
            long snap = view.getViewport().getOrderedSnaps().stream().filter(s -> s >= 0L).findFirst().get();
            TraceThread thread = ProgramEmulationUtils.launchEmulationThread(trace, snap, program, tracePc, programPc);
            this.traceManager.activateThread(thread);
        } else {
            Program program = programOrView;
            Address programPc = ctx.getAddress();
            DebuggerCoordinates current = this.traceManager.getCurrent();
            long snap = current.getSnap();
            Trace trace = current.getTrace();
            TraceLocation traceLoc = this.staticMappings.getOpenMappedLocation(trace, ctx.getLocation(), snap);
            if (traceLoc == null) {
                return;
            }
            Address tracePc = traceLoc.getAddress();
            TraceThread thread = ProgramEmulationUtils.launchEmulationThread(trace, snap, program, tracePc, programPc);
            this.traceManager.activateThread(thread);
        }
    }

    private void configureEmulatorActivated(DebuggerPcodeEmulatorFactory factory) {
        this.setEmulatorFactory(factory);
    }

    @Override
    public Collection<DebuggerPcodeEmulatorFactory> getEmulatorFactories() {
        return ClassSearcher.getInstances(DebuggerPcodeEmulatorFactory.class);
    }

    @Override
    public synchronized void setEmulatorFactory(DebuggerPcodeEmulatorFactory factory) {
        this.emulatorFactory = Objects.requireNonNull(factory);
        for (ToggleDockingAction toggle : this.actionsChooseEmulatorFactory.values()) {
            toggle.setSelected(false);
        }
        ToggleDockingAction chosen = this.actionsChooseEmulatorFactory.get(factory.getClass());
        if (chosen == null) {
            Msg.warn((Object)this, (Object)("An undiscovered emulator factory was set via the API: " + factory));
        }
        chosen.setSelected(true);
    }

    @Override
    public synchronized DebuggerPcodeEmulatorFactory getEmulatorFactory() {
        return this.emulatorFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map.Entry<CacheKey, CachedEmulator> findNearestPrefix(CacheKey key) {
        NavigableMap<CacheKey, CachedEmulator> navigableMap = this.cache;
        synchronized (navigableMap) {
            Map.Entry<CacheKey, CachedEmulator> candidate = this.cache.floorEntry(key);
            if (candidate == null) {
                return null;
            }
            if (!candidate.getKey().compareKey((CacheKey)key).related) {
                return null;
            }
            return candidate;
        }
    }

    protected CompletableFuture<Long> doBackgroundEmulate(CacheKey key) {
        EmulateTask task = new EmulateTask(key);
        this.tool.execute((Task)task, 500);
        return task.future;
    }

    @Override
    public CompletableFuture<Long> backgroundEmulate(TracePlatform platform, TraceSchedule time) {
        Trace trace = platform.getTrace();
        if (!this.traceManager.getOpenTraces().contains(trace)) {
            throw new IllegalArgumentException("Cannot emulate a trace unless it's opened in the tool.");
        }
        if (time.isSnapOnly()) {
            return CompletableFuture.completedFuture(time.getSnap());
        }
        return this.requests.get((Object)new CacheKey(platform, time));
    }

    protected TraceSnapshot findScratch(Trace trace, TraceSchedule time) {
        Collection exist = trace.getTimeManager().getSnapshotsWithSchedule(time);
        if (!exist.isEmpty()) {
            return (TraceSnapshot)exist.iterator().next();
        }
        TraceSnapshot last = trace.getTimeManager().getMostRecentSnapshot(-1L);
        long snap = last == null ? Long.MIN_VALUE : last.getKey() + 1L;
        TraceSnapshot snapshot = trace.getTimeManager().getSnapshot(snap, true);
        snapshot.setDescription("Emulated");
        snapshot.setSchedule(time);
        return snapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long doEmulate(CacheKey key, TaskMonitor monitor) throws CancelledException {
        TraceSnapshot destSnap;
        DebuggerPcodeMachine<?> emu;
        CachedEmulator ce;
        NavigableMap<CacheKey, CachedEmulator> navigableMap;
        Trace trace = key.trace;
        TracePlatform platform = key.platform;
        TraceSchedule time = key.time;
        Map.Entry<CacheKey, CachedEmulator> ancestor = this.findNearestPrefix(key);
        if (ancestor != null) {
            CacheKey prevKey = ancestor.getKey();
            navigableMap = this.cache;
            synchronized (navigableMap) {
                this.cache.remove(prevKey);
                this.eldest.remove(prevKey);
            }
            ce = ancestor.getValue();
            emu = ce.emulator;
            monitor.initialize(time.totalTickCount() - prevKey.time.totalTickCount());
            this.createRegisterSpaces(trace, time, monitor);
            monitor.setMessage("Emulating");
            time.finish(trace, prevKey.time, emu, monitor);
        } else {
            emu = this.emulatorFactory.create(this.tool, platform, time.getSnap(), this.modelService == null ? null : this.modelService.getRecorder(trace));
            ce = new CachedEmulator(emu);
            monitor.initialize(time.totalTickCount());
            this.createRegisterSpaces(trace, time, monitor);
            monitor.setMessage("Emulating");
            time.execute(trace, emu, monitor);
        }
        try (UndoableTransaction tid = UndoableTransaction.start((UndoableDomainObject)trace, (String)"Emulate");){
            destSnap = this.findScratch(trace, time);
            emu.writeDown(platform, destSnap.getKey(), time.getSnap());
        }
        navigableMap = this.cache;
        synchronized (navigableMap) {
            this.cache.put(key, ce);
            this.eldest.add(key);
            assert (this.cache.size() == this.eldest.size());
            while (this.cache.size() > 5) {
                CacheKey expired = this.eldest.iterator().next();
                this.eldest.remove(expired);
                this.cache.remove(expired);
            }
        }
        return destSnap.getKey();
    }

    protected void createRegisterSpaces(Trace trace, TraceSchedule time, TaskMonitor monitor) {
        if (trace.getObjectManager().getRootObject() == null) {
            return;
        }
        monitor.setMessage("Creating register spaces");
        try (UndoableTransaction tid = UndoableTransaction.start((UndoableDomainObject)trace, (String)"Prepare emulation");){
            for (TraceThread thread : time.getThreads(trace)) {
                trace.getMemoryManager().getMemoryRegisterSpace(thread, 0, true);
            }
        }
    }

    @Override
    public long emulate(TracePlatform platform, TraceSchedule time, TaskMonitor monitor) throws CancelledException {
        Trace trace = platform.getTrace();
        if (!this.traceManager.getOpenTraces().contains(trace)) {
            throw new IllegalArgumentException("Cannot emulate a trace unless it's opened in the tool.");
        }
        if (time.isSnapOnly()) {
            return time.getSnap();
        }
        return this.doEmulate(new CacheKey(platform, time), monitor);
    }

    @Override
    public DebuggerPcodeMachine<?> getCachedEmulator(Trace trace, TraceSchedule time) {
        CachedEmulator ce = (CachedEmulator)this.cache.get(new CacheKey(trace.getPlatformManager().getHostPlatform(), time));
        return ce == null ? null : ce.emulator;
    }

    @AutoServiceConsumed
    private void setTraceManager(DebuggerTraceManagerService traceManager) {
        this.cache.clear();
    }

    @AutoServiceConsumed
    private void setModelService(DebuggerModelService modelService) {
        this.cache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvent(PluginEvent event) {
        super.processEvent(event);
        if (event instanceof TraceClosedPluginEvent) {
            TraceClosedPluginEvent evt = (TraceClosedPluginEvent)event;
            NavigableMap<CacheKey, CachedEmulator> navigableMap = this.cache;
            synchronized (navigableMap) {
                List toRemove = this.eldest.stream().filter(k -> k.trace == evt.getTrace()).collect(Collectors.toList());
                this.cache.keySet().removeAll(toRemove);
                this.eldest.removeAll(toRemove);
                assert (this.cache.size() == this.eldest.size());
            }
        }
    }

    protected static class CacheKey
    implements Comparable<CacheKey> {
        protected final Trace trace;
        protected final TracePlatform platform;
        protected final TraceSchedule time;
        private final int hashCode;

        public CacheKey(TracePlatform platform, TraceSchedule time) {
            this.platform = Objects.requireNonNull(platform);
            this.trace = platform.getTrace();
            this.time = Objects.requireNonNull(time);
            this.hashCode = Objects.hash(this.trace, time);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            CacheKey that = (CacheKey)obj;
            if (this.trace != that.trace) {
                return false;
            }
            return Objects.equals(this.time, that.time);
        }

        @Override
        public int compareTo(CacheKey that) {
            return this.compareKey((CacheKey)that).compareTo;
        }

        public CompareResult compareKey(CacheKey that) {
            CompareResult result = CompareResult.unrelated((int)Integer.compare(System.identityHashCode(this.trace), System.identityHashCode(that.trace)));
            if (result != CompareResult.EQUALS) {
                return result;
            }
            result = this.time.compareSchedule(that.time);
            if (result != CompareResult.EQUALS) {
                return result;
            }
            return CompareResult.EQUALS;
        }
    }

    protected class EmulateTask
    extends Task {
        protected final CacheKey key;
        protected final CompletableFuture<Long> future;

        public EmulateTask(CacheKey key) {
            super("Emulate " + key.time + " in " + key.trace, true, true, false, false);
            this.future = new CompletableFuture();
            this.key = key;
        }

        public void run(TaskMonitor monitor) throws CancelledException {
            try {
                this.future.complete(DebuggerEmulationServicePlugin.this.doEmulate(this.key, monitor));
            }
            catch (CancelledException e) {
                this.future.completeExceptionally(e);
                throw e;
            }
            catch (Throwable e) {
                this.future.completeExceptionally(e);
                ExceptionUtils.rethrow((Throwable)e);
            }
        }
    }

    protected static class CachedEmulator {
        final DebuggerPcodeMachine<?> emulator;

        public CachedEmulator(DebuggerPcodeMachine<?> emulator) {
            this.emulator = emulator;
        }
    }
}

