/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.thread;

import com.google.common.collect.Range;
import docking.widgets.table.DefaultEnumeratedColumnTableModel;
import ghidra.app.plugin.core.debug.gui.thread.ThreadRow;
import ghidra.app.plugin.core.debug.gui.thread.ThreadState;
import java.util.function.BiConsumer;
import java.util.function.Function;

public enum ThreadTableColumns implements DefaultEnumeratedColumnTableModel.EnumeratedTableColumn<ThreadTableColumns, ThreadRow>
{
    NAME("Name", String.class, ThreadRow::getName, ThreadRow::setName, true),
    CREATED("Created", Long.class, ThreadRow::getCreationSnap, true),
    DESTROYED("Destroyed", String.class, ThreadRow::getDestructionSnap, true),
    STATE("State", ThreadState.class, ThreadRow::getState, true),
    COMMENT("Comment", String.class, ThreadRow::getComment, ThreadRow::setComment, true),
    PLOT("Plot", Range.class, ThreadRow::getLifespan, false);

    private final String header;
    private final Function<ThreadRow, ?> getter;
    private final BiConsumer<ThreadRow, Object> setter;
    private final boolean sortable;
    private final Class<?> cls;

    private <T> ThreadTableColumns(String header, Class<T> cls, Function<ThreadRow, T> getter, boolean sortable) {
        this(header, cls, getter, null, sortable);
    }

    private <T> ThreadTableColumns(String header, Class<T> cls, Function<ThreadRow, T> getter, BiConsumer<ThreadRow, T> setter, boolean sortable) {
        this.header = header;
        this.cls = cls;
        this.getter = getter;
        this.setter = setter;
        this.sortable = sortable;
    }

    public String getHeader() {
        return this.header;
    }

    public Class<?> getValueClass() {
        return this.cls;
    }

    public Object getValueOf(ThreadRow row) {
        return this.getter.apply(row);
    }

    public boolean isEditable(ThreadRow row) {
        return this.setter != null;
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public void setValueOf(ThreadRow row, Object value) {
        this.setter.accept(row, value);
    }
}

