/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.objects.actions;

import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.widgets.filechooser.GhidraFileChooserMode;
import ghidra.app.plugin.core.debug.gui.objects.DebuggerObjectsProvider;
import ghidra.app.plugin.core.debug.gui.objects.ObjectContainer;
import ghidra.app.plugin.core.debug.gui.objects.actions.ImportExportAsAction;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.HelpLocation;
import ghidra.util.xml.XmlUtilities;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.commons.lang3.StringUtils;
import org.jdom.Document;
import org.jdom.Element;
import resources.ResourceManager;

public class ExportAsXMLAction
extends ImportExportAsAction {
    protected ImageIcon ICON_XML = ResourceManager.loadImage((String)"images/text-xml.png");

    public ExportAsXMLAction(PluginTool tool, String owner, DebuggerObjectsProvider provider) {
        super("ExportAsXML", tool, owner, provider);
        this.fileExt = ".xml";
        this.fileMode = GhidraFileChooserMode.FILES_ONLY;
        String[] path = new String[]{"Export as...", "XML"};
        this.setPopupMenuData(new MenuData(path, (Icon)this.ICON_XML));
        this.setKeyBindingData(new KeyBindingData(69, 64));
        this.setHelpLocation(new HelpLocation(owner, "export_as_xml"));
        provider.addLocalAction((DockingActionIf)this);
    }

    @Override
    protected void doAction(ObjectContainer container, File f) {
        this.writeXml(container, f);
    }

    public void writeXml(ObjectContainer container, File f) {
        if (container == null) {
            return;
        }
        Element root = container.toXml();
        String joinedPath = StringUtils.join((Iterable)container.getTargetObject().getPath(), (String)".");
        XmlUtilities.setStringAttr((Element)root, (String)"Path", (String)joinedPath);
        Document doc = new Document(root);
        try {
            XmlUtilities.writePrettyDocToFile((Document)doc, (File)f);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

