/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.memory;

import com.google.common.collect.Range;
import docking.ActionContext;
import docking.ComponentProvider;
import docking.WindowPosition;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.action.ToggleDockingAction;
import docking.action.ToolBarData;
import docking.action.builder.ActionBuilder;
import docking.action.builder.ToggleActionBuilder;
import docking.widgets.table.CustomToStringCellRenderer;
import docking.widgets.table.DefaultEnumeratedColumnTableModel;
import docking.widgets.table.GTable;
import docking.widgets.table.RowObjectTableModel;
import ghidra.app.plugin.core.debug.gui.DebuggerBlockChooserDialog;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.memory.DebuggerRegionActionContext;
import ghidra.app.plugin.core.debug.gui.memory.DebuggerRegionMapProposalDialog;
import ghidra.app.plugin.core.debug.gui.memory.DebuggerRegionsPlugin;
import ghidra.app.plugin.core.debug.gui.memory.RegionRow;
import ghidra.app.plugin.core.debug.gui.modules.DebuggerModulesProvider;
import ghidra.app.plugin.core.debug.service.modules.MapRegionsBackgroundCommand;
import ghidra.app.plugin.core.debug.utils.DebouncedRowWrappedEnumeratedColumnTableModel;
import ghidra.app.services.DebuggerListingService;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.app.services.MapProposal;
import ghidra.app.services.ProgramManager;
import ghidra.app.services.RegionMapProposal;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceDomainObjectListener;
import ghidra.trace.model.TraceUniqueObject;
import ghidra.trace.model.memory.TraceMemoryManager;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.util.TraceChangeType;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.database.ObjectKey;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableFilterPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class DebuggerRegionsProvider
extends ComponentProviderAdapter {
    private final DebuggerRegionsPlugin plugin;
    @AutoServiceConsumed
    private DebuggerStaticMappingService staticMappingService;
    @AutoServiceConsumed
    private DebuggerTraceManagerService traceManager;
    @AutoServiceConsumed
    private DebuggerListingService listingService;
    @AutoServiceConsumed
    ProgramManager programManager;
    private final AutoService.Wiring autoServiceWiring;
    private Trace currentTrace;
    private final RegionsListener regionsListener = new RegionsListener();
    protected final RegionTableModel regionTableModel;
    protected GhidraTable regionTable;
    private GhidraTableFilterPanel<RegionRow> regionFilterPanel;
    private final JPanel mainPanel = new JPanel(new BorderLayout());
    private final DebuggerBlockChooserDialog blockChooserDialog;
    private final DebuggerRegionMapProposalDialog regionProposalDialog;
    private DebuggerRegionActionContext myActionContext;
    private Program currentProgram;
    private ProgramLocation currentLocation;
    DockingAction actionMapRegions;
    DockingAction actionMapRegionTo;
    DockingAction actionMapRegionsTo;
    SelectAddressesAction actionSelectAddresses;
    DockingAction actionSelectRows;
    ToggleDockingAction actionForceFullView;

    protected static RegionRow getSelectedRegionRow(ActionContext context) {
        if (!(context instanceof DebuggerRegionActionContext)) {
            return null;
        }
        DebuggerRegionActionContext ctx = (DebuggerRegionActionContext)context;
        Set<RegionRow> regions = ctx.getSelectedRegions();
        if (regions.size() != 1) {
            return null;
        }
        return regions.iterator().next();
    }

    protected static Set<TraceMemoryRegion> getSelectedRegions(ActionContext context) {
        if (!(context instanceof DebuggerRegionActionContext)) {
            return null;
        }
        DebuggerRegionActionContext ctx = (DebuggerRegionActionContext)context;
        return ctx.getSelectedRegions().stream().map(r -> r.getRegion()).collect(Collectors.toSet());
    }

    public DebuggerRegionsProvider(DebuggerRegionsPlugin plugin) {
        super(plugin.getTool(), "Regions", plugin.getName(), DebuggerRegionActionContext.class);
        this.plugin = plugin;
        this.regionTableModel = new RegionTableModel(this.tool);
        this.setIcon(DebuggerResources.ICON_PROVIDER_REGIONS);
        this.setHelpLocation(DebuggerResources.HELP_PROVIDER_REGIONS);
        this.setWindowMenuGroup("Debugger");
        this.buildMainPanel();
        this.autoServiceWiring = AutoService.wireServicesConsumed((Plugin)plugin, (Object)((Object)this));
        this.blockChooserDialog = new DebuggerBlockChooserDialog(this.tool);
        this.regionProposalDialog = new DebuggerRegionMapProposalDialog(this);
        this.setDefaultWindowPosition(WindowPosition.BOTTOM);
        this.setVisible(true);
        this.createActions();
    }

    public ActionContext getActionContext(MouseEvent event) {
        if (this.myActionContext == null) {
            return super.getActionContext(event);
        }
        return this.myActionContext;
    }

    private void loadRegions() {
        this.regionTableModel.clear();
        if (this.currentTrace == null) {
            return;
        }
        TraceMemoryManager memoryManager = this.currentTrace.getMemoryManager();
        this.regionTableModel.addAllItems(memoryManager.getAllRegions());
    }

    protected void buildMainPanel() {
        this.regionTable = new GhidraTable((TableModel)((Object)this.regionTableModel));
        this.regionTable.setSelectionMode(2);
        this.mainPanel.add(new JScrollPane((Component)this.regionTable));
        this.regionFilterPanel = new GhidraTableFilterPanel((JTable)this.regionTable, (RowObjectTableModel)this.regionTableModel);
        this.mainPanel.add((Component)this.regionFilterPanel, "South");
        this.regionTable.getSelectionModel().addListSelectionListener(evt -> {
            this.myActionContext = new DebuggerRegionActionContext(this, this.regionFilterPanel.getSelectedItems(), (GTable)this.regionTable);
            this.contextChanged();
        });
        this.regionTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DebuggerRegionsProvider.this.navigateToSelectedRegion();
                }
            }
        });
        this.regionTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    DebuggerRegionsProvider.this.navigateToSelectedRegion();
                }
            }
        });
        TableColumnModel columnModel = this.regionTable.getColumnModel();
        TableColumn startCol = columnModel.getColumn(RegionTableColumns.START.ordinal());
        startCol.setCellRenderer((TableCellRenderer)CustomToStringCellRenderer.MONO_OBJECT);
        TableColumn endCol = columnModel.getColumn(RegionTableColumns.END.ordinal());
        endCol.setCellRenderer((TableCellRenderer)CustomToStringCellRenderer.MONO_OBJECT);
        TableColumn lenCol = columnModel.getColumn(RegionTableColumns.LENGTH.ordinal());
        lenCol.setCellRenderer((TableCellRenderer)CustomToStringCellRenderer.MONO_ULONG_HEX);
        int small = 100;
        TableColumn rCol = columnModel.getColumn(RegionTableColumns.READ.ordinal());
        rCol.setPreferredWidth(100);
        TableColumn wCol = columnModel.getColumn(RegionTableColumns.WRITE.ordinal());
        wCol.setPreferredWidth(100);
        TableColumn eCol = columnModel.getColumn(RegionTableColumns.EXECUTE.ordinal());
        eCol.setPreferredWidth(100);
        TableColumn vCol = columnModel.getColumn(RegionTableColumns.VOLATILE.ordinal());
        vCol.setPreferredWidth(100);
    }

    protected void navigateToSelectedRegion() {
        int selectedColumn;
        int selectedRow;
        Object value;
        if (this.listingService != null && (value = this.regionTable.getValueAt(selectedRow = this.regionTable.getSelectedRow(), selectedColumn = this.regionTable.getSelectedColumn())) instanceof Address) {
            this.listingService.goTo((Address)value, true);
        }
    }

    protected void createActions() {
        this.actionMapRegions = (DockingAction)MapRegionsAction.builder(this.plugin).withContext(DebuggerRegionActionContext.class).enabledWhen(this::isContextNonEmpty).popupWhen(this::isContextNonEmpty).onAction(this::activatedMapRegions).buildAndInstallLocal((ComponentProvider)this);
        this.actionMapRegionTo = (DockingAction)MapRegionToAction.builder(this.plugin).withContext(DebuggerRegionActionContext.class).enabledWhen(ctx -> this.currentProgram != null && ctx.getSelectedRegions().size() == 1).popupWhen(ctx -> this.currentProgram != null && ctx.getSelectedRegions().size() == 1).onAction(this::activatedMapRegionTo).buildAndInstallLocal((ComponentProvider)this);
        this.actionMapRegionsTo = (DockingAction)MapRegionsToAction.builder(this.plugin).withContext(DebuggerRegionActionContext.class).enabledWhen(ctx -> this.currentProgram != null && this.isContextNonEmpty((DebuggerRegionActionContext)((Object)ctx))).popupWhen(ctx -> this.currentProgram != null && this.isContextNonEmpty((DebuggerRegionActionContext)((Object)ctx))).onAction(this::activatedMapRegionsTo).buildAndInstallLocal((ComponentProvider)this);
        this.actionSelectAddresses = new SelectAddressesAction();
        this.actionSelectRows = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)DebuggerResources.SelectRowsAction.builder(this.plugin).description("Select regions by dynamic selection")).enabledWhen(ctx -> this.currentTrace != null)).onAction(this::activatedSelectCurrent)).buildAndInstallLocal((ComponentProvider)this);
        this.actionForceFullView = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)DebuggerResources.ForceFullViewAction.builder(this.plugin).enabledWhen(ctx -> this.currentTrace != null)).onAction(this::activatedForceFullView)).buildAndInstallLocal((ComponentProvider)this);
        this.contextChanged();
    }

    private boolean isContextNonEmpty(DebuggerRegionActionContext ctx) {
        return !ctx.getSelectedRegions().isEmpty();
    }

    private static Set<TraceMemoryRegion> getSelectedRegions(DebuggerRegionActionContext ctx) {
        if (ctx == null) {
            return null;
        }
        return ctx.getSelectedRegions().stream().map(r -> r.getRegion()).collect(Collectors.toSet());
    }

    private void activatedMapRegions(DebuggerRegionActionContext ignored) {
        this.mapRegions(DebuggerRegionsProvider.getSelectedRegions(this.myActionContext));
    }

    private void activatedMapRegionsTo(DebuggerRegionActionContext ignored) {
        Set<TraceMemoryRegion> sel = DebuggerRegionsProvider.getSelectedRegions(this.myActionContext);
        if (sel == null || sel.isEmpty()) {
            return;
        }
        this.mapRegionsTo(sel);
    }

    private void activatedMapRegionTo(DebuggerRegionActionContext ignored) {
        Set<TraceMemoryRegion> sel = DebuggerRegionsProvider.getSelectedRegions(this.myActionContext);
        if (sel == null || sel.size() != 1) {
            return;
        }
        this.mapRegionTo(sel.iterator().next());
    }

    protected void promptRegionProposal(Collection<RegionMapProposal.RegionMapEntry> proposal) {
        if (proposal.isEmpty()) {
            Msg.showInfo((Object)((Object)this), (Component)this.getComponent(), (String)"Map Regions", (Object)"Could not formulate a propsal for any selection region. You may need to import and/or open the destination images first.");
            return;
        }
        Collection<RegionMapProposal.RegionMapEntry> adjusted = this.regionProposalDialog.adjustCollection(this.getTool(), proposal);
        if (adjusted == null || this.staticMappingService == null) {
            return;
        }
        this.tool.executeBackgroundCommand((BackgroundCommand)new MapRegionsBackgroundCommand(this.staticMappingService, adjusted), (UndoableDomainObject)this.currentTrace);
    }

    protected void mapRegions(Set<TraceMemoryRegion> regions) {
        if (this.staticMappingService == null) {
            return;
        }
        Map<Collection<TraceMemoryRegion>, RegionMapProposal> map = this.staticMappingService.proposeRegionMaps(regions, List.of(this.programManager.getAllOpenPrograms()));
        Collection<RegionMapProposal.RegionMapEntry> proposal = MapProposal.flatten(map.values());
        this.promptRegionProposal(proposal);
    }

    protected void mapRegionsTo(Set<TraceMemoryRegion> regions) {
        if (this.staticMappingService == null) {
            return;
        }
        Program program = this.currentProgram;
        if (program == null) {
            return;
        }
        RegionMapProposal map = this.staticMappingService.proposeRegionMap(regions, program);
        Collection<RegionMapProposal.RegionMapEntry> proposal = map.computeMap().values();
        this.promptRegionProposal(proposal);
    }

    protected void mapRegionTo(TraceMemoryRegion region) {
        if (this.staticMappingService == null) {
            return;
        }
        ProgramLocation location = this.currentLocation;
        MemoryBlock block = DebuggerRegionsProvider.computeBlock(location);
        if (block == null) {
            return;
        }
        RegionMapProposal map = this.staticMappingService.proposeRegionMap(region, location.getProgram(), block);
        this.promptRegionProposal(map.computeMap().values());
    }

    private void activatedSelectCurrent(ActionContext ignored) {
        TraceMemoryRegion reg;
        if (this.listingService == null || this.traceManager == null || this.currentTrace == null) {
            return;
        }
        ProgramSelection progSel = this.listingService.getCurrentSelection();
        TraceMemoryManager memoryManager = this.currentTrace.getMemoryManager();
        if (progSel != null && !progSel.isEmpty()) {
            HashSet<TraceMemoryRegion> regSel = new HashSet<TraceMemoryRegion>();
            for (AddressRange range : progSel) {
                regSel.addAll(memoryManager.getRegionsIntersecting(Range.singleton((Comparable)Long.valueOf(this.traceManager.getCurrentSnap())), range));
            }
            this.setSelectedRegions(regSel);
            return;
        }
        ProgramLocation progLoc = this.listingService.getCurrentLocation();
        if (progLoc != null && (reg = memoryManager.getRegionContaining(this.traceManager.getCurrentSnap(), progLoc.getAddress())) != null) {
            this.setSelectedRegions(Set.of(reg));
            return;
        }
    }

    private void activatedForceFullView(ActionContext ignored) {
        if (this.currentTrace == null) {
            return;
        }
        this.currentTrace.getProgramView().getMemory().setForceFullView(this.actionForceFullView.isSelected());
    }

    public void setSelectedRegions(Set<TraceMemoryRegion> sel) {
        DebuggerResources.setSelectedRows(sel, arg_0 -> ((RegionTableModel)this.regionTableModel).getRow(arg_0), (GTable)this.regionTable, this.regionTableModel, this.regionFilterPanel);
    }

    public Collection<RegionRow> getSelectedRows() {
        return this.regionFilterPanel.getSelectedItems();
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    public void setProgram(Program program) {
        this.currentProgram = program;
        String name = program == null ? "..." : program.getName();
        this.actionMapRegionTo.getPopupMenuData().setMenuItemName("Map Region to " + name);
        this.actionMapRegionsTo.getPopupMenuData().setMenuItemName("Map Regions to " + name);
    }

    public static MemoryBlock computeBlock(ProgramLocation location) {
        return DebuggerModulesProvider.computeBlock(location);
    }

    public static String computeBlockName(ProgramLocation location) {
        return DebuggerModulesProvider.computeBlockName(location);
    }

    public void setLocation(ProgramLocation location) {
        this.currentLocation = location;
        String name = "Map Region to " + DebuggerRegionsProvider.computeBlockName(location);
        this.actionMapRegionTo.getPopupMenuData().setMenuItemName(name);
    }

    public void programClosed(Program program) {
        if (this.currentProgram == program) {
            this.currentProgram = null;
        }
    }

    public void setTrace(Trace trace) {
        if (this.currentTrace == trace) {
            return;
        }
        this.removeOldListeners();
        this.currentTrace = trace;
        this.addNewListeners();
        this.loadRegions();
        this.contextChanged();
    }

    public void contextChanged() {
        super.contextChanged();
        if (this.currentTrace != null) {
            this.actionForceFullView.setSelected(this.currentTrace.getProgramView().getMemory().isForceFullView());
        }
    }

    private void removeOldListeners() {
        if (this.currentTrace == null) {
            return;
        }
        this.currentTrace.removeListener((DomainObjectListener)this.regionsListener);
    }

    private void addNewListeners() {
        if (this.currentTrace == null) {
            return;
        }
        this.currentTrace.addListener((DomainObjectListener)this.regionsListener);
    }

    public Map.Entry<Program, MemoryBlock> askBlock(TraceMemoryRegion region, Program program, MemoryBlock block) {
        if (this.programManager == null) {
            Msg.warn((Object)((Object)this), (Object)"No program manager!");
            return null;
        }
        return this.blockChooserDialog.chooseBlock(this.getTool(), region, List.of(this.programManager.getAllOpenPrograms()));
    }

    private class RegionsListener
    extends TraceDomainObjectListener {
        public RegionsListener() {
            this.listenForUntyped(4, e -> this.objectRestored());
            this.listenFor((TraceChangeType)Trace.TraceMemoryRegionChangeType.ADDED, this::regionAdded);
            this.listenFor((TraceChangeType)Trace.TraceMemoryRegionChangeType.CHANGED, this::regionChanged);
            this.listenFor((TraceChangeType)Trace.TraceMemoryRegionChangeType.LIFESPAN_CHANGED, this::regionChanged);
            this.listenFor((TraceChangeType)Trace.TraceMemoryRegionChangeType.DELETED, this::regionDeleted);
        }

        private void objectRestored() {
            DebuggerRegionsProvider.this.loadRegions();
        }

        private void regionAdded(TraceMemoryRegion region) {
            DebuggerRegionsProvider.this.regionTableModel.addItem(region);
        }

        private void regionChanged(TraceMemoryRegion region) {
            DebuggerRegionsProvider.this.regionTableModel.updateItem(region);
        }

        private void regionDeleted(TraceMemoryRegion region) {
            DebuggerRegionsProvider.this.regionTableModel.deleteItem(region);
        }
    }

    protected static class RegionTableModel
    extends DebouncedRowWrappedEnumeratedColumnTableModel<RegionTableColumns, ObjectKey, RegionRow, TraceMemoryRegion> {
        public RegionTableModel(PluginTool tool) {
            super(tool, "Regions", RegionTableColumns.class, TraceUniqueObject::getObjectKey, RegionRow::new);
        }
    }

    protected static enum RegionTableColumns implements DefaultEnumeratedColumnTableModel.EnumeratedTableColumn<RegionTableColumns, RegionRow>
    {
        NAME("Name", String.class, RegionRow::getName, RegionRow::setName),
        LIFESPAN("Lifespan", Range.class, RegionRow::getLifespan),
        START("Start", Address.class, RegionRow::getMinAddress),
        END("End", Address.class, RegionRow::getMaxAddress),
        LENGTH("Length", Long.class, RegionRow::getLength),
        READ("Read", Boolean.class, RegionRow::isRead, RegionRow::setRead),
        WRITE("Write", Boolean.class, RegionRow::isWrite, RegionRow::setWrite),
        EXECUTE("Execute", Boolean.class, RegionRow::isExecute, RegionRow::setExecute),
        VOLATILE("Volatile", Boolean.class, RegionRow::isVolatile, RegionRow::setVolatile);

        private final String header;
        private final Function<RegionRow, ?> getter;
        private final BiConsumer<RegionRow, Object> setter;
        private final Class<?> cls;

        private <T> RegionTableColumns(String header, Class<T> cls, Function<RegionRow, T> getter, BiConsumer<RegionRow, T> setter) {
            this.header = header;
            this.cls = cls;
            this.getter = getter;
            this.setter = setter;
        }

        private <T> RegionTableColumns(String header, Class<T> cls, Function<RegionRow, T> getter) {
            this(header, cls, getter, null);
        }

        public String getHeader() {
            return this.header;
        }

        public Class<?> getValueClass() {
            return this.cls;
        }

        public boolean isEditable(RegionRow row) {
            return this.setter != null;
        }

        public void setValueOf(RegionRow row, Object value) {
            this.setter.accept(row, value);
        }

        public Object getValueOf(RegionRow row) {
            return this.getter.apply(row);
        }
    }

    static interface MapRegionsAction {
        public static final String NAME = "Map Regions";
        public static final String DESCRIPTION = "Map selected regions to program memory blocks";
        public static final String GROUP = "Dbg9. Map Modules/Sections";
        public static final String HELP_ANCHOR = "map_regions";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).popupMenuPath(new String[]{NAME})).popupMenuGroup(GROUP)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    static interface MapRegionToAction {
        public static final String NAME_PREFIX = "Map Region to ";
        public static final String DESCRIPTION = "Map the selected region to the current program";
        public static final String GROUP = "Dbg9. Map Modules/Sections";
        public static final String HELP_ANCHOR = "map_region_to";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME_PREFIX, ownerName).description(DESCRIPTION)).popupMenuPath(new String[]{"Map Region to ..."})).popupMenuGroup(GROUP)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    static interface MapRegionsToAction {
        public static final String NAME_PREFIX = "Map Regions to ";
        public static final String DESCRIPTION = "Map the selected (module) regions to the current program";
        public static final Icon ICON = DebuggerResources.ICON_MAP_SECTIONS;
        public static final String GROUP = "Dbg9. Map Modules/Sections";
        public static final String HELP_ANCHOR = "map_regions_to";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME_PREFIX, ownerName).description(DESCRIPTION)).popupMenuPath(new String[]{"Map Regions to ..."})).popupMenuGroup(GROUP)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    protected class SelectAddressesAction
    extends DebuggerResources.AbstractSelectAddressesAction {
        public static final String GROUP = "Dbg1. General";

        public SelectAddressesAction() {
            super(DebuggerRegionsProvider.this.plugin);
            this.setDescription("Select addresses contained in regions");
            this.setToolBarData(new ToolBarData(ICON, GROUP));
            this.setPopupMenuData(new MenuData(new String[]{"Select Addresses"}, GROUP));
            DebuggerRegionsProvider.this.addLocalAction((DockingActionIf)this);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionContext context) {
            if (DebuggerRegionsProvider.this.listingService == null) {
                return;
            }
            Set<TraceMemoryRegion> regions = DebuggerRegionsProvider.getSelectedRegions(DebuggerRegionsProvider.this.myActionContext);
            if (regions == null) {
                return;
            }
            AddressSet sel = new AddressSet();
            for (TraceMemoryRegion s : regions) {
                sel.add(s.getRange());
            }
            ProgramSelection ps = new ProgramSelection((AddressSetView)sel);
            DebuggerRegionsProvider.this.listingService.setCurrentSelection(ps);
        }

        public boolean isEnabledForContext(ActionContext context) {
            Set<TraceMemoryRegion> sel = DebuggerRegionsProvider.getSelectedRegions(DebuggerRegionsProvider.this.myActionContext);
            return sel != null && !sel.isEmpty();
        }
    }
}

