/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.action;

import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.action.LocationTracker;
import ghidra.app.plugin.core.debug.gui.action.LocationTrackingSpec;
import ghidra.app.plugin.core.debug.gui.watch.WatchRow;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.async.AsyncUtils;
import ghidra.framework.plugintool.PluginTool;
import ghidra.pcode.exec.DebuggerPcodeUtils;
import ghidra.pcode.exec.PcodeExecutor;
import ghidra.pcode.exec.PcodeExpression;
import ghidra.pcode.exec.SleighProgramCompiler;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Language;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.stack.TraceStack;
import ghidra.trace.util.TraceAddressSpace;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.swing.Icon;

public class WatchLocationTrackingSpec
implements LocationTrackingSpec {
    public static final String CONFIG_PREFIX = "TRACK_WATCH_";
    private final String expression;

    public static WatchLocationTrackingSpec fromWatch(WatchRow watch) {
        return new WatchLocationTrackingSpec(watch.getExpression());
    }

    public WatchLocationTrackingSpec(String expression) {
        this.expression = expression;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WatchLocationTrackingSpec)) {
            return false;
        }
        WatchLocationTrackingSpec that = (WatchLocationTrackingSpec)obj;
        return this.expression.equals(that.expression);
    }

    @Override
    public String getConfigName() {
        return CONFIG_PREFIX + this.expression;
    }

    @Override
    public String getMenuName() {
        return "Track address of watch: " + this.expression;
    }

    @Override
    public Icon getMenuIcon() {
        return DebuggerResources.ICON_REGISTER_MARKER;
    }

    @Override
    public String computeTitle(DebuggerCoordinates coordinates) {
        return "&(" + this.expression + ")";
    }

    @Override
    public LocationTracker getTracker() {
        return new WatchLocationTracker();
    }

    class WatchLocationTracker
    implements LocationTracker {
        private AddressSetView reads;
        private DebuggerCoordinates current = DebuggerCoordinates.NOWHERE;
        private PcodeExecutor<DebuggerPcodeUtils.WatchValue> asyncExec = null;
        private PcodeExpression compiled;

        WatchLocationTracker() {
        }

        @Override
        public CompletableFuture<Address> computeTraceAddress(PluginTool tool, DebuggerCoordinates coordinates) {
            if (!Objects.equals(this.current, coordinates) || this.asyncExec == null) {
                this.current = coordinates;
                this.asyncExec = this.current.getPlatform() == null ? null : DebuggerPcodeUtils.buildWatchExecutor(tool, coordinates);
            } else {
                this.asyncExec.getState().clear();
            }
            if (this.current.getTrace() == null) {
                return AsyncUtils.nil();
            }
            return CompletableFuture.supplyAsync(() -> {
                DebuggerPcodeUtils.WatchValue value;
                Language language = this.current.getPlatform().getLanguage();
                if (!(language instanceof SleighLanguage)) {
                    return null;
                }
                SleighLanguage slang = (SleighLanguage)language;
                if (this.compiled == null || this.compiled.getLanguage() != language) {
                    this.compiled = SleighProgramCompiler.compileExpression((SleighLanguage)slang, (String)WatchLocationTrackingSpec.this.expression);
                }
                return (value = (DebuggerPcodeUtils.WatchValue)this.compiled.evaluate(this.asyncExec)) == null ? null : value.address();
            });
        }

        @Override
        public boolean affectedByBytesChange(TraceAddressSpace space, TraceAddressSnapRange range, DebuggerCoordinates coordinates) {
            return LocationTrackingSpec.changeIsCurrent(space, range, coordinates) && (this.reads == null || this.reads.intersects(range.getX1(), range.getX2()));
        }

        @Override
        public boolean affectedByStackChange(TraceStack stack, DebuggerCoordinates coordinates) {
            return false;
        }
    }
}

