/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.disassemble;

import com.google.common.collect.Range;
import ghidra.framework.cmd.TypedBackgroundCommand;
import ghidra.program.disassemble.Disassembler;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.InstructionBlock;
import ghidra.program.model.lang.InstructionSet;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.mem.MemBuffer;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.util.MathUtilities;
import ghidra.util.task.TaskMonitor;
import java.util.Iterator;

public class TraceDisassembleCommand
extends TypedBackgroundCommand<TraceProgramView> {
    protected final TracePlatform platform;
    protected final Address start;
    protected final AddressSetView restrictedSet;
    protected RegisterValue initialContext;
    private AddressSetView disassembled;

    public TraceDisassembleCommand(TracePlatform platform, Address start, AddressSetView restrictedSet) {
        super("Disassemble", true, true, false);
        this.platform = platform;
        this.start = start;
        this.restrictedSet = restrictedSet;
    }

    public void setInitialContext(RegisterValue initialContext) {
        this.initialContext = initialContext.getBaseRegisterValue();
    }

    protected Disassembler getDisassembler(TraceProgramView view, TaskMonitor monitor) {
        return Disassembler.getDisassembler((Language)this.platform.getLanguage(), (AddressFactory)this.platform.getAddressFactory(), (TaskMonitor)monitor, arg_0 -> ((TaskMonitor)monitor).setMessage(arg_0));
    }

    protected MemBuffer getBuffer(TraceProgramView view) {
        return this.platform.getMappedMemBuffer(view.getSnap(), this.platform.mapHostToGuest(this.start));
    }

    protected int computeLimit() {
        AddressRange range = this.restrictedSet.getRangeContaining(this.start);
        if (range == null) {
            return 1;
        }
        return MathUtilities.unsignedMin((long)(range.getMaxAddress().subtract(this.start) + 1L), (int)Integer.MAX_VALUE);
    }

    protected AddressSetView writeBlock(TraceProgramView view, InstructionBlock block) {
        InstructionSet set = new InstructionSet(this.platform.getAddressFactory());
        set.addBlock(block);
        return view.getTrace().getCodeManager().instructions().addInstructionSet(Range.atLeast((Comparable)Long.valueOf(view.getSnap())), this.platform, set, true);
    }

    public boolean applyToTyped(TraceProgramView view, TaskMonitor monitor) {
        Instruction ins;
        int limit;
        MemBuffer buffer;
        Disassembler disassembler = this.getDisassembler(view, monitor);
        InstructionBlock block = disassembler.pseudoDisassembleBlock(buffer = this.getBuffer(view), this.initialContext, limit = this.computeLimit());
        if (block == null) {
            return true;
        }
        InstructionBlock filtered = new InstructionBlock(block.getStartAddress());
        Iterator iterator = block.iterator();
        while (iterator.hasNext() && this.restrictedSet.contains((ins = (Instruction)iterator.next()).getMaxAddress())) {
            filtered.addInstruction(ins);
        }
        this.disassembled = this.writeBlock(view, filtered);
        return true;
    }

    public AddressSetView getDisassembledAddressSet() {
        return this.disassembled;
    }
}

