/*
 * Decompiled with CFR 0.152.
 */
package help;

import generic.jar.ResourceFile;
import ghidra.framework.Application;
import ghidra.framework.preferences.Preferences;
import ghidra.util.Msg;
import java.awt.Desktop;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.ImageView;
import javax.swing.text.html.StyleSheet;
import resources.IconProvider;
import resources.Icons;
import resources.ResourceManager;
import utilities.util.FileUtilities;

public class GHelpHTMLEditorKit
extends HTMLEditorKit {
    private static final String G_HELP_STYLE_SHEET = "help/shared/Frontpage.css";
    private static final Pattern EXTERNAL_URL_PATTERN = Pattern.compile("https?://.*");
    private static final Pattern FONT_SIZE_PATTERN = Pattern.compile("font-size:\\s*(\\d{1,2})");
    private static final String HELP_WINDOW_ZOOM_FACTOR = "HELP.WINDOW.FONT.SIZE.MODIFIER";
    private static int fontSizeModifier;
    private HyperlinkListener[] delegateListeners = null;
    private HyperlinkListener resolverHyperlinkListener;

    public GHelpHTMLEditorKit() {
        fontSizeModifier = Integer.valueOf(Preferences.getProperty((String)HELP_WINDOW_ZOOM_FACTOR, (String)"0", (boolean)true));
    }

    @Override
    public ViewFactory getViewFactory() {
        return new GHelpHTMLFactory();
    }

    @Override
    public void install(JEditorPane c) {
        super.install(c);
        for (HyperlinkListener listener : this.delegateListeners = c.getHyperlinkListeners()) {
            c.removeHyperlinkListener(listener);
        }
        this.resolverHyperlinkListener = new ResolverHyperlinkListener();
        c.addHyperlinkListener(this.resolverHyperlinkListener);
        c.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("page".equals(propertyName)) {
                    Msg.trace((Object)this, (Object)("Page loaded: " + evt.getNewValue()));
                }
            }
        });
    }

    @Override
    public void deinstall(JEditorPane c) {
        c.removeHyperlinkListener(this.resolverHyperlinkListener);
        for (HyperlinkListener listener : this.delegateListeners) {
            c.addHyperlinkListener(listener);
        }
        super.deinstall(c);
    }

    private boolean isExternalLink(HyperlinkEvent e) {
        String description = e.getDescription();
        return description != null && EXTERNAL_URL_PATTERN.matcher(description).matches();
    }

    private void browseExternalLink(HyperlinkEvent e) {
        String description = e.getDescription();
        if (!Desktop.isDesktopSupported()) {
            Msg.info((Object)this, (Object)("Unable to launch external browser for " + description));
            return;
        }
        try {
            URI uri = e.getURL().toURI();
            Desktop.getDesktop().browse(uri);
        }
        catch (IOException | URISyntaxException e1) {
            Msg.error((Object)this, (Object)("Error browsing to external URL " + description), (Throwable)e1);
        }
    }

    private HyperlinkEvent validateURL(HyperlinkEvent event) {
        URL url = event.getURL();
        try {
            url.openStream();
        }
        catch (IOException ioe) {
            Msg.trace((Object)this, (Object)("URL of link is invalid: " + url.toExternalForm()));
            return this.maybeCreateNewHyperlinkEventWithUpdatedURL(event);
        }
        return event;
    }

    private HyperlinkEvent maybeCreateNewHyperlinkEventWithUpdatedURL(HyperlinkEvent event) {
        Element element = event.getSourceElement();
        if (element == null) {
            return event;
        }
        AttributeSet a = element.getAttributes();
        AttributeSet anchor = (AttributeSet)a.getAttribute(HTML.Tag.A);
        if (anchor == null) {
            return event;
        }
        String HREF2 = (String)anchor.getAttribute(HTML.Attribute.HREF);
        Msg.trace((Object)this, (Object)("HREF of <a> tag: " + HREF2));
        URL newUrl = this.getURLForHREFFromResources(HREF2);
        if (newUrl == null) {
            return event;
        }
        return new HyperlinkEvent(event.getSource(), event.getEventType(), newUrl, event.getDescription(), event.getSourceElement());
    }

    private URL getURLForHREFFromResources(String originalHREF) {
        URL newUrl;
        int anchorIndex = originalHREF.indexOf("#");
        String HREF2 = originalHREF;
        String anchor = null;
        if (anchorIndex != -1) {
            HREF2 = HREF2.substring(0, anchorIndex);
            anchor = originalHREF.substring(anchorIndex);
        }
        if ((newUrl = ResourceManager.getResource((String)HREF2)) != null) {
            return this.createURLWithAnchor(newUrl, anchor);
        }
        newUrl = this.findApplicationfile(HREF2);
        return newUrl;
    }

    private URL createURLWithAnchor(URL anchorlessURL, String anchor) {
        if (anchorlessURL == null) {
            return anchorlessURL;
        }
        if (anchor == null) {
            return anchorlessURL;
        }
        try {
            return new URL(anchorlessURL, anchor);
        }
        catch (MalformedURLException e) {
            Msg.showError((Object)this, null, (String)"Unexpected Error", (Object)("Unexpected error creating a valid URL: " + anchorlessURL + "#" + anchor));
            return null;
        }
    }

    @Override
    public void read(Reader in, Document doc, int pos) throws IOException, BadLocationException {
        super.read(in, doc, pos);
        HTMLDocument htmlDoc = (HTMLDocument)doc;
        this.loadGHelpStyleSheet(htmlDoc);
    }

    private void loadGHelpStyleSheet(HTMLDocument doc) {
        Reader reader = this.getGStyleSheetReader();
        if (reader == null) {
            return;
        }
        StyleSheet ss = doc.getStyleSheet();
        try {
            ss.loadRules(reader, null);
        }
        catch (IOException e) {
            Msg.debug((Object)this, (Object)"Unable to load help style sheet");
        }
    }

    private Reader getGStyleSheetReader() {
        URL url = this.getGStyleSheetURL();
        if (url == null) {
            return null;
        }
        StringBuffer buffy = new StringBuffer();
        try {
            List lines = FileUtilities.getLines((URL)url);
            for (String line : lines) {
                this.changePixels(line, fontSizeModifier, buffy);
                buffy.append('\n');
            }
        }
        catch (IOException e) {
            Msg.debug((Object)this, (Object)("Unable to read the lines of the help style sheet: " + url));
        }
        StringReader reader = new StringReader(buffy.toString());
        return reader;
    }

    private void changePixels(String line, int amount, StringBuffer buffy) {
        Matcher matcher = FONT_SIZE_PATTERN.matcher(line);
        while (matcher.find()) {
            String oldFontSize = matcher.group(1);
            String adjustFontSize = this.adjustFontSize(oldFontSize);
            matcher.appendReplacement(buffy, "font-size: " + adjustFontSize);
        }
        matcher.appendTail(buffy);
    }

    private String adjustFontSize(String sizeString) {
        try {
            int size = Integer.parseInt(sizeString);
            String adjusted = Integer.toString(size + fontSizeModifier);
            return adjusted;
        }
        catch (NumberFormatException e) {
            Msg.debug((Object)this, (Object)("Unable to parse font size string '" + sizeString + "'"));
            return sizeString;
        }
    }

    private URL getGStyleSheetURL() {
        URL GStyleSheetURL = ResourceManager.getResource((String)G_HELP_STYLE_SHEET);
        if (GStyleSheetURL != null) {
            return GStyleSheetURL;
        }
        return this.findModuleFile("help/shared/FrontPage.css");
    }

    private URL findApplicationfile(String relativePath) {
        ResourceFile installDir = Application.getInstallationDirectory();
        ResourceFile file = new ResourceFile(installDir, relativePath);
        if (file.exists()) {
            try {
                return file.toURL();
            }
            catch (MalformedURLException e) {
                Msg.showError((Object)this, null, (String)"Unexpected Error", (Object)("Unexpected error parsing file to URL: " + file));
            }
        }
        return null;
    }

    private URL findModuleFile(String relativePath) {
        Collection moduleDirs = Application.getModuleRootDirectories();
        for (ResourceFile dir : moduleDirs) {
            ResourceFile file = new ResourceFile(dir, relativePath);
            if (!file.exists()) continue;
            try {
                return file.toURL();
            }
            catch (MalformedURLException e) {
                Msg.showError((Object)this, null, (String)"Unexpected Error", (Object)("Unexpected error parsing file to URL: " + file));
                return null;
            }
        }
        return null;
    }

    public static void zoomOut() {
        fontSizeModifier -= 2;
        GHelpHTMLEditorKit.saveZoomFactor();
    }

    public static void zoomIn() {
        fontSizeModifier += 2;
        GHelpHTMLEditorKit.saveZoomFactor();
    }

    private static void saveZoomFactor() {
        Preferences.setProperty((String)HELP_WINDOW_ZOOM_FACTOR, (String)Integer.toString(fontSizeModifier));
        Preferences.store();
    }

    private class GHelpHTMLFactory
    extends HTMLEditorKit.HTMLFactory {
        private GHelpHTMLFactory() {
        }

        @Override
        public View create(Element e) {
            HTML.Tag tag;
            AttributeSet attributes = e.getAttributes();
            Object elementName = attributes.getAttribute("$ename");
            if (elementName != null) {
                return super.create(e);
            }
            Object html = attributes.getAttribute(StyleConstants.NameAttribute);
            if (html instanceof HTML.Tag && (tag = (HTML.Tag)html) == HTML.Tag.IMG) {
                return new GHelpImageView(e);
            }
            return super.create(e);
        }
    }

    private class ResolverHyperlinkListener
    implements HyperlinkListener {
        private ResolverHyperlinkListener() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (GHelpHTMLEditorKit.this.delegateListeners == null) {
                return;
            }
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                if (GHelpHTMLEditorKit.this.isExternalLink(e)) {
                    GHelpHTMLEditorKit.this.browseExternalLink(e);
                    return;
                }
                Msg.trace((Object)this, (Object)("Link activated: " + e.getURL()));
                e = GHelpHTMLEditorKit.this.validateURL(e);
                Msg.trace((Object)this, (Object)("Validated event: " + e.getURL()));
            }
            for (HyperlinkListener listener : GHelpHTMLEditorKit.this.delegateListeners) {
                listener.hyperlinkUpdate(e);
            }
        }
    }

    private class GHelpImageView
    extends ImageView {
        private Image image;
        private float spanX;
        private float spanY;

        public GHelpImageView(Element elem) {
            super(elem);
        }

        @Override
        public Image getImage() {
            Image superImage = super.getImage();
            if (this.image == null) {
                return superImage;
            }
            if (this.isLoading()) {
                return superImage;
            }
            return this.image;
        }

        private boolean isLoading() {
            return this.spanX < 1.0f || this.spanY < 1.0f;
        }

        @Override
        public float getPreferredSpan(int axis) {
            float span = super.getPreferredSpan(axis);
            if (axis == 0) {
                this.spanX = span;
            } else {
                this.spanY = span;
            }
            return span;
        }

        @Override
        public URL getImageURL() {
            AttributeSet attributes = this.getElement().getAttributes();
            Object src = attributes.getAttribute(HTML.Attribute.SRC);
            if (src == null) {
                return null;
            }
            String srcString = src.toString();
            if (this.isJavaCode(srcString)) {
                return this.installImageFromJavaCode(srcString);
            }
            URL url = this.doGetImageURL(srcString);
            return url;
        }

        private URL installImageFromJavaCode(String srcString) {
            IconProvider iconProvider = this.getIconFromJavaCode(srcString);
            if (iconProvider == null || iconProvider.isInvalid()) {
                return null;
            }
            ImageIcon imageIcon = iconProvider.getIcon();
            this.image = imageIcon.getImage();
            URL url = iconProvider.getOrCreateUrl();
            return url;
        }

        private URL doGetImageURL(String srcString) {
            HTMLDocument htmlDocument = (HTMLDocument)this.getDocument();
            URL context = htmlDocument.getBase();
            try {
                URL url = new URL(context, srcString);
                if (FileUtilities.exists((URI)url.toURI())) {
                    return url;
                }
            }
            catch (MalformedURLException | URISyntaxException url) {
                // empty catch block
            }
            URL resource = ResourceManager.getResource((String)srcString);
            return resource;
        }

        private boolean isJavaCode(String src) {
            return Icons.isIconsReference((String)src);
        }

        private IconProvider getIconFromJavaCode(String src) {
            return Icons.getIconForIconsReference((String)src);
        }
    }
}

