/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.plugin.core.analysis.ConstantPropagationAnalyzer;
import ghidra.app.plugin.core.analysis.ConstantPropagationContextEvaluator;
import ghidra.app.plugin.core.clear.ClearFlowAndRepairCmd;
import ghidra.app.services.AnalysisPriority;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.util.ContextEvaluator;
import ghidra.program.util.SymbolicPropogator;
import ghidra.program.util.VarnodeContext;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class SparcAnalyzer
extends ConstantPropagationAnalyzer {
    private static final String PROCESSOR_NAME = "Sparc";

    public SparcAnalyzer() {
        super(PROCESSOR_NAME);
        this.setPriority(AnalysisPriority.FUNCTION_ANALYSIS.after());
    }

    public boolean canAnalyze(Program program) {
        return program.getLanguage().getProcessor().equals((Object)Processor.findOrPossiblyCreateProcessor((String)PROCESSOR_NAME));
    }

    public AddressSetView flowConstants(Program program, Address flowStart, AddressSetView flowSet, SymbolicPropogator symEval, final TaskMonitor monitor) throws CancelledException {
        Function func = program.getFunctionManager().getFunctionContaining(flowStart);
        if (func != null) {
            Instruction dInstr;
            flowSet = func.getBody();
            flowStart = func.getEntryPoint();
            Instruction instr = program.getListing().getInstructionAt(flowStart);
            if (instr.getMnemonicString().equals("retl") && (dInstr = program.getListing().getInstructionAfter(instr.getMinAddress())).getMnemonicString().equals("_add")) {
                Register r0 = dInstr.getRegister(0);
                Register r1 = dInstr.getRegister(1);
                Register r2 = dInstr.getRegister(2);
                if (r0 != null && r0.getName().equals("o7") && r1 != null && r1.equals((Object)r2)) {
                    func.setInline(true);
                }
            }
        }
        ConstantPropagationContextEvaluator eval = new ConstantPropagationContextEvaluator(this.trustWriteMemOption){

            public boolean evaluateContext(VarnodeContext context, Instruction instr) {
                FlowType ftype = instr.getFlowType();
                if (ftype.isCall()) {
                    Address fallAddr = instr.getFallThrough();
                    if (fallAddr == null) {
                        return false;
                    }
                    Instruction delayInstr = instr.getProgram().getListing().getInstructionAfter(instr.getMaxAddress());
                    if (delayInstr == null) {
                        return false;
                    }
                    if (delayInstr.getMnemonicString().compareToIgnoreCase("_restore") == 0) {
                        instr.setFallThrough(null);
                        Instruction fallInstr = instr.getProgram().getListing().getInstructionAt(fallAddr);
                        if (fallInstr == null) {
                            return false;
                        }
                        if (fallInstr.getReferenceIteratorTo().hasNext()) {
                            return false;
                        }
                        ClearFlowAndRepairCmd cmd = new ClearFlowAndRepairCmd(fallAddr, false, false, true);
                        cmd.applyTo((DomainObject)instr.getProgram(), monitor);
                    }
                }
                return false;
            }

            public boolean evaluateDestination(VarnodeContext context, Instruction instruction) {
                FlowType flowType = instruction.getFlowType();
                if (!flowType.isJump()) {
                    return false;
                }
                Reference[] refs = instruction.getReferencesFrom();
                if (refs.length <= 0 || refs.length == 1 && refs[0].getReferenceType().isData()) {
                    this.destSet.addRange(instruction.getMinAddress(), instruction.getMinAddress());
                }
                return false;
            }
        };
        AddressSet resultSet = symEval.flowConstants(flowStart, flowSet, (ContextEvaluator)eval, true, monitor);
        return resultSet;
    }
}

