/* Generated By:JavaCC: Do not edit this line. PreProcessor.java */
package ghidra.app.util.cparser.CPP;

import ghidra.util.Msg;

import java.util.*;
import java.io.*;
import java.math.BigInteger;
import ghidra.program.util.AddressEvaluator;

@SuppressWarnings("all") // ignore warnings from generated code
public class PreProcessor implements PreProcessorConstants {
        class PPToken extends Token /* For Productions */{

                private String path = null;

                public PPToken(PPToken ptk) {
                        super();
                        this.kind = ptk.kind;
                        this.image = ptk.image;
                        this.beginLine = ptk.beginLine;
                        this.truth = ptk.truth;
                        this.comparison = ptk.comparison;
                        this.contradict = ptk.contradict;
                }

                public PPToken(Token tk) {
                        super();
                        this.kind = tk.kind;
                        this.image = tk.image;
                        this.beginLine = tk.beginLine;
                        this.comparison = 0;
                        this.truth = false;
                        contradict = false;
                }

                public PPToken(Token tk, boolean truth) {
                        super();
                        this.kind = tk.kind;
                        this.image = tk.image;
                        this.beginLine = tk.beginLine;
                        this.comparison = 0;
                        this.truth = truth;
                        contradict = false;
                }

                public PPToken(String val) {
                        super();
                        this.kind = 0;
                        this.image = val;
                        this.beginLine = 0;
                        this.comparison = 0;
                        this.truth = false;
                        contradict = false;
                }

                boolean truth;
                boolean contradict;
                boolean emitExecSave;
                int comparison;

                ArrayList <StringBuffer> appendList = new ArrayList();
        ArrayList <Boolean> expandList = new ArrayList();

        void append(String str, boolean expand) {
           if (image != null & image.length()>0) {
               appendList.add(new StringBuffer(image));
               expandList.add(true);
               image = null;
           }
           int endIndex = appendList.size() - 1;
           if (endIndex >= 0 && (str.strip().length()==0 || expand == expandList.get(endIndex)) ) {
                   // just add to the last image so it can expand properly
                   StringBuffer lastStr = appendList.get(endIndex);
                   lastStr.append(str);
                   return;
           }

           appendList.add(new StringBuffer(str));
           expandList.add(expand);
        }

//        void append(PPToken tok, boolean expand) {
//           if (tok.image != null && tok.image.length() > 0) {
//              append(tok.image, expand);
//              return;
//           }
//		   int cnt = 0;
//           for (String string : appendList) {
//              append(string, expandList.get(cnt));
//           }
//        }

                void setTruth(boolean truth) {
                        this.truth = truth;
                        this.contradict = false;
                }

                void setContra(boolean truth) {
                        this.contradict = truth;
                }

                void setKind(int kind) {
                        this.kind = kind;
                }

                void setLine(int line) {
                        this.beginLine = line;
                }

                void setEmitSave(boolean truth) {
                        this.emitExecSave = truth;
                }

                void setPath(String path) {
                        this.path = path;
                }

                String getPath() {
                        return path;
                }

                // For hashtable
                public boolean equals(Object t) {
                        if (t.getClass() == getClass()) {
                                return this.image.equals(((PPToken) t).image);
                        } else
                                try {
                                        if (t.getClass() == Class.forName("CPP.Token")) {
                                                return this.image.equals(((Token) t).image);
                                        } else if (t.getClass() == Class
                                                        .forName("java.lang.String")) {
                                                return this.image.equals((String) t);
                                        }
                                } catch (ClassNotFoundException e) {
                                        addParseMessage(null, "PPToken.equals: " + e.getMessage());
                                }
                        return false;
                }

                double Double() {
                        return Double.parseDouble(this.image);
                }

                int Integer() {
                        return Integer.parseInt(this.image);
                }

                void fixupNumericValue(PPToken val) {
                        int opos = val.image.indexOf('(');
                        if (opos >= 0) {
                                int cpos = val.image.lastIndexOf(')');
                                if (cpos >= 0 && cpos != opos + 1) {
                                        val.image = val.image.substring(opos + 1, cpos - 1).trim();
                                }
                        }
                        val.image = defs.expand(val.image, true);
                        val.kind = getNumericType(val.image);
                }

                int compareToZero() {
                        try {
                                switch (this.kind) {
                                        case PreProcessor.FP_NUMERIC:
                                        case PreProcessor.FP_LITERAL:
                                                Double thisFP = new Double(this.image);
                                                Double zeroFP = new Double(0.0);
                                                comparison = thisFP.compareTo(zeroFP);
                                                break;
                                        case PreProcessor.INTEGER_LITERAL:
                                        case PreProcessor.NUMERIC:
                                                BigInteger value = getLongValue(this.image);
                                                comparison = value.compareTo(BigInteger.ZERO);
                                                break;
                                        case PreProcessor.ITEM:
                                        case PreProcessor.MANIFEST:
                                        case PreProcessor.VALUES:
                                                if (isDef(this) == true) {
                                                        PPToken repVal = (PPToken) getDef(this);
                                                }
                                                break;
                                        default:
                                                addParseMessage(null, "Cannot compareToZero Token: " + image + " kind " + kind);
                                                break;
                                }
                        }
                        catch (Exception e) {
                                addParseMessage(null, "CMP2Zero:Numeric Conversion Error: " + e.getMessage());
                        }
                        return comparison;
                }

                int compareTo(PPToken that) {
                        Double thisFP = new Double(0.0);
                        Double thatFP = new Double(0.0);
                        String thisVal = null;
                        String thatVal = null;
                        try {
                                switch (this.kind) {
                                        case PreProcessor.FP_NUMERIC:
                                        case PreProcessor.FP_LITERAL:
                                                thisFP = new Double(this.image);
                                                break;
                                        case PreProcessor.NUMERIC:
                                        case PreProcessor.INTEGER_LITERAL:
                                                thisFP = new Double(getLongValue(this.image).doubleValue());
                                                break;
                                        default:
                                                PPToken replVal = (PPToken) getDef(this); // not a PPToken
                                                if (replVal == null) {
                                                        replVal = new PPToken(this);
                                                        // addParseMessage(null,
                                                        // "Missing numeric value for: "+image+" at "
                                                        // +curFileStackTop
                                                        // ()+"'"+beginLine+". PreProcessor expects one.");
                                                }
                                                thisVal = replVal.image;
                                                fixupNumericValue(replVal);
                                                thisFP = getDoubleValue(replVal.image);
                                }
                        }
                        catch (NumberFormatException e) {
                                thisFP = null;
                        }
                        catch (Exception e) {
                                thisFP = null;
                                // addParseMessage(null, "Numeric Conversion Error for '" + this.image
                                // + "' in " + curFileStackTop() + " line " + that.beginLine +
                                // " : "+e.getMessage());
                        }
                        try {
                                switch (that.kind) {
                                        case PreProcessor.FP_NUMERIC:
                                        case PreProcessor.FP_LITERAL:
                                                thatFP = new Double(that.image);
                                                break;
                                        case PreProcessor.NUMERIC:
                                        case PreProcessor.INTEGER_LITERAL:
                                                thatFP = new Double(getLongValue(that.image).doubleValue());
                                                break;
                                        default:
                                                PPToken replVal = (PPToken) getDef(that); // not a PPToken
                                                if (replVal == null) {
                                                        replVal = new PPToken(that);
                                                        // addParseMessage(null,
                                                        // "Missing numeric value for: "+image+" at "
                                                        // +curFileStackTop
                                                        // ()+"'"+beginLine+". PreProcessor expects one.");
                                                }
                                                thatVal = replVal.image;
                                                fixupNumericValue(replVal);
                                                thatFP = getDoubleValue(replVal.image);
                                }
                        }
                        catch (NumberFormatException e) {
                                thatFP = null;
                        }
                        catch (Exception e) {
                                thatFP = null;
                                // addParseMessage(null, "Numeric Conversion Error in " +
                                // curFileStackTop() + " line " + that.beginLine +
                                // " : "+e.getMessage());
                        }
                        if (this.image.equals(that.image)) {
                                return 0;
                        }
                        if (this.image.equals(thatVal)) {
                                return 0;
                        }
                        if (thisVal != null && thisVal.equals(that.image)) {
                                return 0;
                        }
                        if (thisVal != null && thisVal.equals(thatVal)) {
                                return 0;
                        }
                        if (thisFP != null && thatFP != null) {
                                comparison = thisFP.compareTo(thatFP);
                        }
                        else if (thisFP != null && thatFP == null) {
                                comparison = 1;
                        }
                        else if (thisFP == null && thatFP != null) {
                                comparison = -1;
                        }
                        else if (thisVal != null && thatVal != null) {
                                comparison = thisVal.compareTo(thatVal);
                        }
                        return comparison;
                }

                PPToken computeBinary(Token op, PPToken val2) {
                        BigInteger tvalue = BigInteger.ZERO;
                        BigInteger result = BigInteger.ZERO;
                        BigInteger vvalue = BigInteger.ZERO;
                        try {
                                tvalue = getLongValue(getDef(this).image);
                                vvalue = getLongValue(getDef(val2).image);
                        }
                        catch (Exception e) {
                        }
                        switch (op.kind) {
                                case MINUS:
                                        result = tvalue.subtract(vvalue);
                                        break;
                                case PLUS:
                                        result = tvalue.add(vvalue);
                                        break;
                                case TIMES:
                                        result = tvalue.multiply(vvalue);
                                        break;
                                case AND:
                                        result = tvalue.and(vvalue);
                                        break;
                                case OR:
                                        result = tvalue.or(vvalue);
                                        break;
                                case RSH:
                                        result = tvalue.shiftRight(vvalue.intValue());
                                        break;
                                case LSH:
                                        result = tvalue.shiftLeft(vvalue.intValue());
                                        break;
                        }
                        PPToken t = new PPToken(result.toString());
                        t.kind = NUMERIC;
                        t.setTruth(result != BigInteger.ZERO);
                        return t;
        }

        PPToken computeUnary(Token op) {
                        BigInteger tvalue = BigInteger.ZERO;
                        BigInteger result = BigInteger.ZERO;
                        try {
                                tvalue = getLongValue(getDef(this).image);
                        }
                        catch (Exception e) {
                        }
                        switch (op.kind) {
                                case MINUS:
                                        result = tvalue.negate();
                                        break;
                                case NOT:
                                        result = (BigInteger.ZERO.equals(tvalue) ? BigInteger.ZERO : BigInteger.ONE);
                                        break;
                        }
                        PPToken t = new PPToken(result.toString());
                        t.kind = NUMERIC;
                        t.setTruth(!BigInteger.ZERO.equals(result));
                        return t;
        }

                boolean getEmitSave() {
                        return emitExecSave;
                }

                boolean getTruth() {
                        if (contradict == false)
                                return truth;
                        else
                                return !truth;
                }

                void join() {
                        StringBuffer buf = new StringBuffer(image);
                        int pos = image.length();
                        while (pos > 0) {
                                pos = image.lastIndexOf("\u005c\u005c\u005cn", pos);
                                if (pos >= 0) {
                                        buf.replace(pos, pos + 2, " ");
                                        pos--;
                                        continue;
                                }
                                pos = image.lastIndexOf("\u005c\u005c\u005cr\u005cn", pos);
                                if (pos >= 0) {
                                        buf.replace(pos, pos + 3, " ");
                                        pos--;
                                        continue;
                                }
                                pos = image.lastIndexOf("\u005c\u005c\u005cr", pos);
                                if (pos >= 0) {
                                        buf.replace(pos, pos + 2, " ");
                                        pos--;
                                        continue;
                                }
                        }
                        image = buf.toString();
                }

        void emit(boolean expand) {
                if (expand && appendList.isEmpty()) {
                image = defs.expand(image, true);
                } else {
                        int cnt = 0;
                        for (StringBuffer string : appendList) {
                                if (expand && expandList.get(cnt++)) {
                                        image += defs.expand(string.toString(), true);
                                } else {
                                        image += string;
                                }
                                }
                }
                if (image.length() == 1 && image.startsWith("\u005cn")) {
               image = (!emitExecSwitch ? "////\u005cn" : "\u005cn");
            }
                print(image);
        }

        }

        // Command Line cursor
        int shift;

        // Emmitter switch
        boolean emitExecSwitch = true;

        // Hastable for storing #include file names
        HashSet<String> files = new HashSet<String>();

        // Stack for keeping shadowed (include) files
        Stack<String> fileStack = new Stack<String>();

        // Stack for keeping directive states
        Stack<PPToken> execStack = new Stack<PPToken>();

        // Token string for Include Directory Pathlist
        Vector<String> pathList = new Vector<String>();

        int ifDepth = 0;

        //Hastable for storing #defs
        DefineTable defs = new DefineTable();

        // output stream to print to
        PrintStream outputStream = System.out;

        // header files that have already been parsed, and the count of number of
        // times they have been parsed
        private HashMap<String, Integer> alreadyDone;

    private StringBuilder parseMessages = new StringBuilder();

    // true if parse was successful
    private boolean parseSuccess = false;

        // Toggle printing
        private int verboseLevel = 0;

        public int verboseLevel() {
                int vl = verboseLevel;
                return vl;
        }

        public String curFileStackTop() {
                return (fileStack.empty() ? "" : fileStack.peek().toString());
        }

        // get the define table for outside processing
        public DefineTable getDefinitions() {
                return defs;
        }

    // Get a def from the manifest constant list, from a defined string
        public PPToken getDef(PPToken def) {
                if (verboseLevel == 6 || verboseLevel == 5 || verboseLevel == 4 || verboseLevel == 3)
                        println("Defs: containsKey: " + def.image + " = " + defs.containsKey(def.image));
                PPToken pt = defs.get(def.image);
                if (pt != null && pt.image.length() > 0) {
                        String expanded = defs.expand(pt.image, false);
                        pt = new PPToken(pt);
                        pt.image = expanded;
                }
                else {
                        // no Def, it is what it is!
                        pt = def;
                }
                return pt;
        }

    // Get a define definition by name from the list
    public String getDef(String name) {
            PPToken pt = defs.get(name);
            String val = name;
                        if (pt != null && pt.image.length() > 0) {
                                val = defs.expand(pt.image, false);
                        }
                        else {
                                // no Def, it is what it is!
                        }
            return val;
    }

        // Add a def to the manifest constant list
        private void setDef(PPToken def) {
                if (verboseLevel == 3 || verboseLevel == 6)
                        println(curFileStackTop() + "'" + def.beginLine + ": Defining: "
                                        + def.image);
                if (emitExecSwitch == true) {
                        defs.put(def.image, new PPToken(""));
                        // setDef(def.image, "");
                }
        }

        // Add a def to the manifest constant list
        private void setDef(PPToken key, PPToken val) {
                if (verboseLevel == 4 || verboseLevel == 6)
                        println(curFileStackTop() + "'" + key.beginLine
                                        + ": Defining text: " + key.image + " = " + val.image);
                if (emitExecSwitch == true) {
                        // val.expand(false);
                        val.image = val.image.trim();
                        val.setPath(curFileStackTop());
                        defs.put(key.image, val);
                }
        }

        // Add an arg vector to the argument list
        private void setArg(PPToken key, Vector val) {
                if (verboseLevel == 4 || verboseLevel == 6) {
                        print(curFileStackTop() + "'" + key.beginLine + ": Defining text: "
                                        + key.image + " (");
                        for (int i = 0; i < val.size(); i++) {
                                if (i == 0) {
                                        print(((PPToken) val.elementAt(i)).image);
                                } else if (i < val.size() - 1) {
                                        print("," + ((PPToken) val.elementAt(i)).image);
                                } else {
                                        println("," + ((PPToken) val.elementAt(i)).image + ")");
                                }
                        }
                }
                if (emitExecSwitch == true) {
                        defs.putArg(key.image, val);
                }
        }

        // Add a macro to the manifest constant and substitution list
        private void setMacro(PPToken key, Vector marg, PPToken val) {
                if (verboseLevel == 5 || verboseLevel == 6)
                        println(curFileStackTop() + "'" + key.beginLine
                                        + ": Defining text: " + key.image + " = " + val.image);
                if (emitExecSwitch == true) {
                        setDef(key, val);
                }
                if (verboseLevel == 5 || verboseLevel == 6) {
                        println("\u005ct" + curFileStackTop() + "'" + key.beginLine
                                        + ": Defining text: " + key.image + " (");
                        for (int i = 0; i < marg.size(); i++) {
                                if (i == 0) {
                                        print(((PPToken) marg.elementAt(i)).image);
                                } else if (i < marg.size() - 1) {
                                        print("," + ((PPToken) marg.elementAt(i)).image);
                                } else {
                                        println("," + ((PPToken) marg.elementAt(i)).image + ")");
                                }
                        }
                }
                if (emitExecSwitch == true) {
                  if (marg != null) {
                        setArg(key, marg);
              }
                }
        }

        // Remove a def from the manifest constant list
        private void UnDefine(PPToken def) {
                if (isArg(def)) {
                        Forget(def);
                }
                if (isDef(def)) {
                        if (emitExecSwitch == true) {
                                defs.remove(def.image);
                        }
                }
        }

        // Forget a macro from the substitution list
        private void Forget(PPToken val) {
                if (emitExecSwitch == true) {
                        defs.removeArg(val.image);
                }
        }

        private void localPlace(PPToken inc, boolean xsym) throws ParseException {
                String def = inc.image;
                File incFile = null;
                FileInputStream fis = null;
                String srcPath = null;
                try {
                        if (srcPath == null) {
                                srcPath = "." + File.separator;
                        }
                        incFile = new File(srcPath + def);
                        if (incFile.exists()) {
                                fis = new java.io.FileInputStream(incFile);
                        } else {
                                incFile = new File(srcPath + def.toLowerCase());
                                if (incFile.exists()) {
                                        fis = new java.io.FileInputStream(incFile);
                                }
                        }
                } catch (FileNotFoundException fene) {
                        addParseMessage(incFile.getName(), fene.getMessage());
                }
                if (fis == null) {
                        // addParseMessage(null,
                        // "Warning: No relative path to #include \""+def+"\"\nThis is a design/configuration flaw. Trying the standard places...");
                        standardPlace(inc, xsym);
                } else {
                        if (verboseLevel == 2) {
                                print("Line " + inc.beginLine + ": " + curFileStackTop()
                                                + " => ");
                        }
                        swapFileStreams(incFile, fis);
                }
        }

        private void swapFileStreams(File incFile, FileInputStream fis) throws ParseException {
                if (verboseLevel == 2)
                        print(incFile.getAbsolutePath() + "\u005cn");
                else if (verboseLevel == 1)
                        println("Parsing stream " + incFile.getAbsolutePath() + " ... ");
                PreProcessor parser = null;
                try {
                        //
                        // check how many times this file occurs on the stack to try to
                        // detect inclusion recursion
                        int pos = -1;
                        int count = 0;
                        do {
                                pos = fileStack.indexOf(incFile.getAbsolutePath(), pos + 1);
                                if (pos >= 0) {
                                        count++;
                                }
                                if (count > 5) {
                                        addParseMessage(incFile.getAbsolutePath(),
                                                "Error: Possible infinite inclusion recursion detected: \u005cn" + fileStack);
                                        return;
                                }
                        } while (pos != -1);

                        // check if this has already been done
                        Integer val = alreadyDone.get(incFile.getAbsolutePath());
                        if (val == null) {
                                val = Integer.valueOf(0);
                        }
                        // Must parse headers multiple times, MS uses headers to set pack()
                        // still useful for debugging

                        val = val + 1;
                        alreadyDone.put(incFile.getAbsolutePath(), val);

                        fileStack.push(incFile.getAbsolutePath());
                        parser = new PreProcessor(this);
                        parser.ReInit(fis);
                        parser.Input();
                        fileStack.pop();
        } catch (ParseException e) {
                        addParseMessage(incFile.getName(), "ERROR parsing Included File: " + e.getMessage());
                        throw e;
                }
                catch (TokenMgrError e) {
                        addParseMessage(incFile.getName(), "ERROR parsing Included File: " + e.getMessage());
                        throw e;
                }
        }

        private void standardPlace(PPToken inc, boolean xsym) throws ParseException {
                includeFile(inc, xsym);
        }

        // Returns true if constant is def
        private boolean isNDef(PPToken def) {
                if (verboseLevel == 6) {
                        print("Line " + def.beginLine + ": " + curFileStackTop()
                                        + " Check isNDef " + def.image);
                }
                if (defs.containsKey(def.image) == false) {
                        if (verboseLevel == 6)
                                println("True");
                        return true;
                }
                if (verboseLevel == 6)
                        println("False");
                return false;
        }

        // Returns true if constant is def
        public boolean isDef(PPToken def) {
                if (verboseLevel == 6) {
                        print("Line " + def.beginLine + ": " + curFileStackTop()
                                        + " Check isDef " + def.image);
                }
                if (defs.containsKey(def.image) == true) {
                        if (verboseLevel == 6)
                                println("True");
                        return true;
                }
                ;
                if (verboseLevel == 6)
                        println("False");
                return false;
        }

        // Returns true if macro argument is defined
        public boolean isArg(PPToken arg) {
                if (verboseLevel == 6) {
                        print("Line " + arg.beginLine + ": " + curFileStackTop()
                                        + " Check isArg " + arg.image);
                }
                if (defs.isArg(arg.image) == true) {
                        if (verboseLevel == 6)
                                println("True");
                        return true;
                }
                ;
                if (verboseLevel == 6)
                        println("False");
                return false;
        }

        // Parse include file
        private void includeFile(PPToken inc, boolean xsym) throws ParseException {
                String ft = inc.image;
                String fn = new String(ft);
                // get rid of any errant quoting or whitespace
                fn = fn.trim();
                if (fn.charAt(0) == '\u005c"' && fn.endsWith("\u005c"")) {
                        fn = fn.substring(1, fn.length() - 1);
                }
                FileInputStream fis = null;
                File iFile = null;
                int i;

                boolean alreadyIncluded = addFile(fn);
                for (i = 0; i < pathList.size(); i++) {
                        iFile = getFile(pathList.elementAt(i), fn, xsym);
                        // don't include the same file name
                        if (iFile != null
                                        && iFile.getAbsolutePath().equals(fileStack.peek())) {
                                continue;
                        }
                        fis = getFIS(iFile);
                        if (fis != null) {
                                break;
                        }
                }
                if (fis == null) {
                        iFile = new File(fileStack.lastElement());
                        iFile = getFile(iFile.getParent(), fn, xsym);
                        fis = getFIS(iFile);
                }
                if (fis == null) {
                        addParseMessage(null, "WARNING: No path to #include " + ft +
                                "    Assuming not needed!" + "\u005cnUse -I option");
                        addParseMessage(null, "    Current Include Path: ");
                        for (String element : fileStack) {
                                addParseMessage(null, "     :   " + element);
                        }
                } else {
                        if (verboseLevel == 2) {
                                print("Line " + inc.beginLine + ": " + curFileStackTop() + " => ");
                        }
                        StringBuffer pad = new StringBuffer();
                        for (String element : fileStack) {
                                pad.append("   ");
                        }
                        if (!alreadyIncluded) {
                addParseMessage(null, "      " + pad + iFile);
                    }
                        swapFileStreams(iFile, fis);
                        if (verboseLevel == 1) {
                                addParseMessage(null, "Include depth " + fileStack.size() + ": Done!");
                        }
                }
        }

        private File getFile(String parent, String filename) {
                return getFile(parent, filename, true);
        }

        private File getFile(String parent, String filename, boolean possibleXsym) {
                File file = findFile(parent, filename, possibleXsym);
                if (file != null) {
                        return file;
                }
                // filename lower
                file = findFile(parent, filename.toLowerCase(), possibleXsym);
                if (file != null) {
                        return file;
                }
                // parent and filename lower
                file = findFile(parent.toLowerCase(), filename.toLowerCase(),
                                possibleXsym);
                if (file != null) {
                        return file;
                }
                // parent and filename upper
                file = findFile(parent.toUpperCase(), filename.toUpperCase(),
                                possibleXsym);
                return file;
        }

        private File findFile(String parent, String filename, boolean possibleXsym) {
                File iFile = null;

                iFile = new File(parent + File.separator + filename);
                if (iFile.exists())
                        return iFile;

                // try just in this directory
                File sameiFile = new File(parent + File.separator
                                + (new File(filename)).getName());
                if (sameiFile.exists())
                        return sameiFile;

                // try all files in this directory doing to-lower on both input file and output file
                // if match return it
                File folder = new File(parent);
                if (folder.isDirectory()) {
                        File[] listOfFiles = folder.listFiles();

                        if (listOfFiles != null) {
                                for (File file : listOfFiles) {
                                        if (file.isFile() && filename.compareToIgnoreCase(file.getName()) == 0) {
                                                return file;
                                        }
                                }
                        }
                }

                if (possibleXsym) {
                        String child = "";
                        // look up parent chain, looking for a file that has an Xsym in it
                        while (iFile != null && iFile.getParent() != null) {
                                if (child.length() <= 0) {
                                        child = iFile.getName();
                                } else {
                                        child = iFile.getName() + File.separator + child;
                                }
                                iFile = iFile.getParentFile();
                                if (!iFile.exists()) {
                                        File frameFile = new File(iFile.getAbsolutePath()
                                                        + ".framework" + File.separator + iFile.getName());
                                        if (!frameFile.exists())
                                                continue;
                                        iFile = frameFile;
                                }
                                if (!iFile.isFile()) {
                                        if (iFile.getName().equals("..")) {
                                                return getFile(iFile.getParent(), child);
                                        }
                                        return null;
                                }
                                FileInputStream fis = getFIS(iFile);
                                if (fis == null) {
                                        return null;
                                }
                                String nPath = "";

                                try {
                                        try {
                                                // open the file
                                                BufferedReader br = new BufferedReader(
                                                                new InputStreamReader(fis));
                                                String str = br.readLine();
                                                // check for XSym
                                                if (str == null || !str.equals("XSym")) {
                                                        File subFile = getFile(iFile.getParent()
                                                                        + File.separator + "Headers", child, true);
                                                        if (subFile != null) {
                                                                return subFile;
                                                        }
                                                        return getFile(iFile.getParent(), child, true);
                                                }
                                                str = br.readLine();
                                                str = br.readLine();
                                                // pull out the file link
                                                nPath = br.readLine();

                                                if (nPath.length() <= 0) {
                                                        return null;
                                                }

                                                // recreate the full file
                                                iFile = new File(iFile.getParent() + File.separator
                                                                + nPath + File.separator + child);

                                                // recurse
                                                return getFile(iFile.getParent(), iFile.getName(), true);
                                        } finally {
                                                fis.close();
                                        }
                                } catch (IOException e) {
                                }
                                return null;
                        }
                        // if found, re-create the file name with the new indirection
                }
                return null;
        }

        private FileInputStream getFIS(File iFile) {
                if (iFile == null) {
                        return null;
                }
                FileInputStream fis = null;
                try {
                        if (iFile.exists())
                                fis = new java.io.FileInputStream(iFile);
                        if (fis == null) {
                                // try lower case
                                File lowerFile = new File(iFile.getParent(), iFile.getName()
                                                .toLowerCase());
                                if (lowerFile.exists())
                                        fis = new java.io.FileInputStream(lowerFile);
                        }
                } catch (FileNotFoundException fene) {
                        addParseMessage(null, fene.getMessage() + " " + iFile);
                }
                return fis;
        }

        // Add an include file to those already included, return true if already included
        private boolean addFile(String file) {
            if (files.contains(file)) {
              return true;
            }
                files.add(file);
                return false;
        }

        private void printCommentedLines(boolean emitSwitch, String line, String state) {
                StringBuffer buf = new StringBuffer("///");
                buf.append(emitSwitch ? " " : "/" );
                buf.append(line);
                if (emitSwitch) {
                        buf.append(" ===" + state);
                }
                buf.append("\u005cn");
                print(buf.toString());
                // "#else if " + t.image + (emitExecSwitch == false ? "" : " ===" + t.getTruth()) + "\n"
    }

        // Print String
        private void print(String text) {
                outputStream.print(text);
        }

        // Print NewLine String
        private void println(String text) {
                outputStream.println(" " + text);
        }

        // Prints out all the files used in parsing the source
        private void printFiles() {

                Iterator<String> eFiles = files.iterator();

                while (eFiles.hasNext()) {
                        addParseMessage(null, "PreProcessor: " + eFiles.next());
                }
        }

        // Run the command-line parser
        private int getopt(String args[]) throws ParseException {
                int argc = args.length, i;
                for (i = 0; i < argc; i++) {
                        String argString = args[i];
                        switch (argString.charAt(0)) {
                        case '-':
                                String optValue = "";
                                if (argString.length() > 2) {
                                        optValue = argString.substring(2);
                                } else if (i < args.length - 1) {
                                        optValue = args[++i];
                                }
                                switch (argString.charAt(1)) {
                                case 'I':
                                        addIncludePath(optValue);
                                        continue; // continue loop
                                case 'D':
                                        String key,
                                        val;
                                        StringTokenizer parms = new StringTokenizer(optValue, "=");
                                        if (parms.hasMoreTokens()) {
                                                key = parms.nextToken();
                                                if (parms.hasMoreTokens()) {
                                                        val = parms.nextToken();
                                                } else {
                                                        val = "";
                                                }
                                                if (verboseLevel == 3 || verboseLevel == 6) {
                                                        addParseMessage(null, "Predefining " + key + " to " + val);
                                                }
                                                Token k, v;
                                                k = new Token();
                                                v = new Token();
                                                k.image = key;
                                                v.image = val;
                                                v.kind = getNumericType(val);
                                                k.kind = PreProcessor.ITEM;
                                                PPToken ppk = new PPToken(k);
                                                PPToken ppv = new PPToken(v);
                                                setDef(ppk, ppv);
                                                if (verboseLevel == 3 || verboseLevel == 6) {
                                                        addParseMessage(null, "Defs: containsKey: " + key + " = " +
                                                                                defs.containsKey(key) + " " + defs.size());
                                                }
                                        } else {
                                                if (verboseLevel == 3 || verboseLevel == 6) {
                                                        addParseMessage(null, "Predefining " + optValue);
                                                }
                                                Token k = new Token();
                                                k.image = argString.substring(2);
                                                PPToken ppk = new PPToken(k);
                                                k.kind = PreProcessor.ITEM;
                                                setDef(ppk);
                                        }
                                        continue; // continue loop
                                case 'U': // usefulness unlikely in simple versions of this
                                                        // parser
                                        defs.remove(optValue);
                                        // check String.equal() in defs
                                        continue; // continue loop
                                case 'v':
                                        try {
                                                verboseLevel = Integer.parseInt(optValue, 10);
                                        } catch (NumberFormatException nfe) {
                                                addParseMessage(null, "Verbose Level Error: " + nfe.getMessage());
                                                throw new ParseException("Bad verbosity level " + optValue);
                                        }
                                        continue; // continue loop
                                case 'O':
                                        try {
                                                setOutputStream(new java.io.FileOutputStream(optValue));
                                        } catch (FileNotFoundException exc) {
                                                addParseMessage(null, "Couldn't create file " + optValue);
                                                throw new ParseException("Couldn't create file " + optValue);
                                        }
                                        continue;
                                default:
                                        addParseMessage(null, "Unknown option: " + argString);
                                        throw new ParseException("Unknown option: " + argString);
                                }
                        default:
                                break; // will quit loop;
                        }
                        return i;
                }
                return i;
        }

        public void addIncludePath(String path) {
                pathList.addElement(path);
        }

        public int getNumericType(String val) {
                try {
                        Double.parseDouble(val);
                        return PreProcessor.FP_NUMERIC;
                } catch (NumberFormatException nfe) {
                        try {
                                if (val.endsWith("L") || val.endsWith("l") || val.endsWith("U")) {
                                        val = val.substring(0, val.length() - 1);
                                }
                                if (val.startsWith("0x") || val.startsWith("0X")) {
                                        Integer.parseInt(val.substring(2), 16);
                                } else {
                                        Integer.parseInt(val);
                                }
                                return PreProcessor.NUMERIC;
                        } catch (NumberFormatException exc) {
                        }
                }
                return PreProcessor.ITEM;
        }

        public Double getDoubleValue(String val) {
                double value = 0.0;
                try {
                        value = Double.parseDouble(val);
                } catch (NumberFormatException nfe) {
                        value = getLongValue(val).doubleValue();
                }
                return value;
        }

        private BigInteger getLongValue(String str) throws NumberFormatException {
                try {
                        if (str.endsWith("L") || str.endsWith("l") || str.endsWith("U")) {
                                str = str.substring(0, str.length() - 1);
                        }

                        if (str.startsWith("--")) {
                            str = str.substring(2, str.length());
                        }

                        if (str.startsWith("0x") || str.startsWith("0X")) {
                                return new BigInteger(str.substring(2), 16);
                        }
                        return new BigInteger(str);
                } catch (NumberFormatException exc) {
                }
                throw new NumberFormatException("Couldn't parse number: \u005c'" + str + "\u005c'");
        }

        private void addParseMessage(String filename, String message) {
            if (filename != null) {
                   parseMessages.append("   In file " + filename + "\u005cn");
        }
            parseMessages.append(message + "\u005cn");
        }

        public String getParseMessages() {
                return parseMessages.toString();
        }

        public boolean didParseSucceed() {
          return parseSuccess;
        }

        public void setArgs(String[] args) throws ParseException {
                shift = getopt(args);
        }

        public void setOutputStream(OutputStream fos) {
                outputStream = new PrintStream(fos);
        }

        public void parse(String filename) throws ParseException {
                if (verboseLevel == 1) {
                        addParseMessage(null,
                                "PreProcessor:  Reading from file " + filename + " . . .");
                }

                FileInputStream fis = null;
                try {
                        fis = new java.io.FileInputStream(filename);
                } catch (FileNotFoundException e1) {
                }
                if (fis == null) {
                        for (int i = 0; i < pathList.size(); i++) {
                                File iFile = getFile(pathList.elementAt(i), filename);
                                fis = getFIS(iFile);
                                if (fis != null) {
                                        filename = iFile.getAbsolutePath();
                                        break;
                                }
                        }
                }
                if (fis == null) {
                        addParseMessage(null, "PreProcessor:  File " + filename + " not found.");
                        return;
                }
                fileStack.push(filename);
                alreadyDone = new HashMap<String, Integer>();
                ReInit(fis);
                try {
                        Input();
                        fileStack.pop();
                        if (fileStack.size() == 0) {
                                if (verboseLevel == 1) {
                                        addParseMessage(null,
                                                "PreProcessor:  Java program parsed successfully.");
                                }
                        }
                } catch (ParseException e) {
                        addParseMessage(filename, "PreProcessor Parse Error:  " + e.getMessage());
                        throw e;
                } catch (TokenMgrError e) {
                        addParseMessage(filename, "PreProcessor Token Error:  " + e.getMessage());
                        throw e;
                }
        }

        PreProcessor(PreProcessor parent) {
                this(System.in);
                // suck the state out from the parent processor

                this.defs = parent.defs;
                this.execStack = parent.execStack;
                this.files = parent.files;
                this.fileStack = parent.fileStack;
                this.ifDepth = parent.ifDepth;
                this.outputStream = parent.outputStream;
                this.pathList = parent.pathList;
                this.shift = parent.shift;
                this.alreadyDone = parent.alreadyDone;
                this.verboseLevel = parent.verboseLevel;
        }

        public PreProcessor(String[] args) throws ParseException {
                this(System.in);
                shift = getopt(args);

                if (args.length - shift == 0) {
                        if (verboseLevel == 1) {
                                addParseMessage(null,
                                        "PreProcessor:  Reading from standard input . . .");
                        }
                        fileStack.push("stdin");
                } else
                        while (args.length - shift >= 1) {
                                parse(args[shift]);
                                shift++;
                        }

        }

        public PreProcessor(String filename) throws ParseException {
                this(System.in);
                try {
                        FileInputStream fis = new java.io.FileInputStream(filename);
                        ReInit(fis);
                } catch (java.io.FileNotFoundException e) {
                        addParseMessage(null, "PreProcessor:  File " + filename
                                        + " not found.");
                        addParseMessage(null, "Usage is one of:");
                        addParseMessage(null, "         java PreProcessor < inputfile ...");
                        addParseMessage(null, "OR");
                        addParseMessage(null, "         java PreProcessor inputfile ...");
                        return;
                }
        }

        public PreProcessor() throws ParseException {
                this(System.in);
        }

        // Run the parser
        public static void main(String args[]) {
                try {
                        PreProcessor parser = new PreProcessor(args);
                } catch (ParseException e) {
                        System.out.println("PreProcessor:  Encountered errors during parse.");
                        System.out.println("PreProcessor: " + e.getMessage());
                }
        }

//PARSER PRODUCITONS SECTION
  final public void Input() throws ParseException {
    PPToken b;
    int conditionDepth=execStack.size();
    PPToken ppt = new PPToken("\u005cn#line 1: \u005c""+curFileStackTop()+"\u005c"\u005cn");
    ppt.emit(false);
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 0:
      case EOLCMNTNL:
      case OUTER_TEXT:
      case NEWLINE:
      case OTHER_TEXT:
      case QUOTED_TEXT:
      case IF:
      case ELIF:
      case ELSE:
      case ENDIF:
      case IFDEFED:
      case IFNDEFED:
      case NUMERIC:
      case DIRLINE:
      case XSYMLINKPATH:
      case INCLINE:
      case MACEXPPATH:
      case STANDARD:
      case RELATIVE:
      case PRAGMA_EXPRN:
      case PRGLINE:
      case IFDLINE:
      case IFNDLINE:
      case ERROR_EXPRN:
      case ERRLINE:
      case WARNING_EXPRN:
      case INFO_EXPRN:
      case CONSTITUENT:
      case UNDLINE:
      case MANIFEST:
      case CONLINE:
      case LINLINE:
      case LINEINFO:
        ;
        break;
      default:
        jj_la1[0] = jj_gen;
        break label_1;
      }
      b = TranslationUnit();
                          if (b.getTruth()==false) break;
    }
        if (conditionDepth!=execStack.size()) {
            addParseMessage(null, "Imbalance in sequence/nesting of compile-time conditions/logic in input file "+curFileStackTop());
            addParseMessage(null, "              " + execStack);
            // pop off conditionals, so we can get back on track
            while (conditionDepth != execStack.size() && execStack.size() > 0) {
                PPToken olde = execStack.pop();;
                emitExecSwitch = olde.getEmitSave();
            }
        }
        // Out of translation units
        {if (true) return;}
  }

  final public PPToken TranslationUnit() throws ParseException {
                             PPToken b;
    label_2:
    while (true) {
      b = Group();
                             if (b.getTruth()==false) break;
      if (jj_2_1(2)) {
        ;
      } else {
        break label_2;
      }
    }
                                                                {if (true) return b;}
    throw new Error("Missing return statement in function");
  }

  final public void NoMas() throws ParseException {
    jj_consume_token(0);
  }

  final public PPToken Group() throws ParseException {
                   PPToken b;
    if (jj_2_3(2)) {
      b = GroupPart();
                                 {if (true) return b;}
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IF:
      case ELIF:
      case ELSE:
      case ENDIF:
      case IFDEFED:
      case IFNDEFED:
        label_3:
        while (true) {
          b = IFSection();
                                if (b.getTruth()==false) {if (true) return b;}
          if (jj_2_2(2)) {
            ;
          } else {
            break label_3;
          }
        }
                                                                      {if (true) return b;}
        break;
      default:
        jj_la1[1] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public PPToken GroupPart() throws ParseException {
                        PPToken t,u=new PPToken("");Token v=new Token();v.image="";
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EOLCMNTNL:
    case OUTER_TEXT:
    case NEWLINE:
    case OTHER_TEXT:
    case QUOTED_TEXT:
    case DIRLINE:
    case INCLINE:
    case PRGLINE:
    case IFDLINE:
    case IFNDLINE:
    case ERRLINE:
    case UNDLINE:
    case CONLINE:
    case LINLINE:
      label_4:
      while (true) {
        t = Text();
         /* ==>> HERE IS WHERE WE EMIT <<=== */
         // t.append(u.image, true);
         if (emitExecSwitch==true) { t.emit(true); } else t.emit(false);
         t.image="";
         u.image="";
        if (jj_2_4(2)) {
          ;
        } else {
          break label_4;
        }
      }
        t.setTruth(true); {if (true) return t;}
      break;
    default:
      jj_la1[2] = jj_gen;
      if (jj_2_6(3)) {
        label_5:
        while (true) {
          t = IFSection();
                                                 {if (true) return t;}
          if (jj_2_5(2)) {
            ;
          } else {
            break label_5;
          }
        }
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case 0:
        case NUMERIC:
        case XSYMLINKPATH:
        case MACEXPPATH:
        case STANDARD:
        case RELATIVE:
        case PRAGMA_EXPRN:
        case ERROR_EXPRN:
        case WARNING_EXPRN:
        case INFO_EXPRN:
        case CONSTITUENT:
        case MANIFEST:
        case LINEINFO:
          t = ControlLine();
                        {if (true) return t;}
          break;
        default:
          jj_la1[3] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public PPToken ControlLine() throws ParseException {
                         PPToken t = new PPToken(""), u = null; Vector vals = new Vector();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NUMERIC:
    case XSYMLINKPATH:
    case MACEXPPATH:
    case STANDARD:
    case RELATIVE:
    case PRAGMA_EXPRN:
    case ERROR_EXPRN:
    case WARNING_EXPRN:
    case INFO_EXPRN:
    case CONSTITUENT:
    case MANIFEST:
    case LINEINFO:
      if (jj_2_7(2)) {
        Define();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case XSYMLINKPATH:
        case MACEXPPATH:
        case STANDARD:
        case RELATIVE:
          Include();
          break;
        case CONSTITUENT:
          UnDef();
          break;
        case PRAGMA_EXPRN:
          Pragma();
          break;
        case ERROR_EXPRN:
          Error();
          break;
        case WARNING_EXPRN:
          Warning();
          break;
        case INFO_EXPRN:
          Info();
          break;
        case NUMERIC:
        case LINEINFO:
          LineInfo();
          break;
        default:
          jj_la1[4] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
        if (vals!=null&&vals.size()==0) vals = null;
        t.setTruth(true);
        {if (true) return t;}
      break;
    case 0:
      NoMas();
        t.setTruth(false);
        {if (true) return t;}
      break;
    default:
      jj_la1[5] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public PPToken IFSection() throws ParseException {
                       PPToken ifg, group;
    ifg = IFGroup();
        group = GroupPart();
        {if (true) return group;}
    throw new Error("Missing return statement in function");
  }

  final public PPToken IFGroup() throws ParseException {
                      PPToken t, e, olde;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IF:
      e = If();
      t = IfCondition();
         e.setEmitSave(emitExecSwitch);
         e.setTruth(t.getTruth());
         execStack.push(e);
         printCommentedLines(emitExecSwitch, "#if " + t.image, "" + t.getTruth());
         if (emitExecSwitch==true) emitExecSwitch = e.getTruth();
         if (verboseLevel==6||verboseLevel==7) {
             println("["+execStack.size()+"]"+"If "+t.getTruth()+" : "+emitExecSwitch);
         }
      break;
    case ELIF:
      e = ElIf();
      t = ElseIfCondition();
         e.setTruth(t.getTruth());
         if (execStack.size()==0) {
             addParseMessage(null,curFileStackTop()+"'"+t.beginLine+"Unbalanced IF directive detected");
                 {if (true) throw new ParseException(curFileStackTop()+"'"+t.beginLine+"Unbalanced IF directive detected");}
         }
         olde = (PPToken) execStack.pop();
         emitExecSwitch = olde.getEmitSave();
         printCommentedLines(emitExecSwitch, "#else if " + t.image, "" + t.getTruth());
         e.setEmitSave(emitExecSwitch);
         if (!olde.getTruth() && emitExecSwitch==true)
             emitExecSwitch = e.getTruth();
         else
             emitExecSwitch = false;
         if (olde.getTruth()) e.setTruth(true);  // if previous "if" already true, carry forward
         execStack.push(e);
         if (verboseLevel==6||verboseLevel==7) {
             println("["+execStack.size()+"]"+"ElIf "+t.getTruth()+" : "+emitExecSwitch);
         }
      break;
    case IFDEFED:
      e = IfDef();
      t = IfDefExpr();
         t.setEmitSave(emitExecSwitch);
         execStack.push(t);
         printCommentedLines(emitExecSwitch, "#ifdef " + t.image, "" + t.getTruth());
         if (emitExecSwitch==true) emitExecSwitch = t.getTruth();
         if (verboseLevel==6||verboseLevel==7) {
             println("["+execStack.size()+"]"+"IfDef "+t.getTruth()+" : "+emitExecSwitch);
         }
      break;
    case IFNDEFED:
      e = IfNDef();
      t = IfNDefExpr();
         t.setEmitSave(emitExecSwitch);
         execStack.push(t);
         printCommentedLines(emitExecSwitch, "#ifndef " + t.image, "" + t.getTruth());
         if (emitExecSwitch==true) emitExecSwitch = t.getTruth();
         if (verboseLevel==6||verboseLevel==7) {
             println("["+execStack.size()+"]"+"IfNDef "+t.getTruth()+" : "+emitExecSwitch);
         }
      break;
    case ELSE:
      t = Else();
         if (execStack.size()==0) {
             addParseMessage(null, curFileStackTop()+"'"+t.beginLine+"Unbalanced IF directive detected");
             {if (true) throw new ParseException (curFileStackTop()+"'"+t.beginLine+"Unbalanced IF directive detected");}
         }
         olde = (PPToken) execStack.pop();
         emitExecSwitch = olde.getEmitSave();
         printCommentedLines(emitExecSwitch, "#else", "" + t.getTruth());
         t.setEmitSave(emitExecSwitch);
         if (emitExecSwitch && olde.getTruth()) emitExecSwitch = false;
         execStack.push(t);
         if (verboseLevel==6||verboseLevel==7) {
             println("["+execStack.size()+"]"+curFileStackTop()+"'"+t.beginLine+": Else now "+t.getTruth()+" : "+emitExecSwitch);
         }
      break;
    case ENDIF:
      t = EndIf();
         if (execStack.size()==0) {
            addParseMessage(null, curFileStackTop()+"'"+t.beginLine+"Unbalanced IF directive detected");
            {if (true) throw new ParseException(curFileStackTop()+"'"+t.beginLine+"Unbalanced IF directive detected");}
         }
         olde = (PPToken) execStack.pop();
         boolean newExecSwitch = olde.getEmitSave();
         printCommentedLines(newExecSwitch, "#endif", "" + emitExecSwitch);
         emitExecSwitch = newExecSwitch;
         if (verboseLevel==6||verboseLevel==7) {
             println("["+execStack.size()+"]"+curFileStackTop()+"'"+t.beginLine+": Endif "+" : "+emitExecSwitch);
         }
      break;
    default:
      jj_la1[6] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public PPToken IfCondition() throws ParseException {
                         PPToken t;
    t = CompoundConditionalExpression();
                                      {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public PPToken ElseIfCondition() throws ParseException {
                             PPToken t;
    t = CompoundConditionalExpression();
                                      {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public PPToken Include() throws ParseException {
                     Token t;PPToken pt;int conditionDepth=execStack.size();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case RELATIVE:
      t = jj_consume_token(RELATIVE);
         pt=new PPToken(t);
         if (emitExecSwitch==true) {
             localPlace(pt, true);
             println("\u005cn#line "+t.beginLine+": \u005c""+curFileStackTop()+"\u005c"");
         }
      break;
    case STANDARD:
      t = jj_consume_token(STANDARD);
         pt=new PPToken(t);
         if (emitExecSwitch==true) {
             standardPlace(pt, true);
             println("\u005cn#line "+t.beginLine+": \u005c""+curFileStackTop()+"\u005c"");
         }
      break;
    case MACEXPPATH:
      t = jj_consume_token(MACEXPPATH);
         pt=new PPToken(t);
         pt.image = defs.expand(pt.image, true);
         if (emitExecSwitch==true) {
             standardPlace(pt, true);
             println("\u005cn#line "+t.beginLine+": \u005c""+curFileStackTop()+"\u005c"");
         }
      break;
    case XSYMLINKPATH:
      t = jj_consume_token(XSYMLINKPATH);
         pt=new PPToken(t);
         if (emitExecSwitch==true) {
             localPlace(pt, true);
             println("\u005cn#line "+t.beginLine+": \u005c""+curFileStackTop()+"\u005c"");
         }
      break;
    default:
      jj_la1[7] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        if (conditionDepth!=execStack.size()) {
            addParseMessage(null, "Imbalance in sequence/nesting of compile-time conditions/logic in included file "+t.image);
            addParseMessage(null, "              " + execStack);
            // pop off conditionals, so we can get back on track
            while (conditionDepth != execStack.size() && execStack.size() > 0) {
                PPToken olde = execStack.pop();
                emitExecSwitch = olde.getEmitSave();
            }
        }
        {if (true) return pt;}
    throw new Error("Missing return statement in function");
  }

  final public PPToken LineInfo() throws ParseException {
                      Token t; Token u;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LINEINFO:
      t = jj_consume_token(LINEINFO);
      break;
    case NUMERIC:
      t = jj_consume_token(NUMERIC);
         t.image = "#line " + t.image + ": \u005c""+curFileStackTop()+"\u005c"";
         println(t.image);
         token_source.SwitchTo(DEFAULT);   // bad stuff, but the only way to get back to default lexer

      break;
    default:
      jj_la1[8] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return new PPToken(t);}
    throw new Error("Missing return statement in function");
  }

  final public PPToken Define() throws ParseException {
                    Token t,u=null,v=null,w=null,x=null;Vector dargs = null;
    if (jj_2_10(2)) {
      t = jj_consume_token(MANIFEST);
      if (jj_2_8(2)) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case MACROMV:
        case MACROMVTAG:
        case MACROARGSEND:
                      u=new Token(); if (dargs==null) { dargs = new Vector(); }
          label_6:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case MACROMV:
            case MACROMVTAG:
              ;
              break;
            default:
              jj_la1[9] = jj_gen;
              break label_6;
            }
            u = MacroArgs();
                                                                                                   dargs.add(u);
          }
          jj_consume_token(MACROARGSEND);
          break;
        case VALUES:
        case VALUESCMT:
        case MOREVAL:
        case QUOTED_VALUE:
        case MACRORV:
        case MACRORVCMT:
        case MQUOTED_VALUE:
          u = MacroVals();
          break;
        default:
          jj_la1[10] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case VALUES:
        case VALUESCMT:
        case MOREVAL:
        case QUOTED_VALUE:
        case MACRORV:
        case MACRORVCMT:
        case MQUOTED_VALUE:
          label_7:
          while (true) {
            w = MacroVals();
                          if (x==null) {
                                   if (dargs != null) {
                                      x=w;
                                   } else {
                                      x=u;x.image+=w.image;
                                   }
                               } else {
                                   x.image+=w.image;
                               }
                           v=x;
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case VALUES:
            case VALUESCMT:
            case MOREVAL:
            case QUOTED_VALUE:
            case MACRORV:
            case MACRORVCMT:
            case MQUOTED_VALUE:
              ;
              break;
            default:
              jj_la1[11] = jj_gen;
              break label_7;
            }
          }
          break;
        default:
          jj_la1[12] = jj_gen;
          ;
        }
      } else {
        ;
      }
    } else if (jj_2_11(2)) {
      t = jj_consume_token(MANIFEST);
      u = MacroArgs();
                    if (dargs==null) { dargs = new Vector(); } dargs.add(u);
      if (jj_2_9(2)) {
        v = Define();
      } else {
        ;
      }
    } else if (jj_2_12(2)) {
      t = jj_consume_token(MANIFEST);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MACROMV:
      case MACROMVTAG:
        label_8:
        while (true) {
          u = MacroArgs();
                       if (dargs==null) { dargs = new Vector(); } dargs.add(u);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case MACROMV:
          case MACROMVTAG:
            ;
            break;
          default:
            jj_la1[13] = jj_gen;
            break label_8;
          }
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case VALUES:
        case VALUESCMT:
        case MOREVAL:
        case QUOTED_VALUE:
        case MACRORV:
        case MACRORVCMT:
        case MQUOTED_VALUE:
          v = MacroVals();
          break;
        default:
          jj_la1[14] = jj_gen;
          ;
        }
        break;
      default:
        jj_la1[15] = jj_gen;
        ;
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MANIFEST:
        t = jj_consume_token(MANIFEST);
        label_9:
        while (true) {
          jj_consume_token(WS);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case WS:
            ;
            break;
          default:
            jj_la1[16] = jj_gen;
            break label_9;
          }
        }
        u = Define();
        break;
      default:
        jj_la1[17] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
        PPToken pt=new PPToken(t);
        if (isDef(pt)==false) {
            if (u!=null&&v!=null) {
                PPToken pv=new PPToken(v);
                setMacro(pt,dargs,pv);
                printCommentedLines(emitExecSwitch, "#define " + pt.image + "("+dargs+")  " + pv.image, "" + "DEFINED");
            } else if (u==null&&v==null) {
                setDef(pt);
                printCommentedLines(emitExecSwitch, "#define " + pt.image, "" + "DEFINED");
            } else if (v!=null) {
                PPToken pv=new PPToken(v);
                setDef(pt,pv);
                printCommentedLines(emitExecSwitch, "#define " + pt.image + "  " + pv.image, "" + "DEFINED");
            } else if (u!=null) {
                if (dargs != null) {
                    PPToken pv=new PPToken("");
                    setMacro(pt,dargs,pv);
                    printCommentedLines(emitExecSwitch, "#define " + pt.image + "("+dargs+")  " + pv.image, "" + "DEFINED");
                } else {
                    PPToken pu=new PPToken(u);
                    setDef(pt,pu);
                    printCommentedLines(emitExecSwitch, "#define " + pt.image + "  " + pu.image, "" + "DEFINED");
                }
            }
        } else {
            if (verboseLevel==5||verboseLevel==6) println("PreProcessor: "+curFileStackTop()+"'"+t.beginLine+": "+t.image+" aready defined. Undefine first.");
        }

        {if (true) return pt;}
    throw new Error("Missing return statement in function");
  }

  final public PPToken UnDef() throws ParseException {
                   Token t;
    t = jj_consume_token(CONSTITUENT);
        PPToken pt=new PPToken(t);
        if (isDef(pt)==true) {
            UnDefine(pt);
        }
        {if (true) return pt;}
    throw new Error("Missing return statement in function");
  }

  final public PPToken MacroArgs() throws ParseException {
                       Token t,u=null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MACROMV:
      t = jj_consume_token(MACROMV);
      break;
    case MACROMVTAG:
      t = jj_consume_token(MACROMVTAG);
      break;
    default:
      jj_la1[18] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
     {if (true) return new PPToken(t);}
    throw new Error("Missing return statement in function");
  }

  final public PPToken MacroVals() throws ParseException {
                       Token s,t,u=new Token();u.image="";
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case VALUES:
    case VALUESCMT:
    case MOREVAL:
    case QUOTED_VALUE:
      u = Values();
      break;
    case MACRORV:
    case MACRORVCMT:
    case MQUOTED_VALUE:
      label_10:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case MACRORV:
          t = jj_consume_token(MACRORV);
                                u.image+=t.image;
          break;
        case MACRORVCMT:
          t = jj_consume_token(MACRORVCMT);
                                                                      t.image="/";
          break;
        case MQUOTED_VALUE:
          t = jj_consume_token(MQUOTED_VALUE);
                                                                                                           u.image+="\u005c""+t.image+"\u005c"";
          break;
        default:
          jj_la1[19] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        if (jj_2_13(2)) {
          ;
        } else {
          break label_10;
        }
      }
      if (jj_2_15(2)) {
        label_11:
        while (true) {
          t = Values();
                                           u.image+=t.image;
          if (jj_2_14(2)) {
            ;
          } else {
            break label_11;
          }
        }
      } else {
        ;
      }
      break;
    default:
      jj_la1[20] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return new PPToken(u);}
    throw new Error("Missing return statement in function");
  }

  final public PPToken Pragma() throws ParseException {
 Token t;
    t = jj_consume_token(PRAGMA_EXPRN);
       PPToken pt = new PPToken(t);
       if (emitExecSwitch==true) println("#pragma " + defs.expand(t.image,true)); {if (true) return pt;}
    throw new Error("Missing return statement in function");
  }

  final public PPToken IfDef() throws ParseException {
 Token t;
    t = jj_consume_token(IFDEFED);
        PPToken pt=new PPToken(t);
        if (verboseLevel()==7) print(curFileStackTop()+"'"+t.beginLine+": "+t.image+": ");
        pt.setTruth(isDef(pt));
        {if (true) return pt;}
    throw new Error("Missing return statement in function");
  }

  final public PPToken IfDefExpr() throws ParseException {
 Token t;
    t = jj_consume_token(IFDEF_EXPRN);
        PPToken pt=new PPToken(t);
        if (verboseLevel()==7) print(curFileStackTop()+"'"+t.beginLine+": "+t.image+": ");
        pt.setTruth(isDef(pt));
        {if (true) return pt;}
    throw new Error("Missing return statement in function");
  }

  final public PPToken IfNDef() throws ParseException {
 Token t;
    t = jj_consume_token(IFNDEFED);
        PPToken pt=new PPToken(t);
        if (verboseLevel==6||verboseLevel==7) {
            print(curFileStackTop()+"'"+t.beginLine+" IFNDEF: ");
        }
        pt.setTruth(isNDef(pt));
        {if (true) return pt;}
    throw new Error("Missing return statement in function");
  }

  final public PPToken IfNDefExpr() throws ParseException {
 Token t;
    t = jj_consume_token(IFNDEF_EXPRN);
        PPToken pt=new PPToken(t);
        if (verboseLevel()==7) print(curFileStackTop()+"'"+t.beginLine+": "+t.image+": ");
        pt.setTruth(isNDef(pt));
        {if (true) return pt;}
    throw new Error("Missing return statement in function");
  }

  final public PPToken Error() throws ParseException {
 Token t;
    t = jj_consume_token(ERROR_EXPRN);
        if (emitExecSwitch==true) {
            addParseMessage(null, curFileStackTop()+"'"+t.beginLine+" Compiler Error:");
            addParseMessage(null, t.image);
        }
        {if (true) return new PPToken(t);}
    throw new Error("Missing return statement in function");
  }

  final public PPToken Warning() throws ParseException {
 Token t;
    t = jj_consume_token(WARNING_EXPRN);
        if (emitExecSwitch==true) {
            addParseMessage(null, curFileStackTop()+"'"+t.beginLine+" Warning: ");
            addParseMessage(null, t.image);
        }
        {if (true) return new PPToken(t);}
    throw new Error("Missing return statement in function");
  }

  final public PPToken Info() throws ParseException {
 Token t;
    t = jj_consume_token(INFO_EXPRN);
        if (emitExecSwitch==true) {
            Msg.info(this, curFileStackTop()+"'"+t.beginLine+" Info: ");
            Msg.info(this, t.image);
        }
        {if (true) return new PPToken(t);}
    throw new Error("Missing return statement in function");
  }

  final public PPToken EndIf() throws ParseException {
 Token t;
    t = jj_consume_token(ENDIF);
              {if (true) return new PPToken(t);}
    throw new Error("Missing return statement in function");
  }

  final public PPToken Else() throws ParseException {
 Token t;
    t = jj_consume_token(ELSE);
        {if (true) return new PPToken(t);}
    throw new Error("Missing return statement in function");
  }

  final public PPToken If() throws ParseException {
 Token t;
    t = jj_consume_token(IF);
        if (verboseLevel==6||verboseLevel==7) {
            print(curFileStackTop()+"'"+t.beginLine+" IF: ");
        }
        {if (true) return new PPToken(t);}
    throw new Error("Missing return statement in function");
  }

  final public PPToken ElIf() throws ParseException {
 Token t;
    t = jj_consume_token(ELIF);
        if (verboseLevel==6||verboseLevel==7) {
            print(curFileStackTop()+"'"+t.beginLine+" ElseIf: ");
        }
        {if (true) return new PPToken(t);}
    throw new Error("Missing return statement in function");
  }

  final public PPToken Values() throws ParseException {
 Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case VALUES:
      t = jj_consume_token(VALUES);
        t.kind = getNumericType(t.image);
      break;
    case QUOTED_VALUE:
      t = QuotedValue();
      break;
    case VALUESCMT:
      t = jj_consume_token(VALUESCMT);
      t.image = "/";
      break;
    case MOREVAL:
      t = jj_consume_token(MOREVAL);
      break;
    default:
      jj_la1[21] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        PPToken pt=new PPToken(t);
        pt.join();
        {if (true) return pt;}
    throw new Error("Missing return statement in function");
  }

  final public PPToken QuotedValue() throws ParseException {
 Token t,u;t=new Token();t.image="\u005c"";
    u = jj_consume_token(QUOTED_VALUE);
                     t.image+=u.image; t.image+="\u005c"";{if (true) return new PPToken(t);}
    throw new Error("Missing return statement in function");
  }

  final public PPToken Text() throws ParseException {
 Token u, nl, t = new Token(); PPToken buf = new PPToken(""); t.image="";
    if (jj_2_27(3)) {
      label_12:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case OUTER_TEXT:
          u = jj_consume_token(OUTER_TEXT);
                                    if (emitExecSwitch==true) buf.append(u.image,true); else buf.append("//// " + u.image, false);
          label_13:
          while (true) {
            if (jj_2_16(2)) {
              ;
            } else {
              break label_13;
            }
            nl = NewLines();
                                               if (emitExecSwitch==true) buf.append(nl.image,true); else buf.append((u.image.length() == 0 ? "//// " : "") + nl.image, false);
          }
          break;
        case OTHER_TEXT:
          u = jj_consume_token(OTHER_TEXT);
                                   if (emitExecSwitch==true)  buf.append(u.image,true); else buf.append("//// " + u.image, false);
          break;
        default:
          jj_la1[22] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        if (jj_2_17(2)) {
          u = NewLines();
                                  if (emitExecSwitch==true) buf.append(u.image,true); else buf.append("//// " + u.image, false);
        } else {
          ;
        }
        if (jj_2_18(2)) {
          u = QuotedText();
                                   if (emitExecSwitch==true)  buf.append(u.image,true); else buf.append("//// " + u.image, false);
        } else {
          ;
        }
        if (jj_2_20(2)) {
          u = jj_consume_token(OTHER_TEXT);
                                   if (emitExecSwitch==true)  buf.append(u.image, true); else buf.append("//// " + u.image, false);
          label_14:
          while (true) {
            if (jj_2_19(2)) {
              ;
            } else {
              break label_14;
            }
            u = NewLines();
                                   if (emitExecSwitch==true) buf.append(u.image, true); else buf.append("//// " + u.image, false);
          }
        } else {
          ;
        }
        if (jj_2_21(2)) {
          ;
        } else {
          break label_12;
        }
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OTHER_TEXT:
      case QUOTED_TEXT:
        label_15:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case QUOTED_TEXT:
            u = QuotedText();
                                   if (emitExecSwitch==true)  buf.append(u.image,true); else buf.append("//// " + u.image, false);
            if (jj_2_22(2)) {
              u = NewLines();
                                               if (emitExecSwitch==true) buf.append(u.image,true); else buf.append("//// " + u.image, false);
            } else {
              ;
            }
            break;
          case OTHER_TEXT:
            u = jj_consume_token(OTHER_TEXT);
                                   if (emitExecSwitch==true)  buf.append(u.image,true); else buf.append("//// " + u.image, false);
            break;
          default:
            jj_la1[23] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          if (jj_2_23(2)) {
            t = NewLines();
                                  if (emitExecSwitch==true) buf.append(t.image,true); else buf.append("//// " + u.image, false);
          } else {
            ;
          }
          if (jj_2_24(2)) {
            u = jj_consume_token(OTHER_TEXT);
                                   if (emitExecSwitch==true)  buf.append(u.image,true); else buf.append("//// " + u.image, false);
          } else {
            ;
          }
          if (jj_2_25(2)) {
            u = NewLines();
                                  if (emitExecSwitch==true) buf.append(u.image,true); else buf.append("//// " + u.image, false);
          } else {
            ;
          }
          if (jj_2_26(2)) {
            ;
          } else {
            break label_15;
          }
        }
        break;
      case EOLCMNTNL:
      case NEWLINE:
      case DIRLINE:
      case INCLINE:
      case PRGLINE:
      case IFDLINE:
      case IFNDLINE:
      case ERRLINE:
      case UNDLINE:
      case CONLINE:
      case LINLINE:
        u = NewLines();
                    if (emitExecSwitch==true) buf.append(u.image,true); else buf.append("//// " + u.image, false);
        break;
      default:
        jj_la1[24] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
        {if (true) return buf;}
    throw new Error("Missing return statement in function");
  }

  final public PPToken NewLines() throws ParseException {
 Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NEWLINE:
      t = jj_consume_token(NEWLINE);
      break;
    case EOLCMNTNL:
      // general newline
      //    t=<CMNTNL>   |    // newline coming from /* */  // stripped for now
          t = jj_consume_token(EOLCMNTNL);
      break;
    case ERRLINE:
      // newline coming from //
          t = jj_consume_token(ERRLINE);
      break;
    case LINLINE:
      t = jj_consume_token(LINLINE);
      break;
    case PRGLINE:
      t = jj_consume_token(PRGLINE);
      break;
    case IFDLINE:
      t = jj_consume_token(IFDLINE);
      break;
    case IFNDLINE:
      t = jj_consume_token(IFNDLINE);
      break;
    case DIRLINE:
      t = jj_consume_token(DIRLINE);
      break;
    case UNDLINE:
      t = jj_consume_token(UNDLINE);
      break;
    case CONLINE:
      t = jj_consume_token(CONLINE);
      break;
    case INCLINE:
      t = jj_consume_token(INCLINE);
      break;
    default:
      jj_la1[25] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
       {if (true) return new PPToken(t);}
    throw new Error("Missing return statement in function");
  }

  final public PPToken QuotedText() throws ParseException {
 Token u;
    u = jj_consume_token(QUOTED_TEXT);
      {if (true) return new PPToken(u);}
    throw new Error("Missing return statement in function");
  }

  final public PPToken CompoundConditionalExpression() throws ParseException {
 PPToken t,i,e;
    if (jj_2_29(2)) {
      t = ConditionalExpression();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IF:
      case ELSE:
      case NOT:
      case DEFINED:
      case HASINCLUDE:
      case HASINCLUDENEXT:
      case OPTIONED:
      case MINUS:
      case PLUS:
      case NUMERIC:
      case FP_NUMERIC:
      case ITEM:
      case BEGITEM:
        if (jj_2_28(2)) {
          t = CompoundOrExpression();
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case IF:
          case ELSE:
          case NOT:
          case DEFINED:
          case HASINCLUDE:
          case HASINCLUDENEXT:
          case OPTIONED:
          case MINUS:
          case PLUS:
          case NUMERIC:
          case FP_NUMERIC:
          case ITEM:
          case BEGITEM:
            t = CompoundAndExpression();
            break;
          default:
            jj_la1[26] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
      default:
        jj_la1[27] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return new PPToken(t);}
    throw new Error("Missing return statement in function");
  }

  final public PPToken CompoundAndExpression() throws ParseException {
 PPToken t,u,v;
    t = ConditionalExpression();
    label_16:
    while (true) {
      if (jj_2_30(2)) {
        ;
      } else {
        break label_16;
      }
      u = LogAnd();
            if (verboseLevel()==7) print(u.image);
      v = ConditionalExpression();
            t.setTruth(t.getTruth()==true&&v.getTruth()==true);
            if (verboseLevel()==7) print(": ");
    }
            {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public PPToken CompoundOrExpression() throws ParseException {
 PPToken t,u,v;
    t = ConditionalExpression();
    label_17:
    while (true) {
      if (jj_2_31(2)) {
        ;
      } else {
        break label_17;
      }
      u = LogOr();
            if (verboseLevel()==7) print(u.image);
      v = ConditionalExpression();
            t.setTruth(t.getTruth()==true||v.getTruth()==true);
            if (verboseLevel()==7) print(": ");
    }
            {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public PPToken ConditionalExpression() throws ParseException {
 PPToken t,u,i,e;
    t = LogicalOrExpression();
    label_18:
    while (true) {
      if (jj_2_32(2)) {
        ;
      } else {
        break label_18;
      }
      u = Qmark();
      i = LogicalOrExpression();
      u = ElseMark();
      e = LogicalOrExpression();
         if (t.getTruth()==true) t=i; else t=e;
    }
     {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public PPToken LogicalOrExpression() throws ParseException {
 PPToken t,u,v;
    t = LogicalAndExpression();
    label_19:
    while (true) {
      if (jj_2_33(2)) {
        ;
      } else {
        break label_19;
      }
      u = LogOr();
          if (verboseLevel()==7) print(u.image);
      v = LogicalAndExpression();
          t.setTruth(t.getTruth()==true||v.getTruth()==true);
          if (verboseLevel()==7) print(": ");
    }
      {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public PPToken LogicalAndExpression() throws ParseException {
 PPToken t,u,v;
    t = EqualityExpression();
    label_20:
    while (true) {
      if (jj_2_34(2)) {
        ;
      } else {
        break label_20;
      }
      u = LogAnd();
           if (verboseLevel()==7) print(u.image);
      v = EqualityExpression();
           t.setTruth(t.getTruth()==true&&v.getTruth()==true);
           if (verboseLevel()==7) print(": ");
    }
      {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public PPToken EqualityExpression() throws ParseException {
 PPToken t,u,v;
    t = InEqualityExpression();
    label_21:
    while (true) {
      if (jj_2_35(2)) {
        ;
      } else {
        break label_21;
      }
      u = EqualTo();
           if (verboseLevel()==7) print(u.image);
      v = InEqualityExpression();
           try {
               t.setTruth(t.compareTo(v)==0);
           } catch (NumberFormatException exc) {
               t.setTruth(false);
           }
           if (verboseLevel()==7) print(": ");
    }
      {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public PPToken InEqualityExpression() throws ParseException {
 PPToken t,u,v;
    t = RelationalExpression();
    label_22:
    while (true) {
      if (jj_2_36(2)) {
        ;
      } else {
        break label_22;
      }
      u = NotEqualTo();
           if (verboseLevel()==7) print(u.image);
      v = RelationalExpression();
           try {
               t.setTruth(t.compareTo(v)!=0);
           } catch (NumberFormatException exc) {
               t.setTruth(true);
           }
           if (verboseLevel()==7) print(": ");
    }
      {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public PPToken RelationalExpression() throws ParseException {
 PPToken t,u,v;
    t = LessExpression();
    label_23:
    while (true) {
      if (jj_2_37(2)) {
        ;
      } else {
        break label_23;
      }
      u = LessThan();
           if (verboseLevel()==7) print(u.image);
      v = LessExpression();
           try {
               t.setTruth(t.compareTo(v)<0);
           } catch (NumberFormatException exc) {
               t.setTruth(false);
           }
           if (verboseLevel()==7) print(": ");
    }
      {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public PPToken LessExpression() throws ParseException {
 PPToken t,u,v;
    t = LessThanOrEqualExpression();
    label_24:
    while (true) {
      if (jj_2_38(2)) {
        ;
      } else {
        break label_24;
      }
      u = LessThan();
          if (verboseLevel()==7) print(u.image);
      v = LessThanOrEqualExpression();
          try {
               t.setTruth(t.compareTo(v)<0);
           } catch (NumberFormatException exc) {
               t.setTruth(false);
           }
          if (verboseLevel()==7) print(": ");
    }
        {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public PPToken LessThanOrEqualExpression() throws ParseException {
 PPToken t,u,v;
    t = GreaterThanOrEqualExpression();
    label_25:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LE:
        ;
        break;
      default:
        jj_la1[28] = jj_gen;
        break label_25;
      }
      u = LessThanOrEqual();
           if (verboseLevel()==7) print(u.image);
      v = GreaterThanOrEqualExpression();
           try {
               t.setTruth(t.compareTo(v)<=0);
           } catch (NumberFormatException exc) {
               t.setTruth(false);
           }
           if (verboseLevel()==7) print(": ");
    }
        {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public PPToken GreaterThanOrEqualExpression() throws ParseException {
 PPToken t,u,v;
    t = GreaterThanExpression();
    label_26:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case GE:
        ;
        break;
      default:
        jj_la1[29] = jj_gen;
        break label_26;
      }
      u = GreaterThanOrEqual();
           if (verboseLevel()==7) print(u.image);
      v = GreaterThanExpression();
           try {
               t.setTruth(t.compareTo(v)>=0);
           } catch (NumberFormatException exc) {
               t.setTruth(false);
           }
           if (verboseLevel()==7) print(": ");
    }
        {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public PPToken GreaterThanExpression() throws ParseException {
 PPToken t,u,v;
    t = Expression();
    label_27:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case GT:
        ;
        break;
      default:
        jj_la1[30] = jj_gen;
        break label_27;
      }
      u = GreaterThan();
        if (verboseLevel()==7) print(u.image);
      v = Expression();
        try {
            t.setTruth(t.compareTo(v)>0);
        } catch (NumberFormatException exc) {
            t.setTruth(false);
        }
        if (verboseLevel()==7) print(": ");
    }
     {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public PPToken LogOr() throws ParseException {
 Token t;PPToken pt;
    t = jj_consume_token(LOG_OR);
                {if (true) return new PPToken(t);}
    throw new Error("Missing return statement in function");
  }

  final public PPToken LogAnd() throws ParseException {
 Token t;PPToken pt;
    t = jj_consume_token(LOG_AND);
                 {if (true) return new PPToken(t);}
    throw new Error("Missing return statement in function");
  }

  final public PPToken EqualTo() throws ParseException {
 Token t;PPToken pt;
    t = jj_consume_token(EQ);
            {if (true) return new PPToken(t);}
    throw new Error("Missing return statement in function");
  }

  final public PPToken NotEqualTo() throws ParseException {
 Token t;PPToken pt;
    t = jj_consume_token(NEQ);
             {if (true) return new PPToken(t);}
    throw new Error("Missing return statement in function");
  }

  final public PPToken LessThan() throws ParseException {
 Token t;PPToken pt;
    t = jj_consume_token(LT);
            {if (true) return new PPToken(t);}
    throw new Error("Missing return statement in function");
  }

  final public PPToken LessThanOrEqual() throws ParseException {
 Token t;
    t = jj_consume_token(LE);
            {if (true) return new PPToken(t);}
    throw new Error("Missing return statement in function");
  }

  final public PPToken GreaterThan() throws ParseException {
 Token t;
    t = jj_consume_token(GT);
            {if (true) return new PPToken(t);}
    throw new Error("Missing return statement in function");
  }

  final public PPToken GreaterThanOrEqual() throws ParseException {
 Token t;
    t = jj_consume_token(GE);
            {if (true) return new PPToken(t);}
    throw new Error("Missing return statement in function");
  }

  final public PPToken Qmark() throws ParseException {
 Token t;
    t = jj_consume_token(QMARK);
               {if (true) return new PPToken(t);}
    throw new Error("Missing return statement in function");
  }

  final public PPToken ElseMark() throws ParseException {
 Token t;
    t = jj_consume_token(COLON);
               {if (true) return new PPToken(t);}
    throw new Error("Missing return statement in function");
  }

  final public PPToken Assertion() throws ParseException {
 Token t; PPToken pt=null; boolean checkDefined = false;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DEFINED:
      t = jj_consume_token(DEFINED);
                   if (verboseLevel()==7) print(t.image);
      pt = Expression();
       pt = new PPToken(pt);
       pt.setTruth(isDef(pt) || (pt.kind == FP_NUMERIC || pt.kind == NUMERIC));  // numbers are always defined
       {if (true) return pt;}
      break;
    case HASINCLUDE:
    case HASINCLUDENEXT:
    case OPTIONED:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OPTIONED:
        t = jj_consume_token(OPTIONED);
        break;
      case HASINCLUDE:
        t = jj_consume_token(HASINCLUDE);
        break;
      case HASINCLUDENEXT:
        t = jj_consume_token(HASINCLUDENEXT);
       if (verboseLevel()==7) print(t.image);
        break;
      default:
        jj_la1[31] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(BEGITEM);
      pt = Expression();
      jj_consume_token(ENDITEM);
       {if (true) return pt;}
      break;
    default:
      jj_la1[32] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public PPToken Expression() throws ParseException {
  PPToken obj = null;
    obj = InclusiveORExpression();
    {if (true) return obj;}
    throw new Error("Missing return statement in function");
  }

  final public PPToken InclusiveORExpression() throws ParseException {
    PPToken obj = null, obj2 = null; Token op=null;
    obj = ExclusiveORExpression();
    label_28:
    while (true) {
      if (jj_2_39(2)) {
        ;
      } else {
        break label_28;
      }
      op = jj_consume_token(OR);
      obj2 = ExclusiveORExpression();
                                                                                              obj = obj.computeBinary(op, obj2);
    }
                {if (true) return obj;}
    throw new Error("Missing return statement in function");
  }

  final public PPToken ExclusiveORExpression() throws ParseException {
    PPToken obj = null, obj2 = null; Token op=null;
    obj = ANDExpression();
    label_29:
    while (true) {
      if (jj_2_40(2)) {
        ;
      } else {
        break label_29;
      }
      op = jj_consume_token(XOR);
      obj2 = ANDExpression();
                                                                               obj = obj.computeBinary(op, obj2);
    }
                {if (true) return obj;}
    throw new Error("Missing return statement in function");
  }

  final public PPToken ANDExpression() throws ParseException {
    PPToken obj = null, obj2 = null; Token op=null;
    obj = ShiftExpression();
    label_30:
    while (true) {
      if (jj_2_41(2)) {
        ;
      } else {
        break label_30;
      }
      op = jj_consume_token(AND);
      obj2 = ShiftExpression();
                                                                                   obj = obj.computeBinary(op, obj2);
    }
                {if (true) return obj;}
    throw new Error("Missing return statement in function");
  }

  final public PPToken ShiftExpression() throws ParseException {
   PPToken obj = null, obj2 = null; Token op=null;
    obj = AdditiveExpression();
    label_31:
    while (true) {
      if (jj_2_42(2)) {
        ;
      } else {
        break label_31;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LSH:
        op = jj_consume_token(LSH);
        break;
      case RSH:
        op = jj_consume_token(RSH);
        break;
      default:
        jj_la1[33] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      obj2 = AdditiveExpression();
             obj = obj.computeBinary(op, obj2);
    }
                {if (true) return obj;}
    throw new Error("Missing return statement in function");
  }

  final public PPToken AdditiveExpression() throws ParseException {
    PPToken obj = null, obj2 = null; Token op=null;
    obj = MultiplicativeExpression();
    label_32:
    while (true) {
      if (jj_2_43(2)) {
        ;
      } else {
        break label_32;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
        op = jj_consume_token(PLUS);
        break;
      case MINUS:
        op = jj_consume_token(MINUS);
        break;
      default:
        jj_la1[34] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      obj2 = MultiplicativeExpression();
            obj = obj.computeBinary(op, obj2);
    }
                {if (true) return obj;}
    throw new Error("Missing return statement in function");
  }

  final public PPToken MultiplicativeExpression() throws ParseException {
    PPToken obj = null, obj2 = null; Token op=null;
    obj = UnaryExpression();
    label_33:
    while (true) {
      if (jj_2_44(2)) {
        ;
      } else {
        break label_33;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TIMES:
        op = jj_consume_token(TIMES);
        break;
      case DIVIDE:
        op = jj_consume_token(DIVIDE);
        break;
      case MOD:
        op = jj_consume_token(MOD);
        break;
      default:
        jj_la1[35] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      obj2 = UnaryExpression();
            obj = obj.computeBinary(op, obj2);
    }
                {if (true) return obj;}
    throw new Error("Missing return statement in function");
  }

  final public PPToken UnaryExpression() throws ParseException {
     PPToken obj = null;
     Token op = null;
    if (jj_2_45(3)) {
      obj = LogNegation();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
        jj_consume_token(PLUS);
        obj = LogNegation();
        break;
      case MINUS:
        op = jj_consume_token(MINUS);
        obj = LogNegation();
                                             obj = obj.computeUnary(op);
        break;
      default:
        jj_la1[36] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
                {if (true) return obj;}
    throw new Error("Missing return statement in function");
  }

  final public PPToken LogNegation() throws ParseException {
 Token t; PPToken pt=null; boolean negate=false;
    label_34:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NOT:
        ;
        break;
      default:
        jj_la1[37] = jj_gen;
        break label_34;
      }
      t = jj_consume_token(NOT);
         negate = true;
         if (verboseLevel()==7) print(t.image);
    }
    pt = ValueExpression();
        if (negate==true) pt.setContra(true);
     {if (true) return pt;}
    throw new Error("Missing return statement in function");
  }

  final public PPToken ValueExpression() throws ParseException {
 Token t;Token v;PPToken pt;PPToken tv=null;
 Token u=null;Vector dargs = new Vector();
    if (jj_2_47(2)) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NUMERIC:
        t = jj_consume_token(NUMERIC);
        break;
      case FP_NUMERIC:
        t = jj_consume_token(FP_NUMERIC);
        break;
      case ELSE:
        t = jj_consume_token(ELSE);
        break;
      case IF:
        t = jj_consume_token(IF);
        break;
      default:
        jj_la1[38] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
        if (verboseLevel()==7) print(t.image);
        pt=new PPToken(t);
        if (pt.compareToZero()==0) pt.setTruth(false);
        else pt.setTruth(true);
        {if (true) return pt;}
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BEGITEM:
        jj_consume_token(BEGITEM);
        pt = CompoundConditionalExpression();
        jj_consume_token(ENDITEM);
        {if (true) return pt;}
        break;
      case DEFINED:
      case HASINCLUDE:
      case HASINCLUDENEXT:
      case OPTIONED:
        pt = Assertion();
        {if (true) return pt;}
        break;
      case ITEM:
        t = jj_consume_token(ITEM);
        if (jj_2_46(4)) {
          jj_consume_token(BEGITEM);
          label_35:
          while (true) {
            tv = Expression();
                                                            dargs.add(tv);
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case IF:
            case ELSE:
            case NOT:
            case DEFINED:
            case HASINCLUDE:
            case HASINCLUDENEXT:
            case OPTIONED:
            case MINUS:
            case PLUS:
            case NUMERIC:
            case FP_NUMERIC:
            case ITEM:
            case BEGITEM:
              ;
              break;
            default:
              jj_la1[39] = jj_gen;
              break label_35;
            }
          }
          jj_consume_token(ENDITEM);
        } else {
          ;
        }
        if (verboseLevel()==7) print(t.image);
        pt=new PPToken(t);
        if (dargs.size() > 0) {
            pt.image += "(";
            Enumeration<PPToken> denum = dargs.elements();
            int index = 0;
            while (denum.hasMoreElements()) {
                PPToken atok = (PPToken) denum.nextElement();
                if (index++ != 0) {
                        pt.image += ",";
                }
                pt.image += atok.image;
            }
            pt.image += ")";

            pt.image = defs.expand(pt.image, true);

            // The expanded macro text can't be injected into the parse stream
            // try parsing the expression with an internal simple expression
            // parser that can handle equality expressions
                        Long val = AddressEvaluator.evaluateToLong(pt.image);
                        if (val != null) {
                            pt.image = val.toString();
                                pt.kind = NUMERIC;
                                pt.setTruth(true);
                                if (val == 0) {
                                        pt.setTruth(false);
                                }
                                {if (true) return pt;}
                        }
        }
        pt.setTruth(isDef(pt));
        if (pt.getTruth()) {
            tv = getDef(pt);
            if (!pt.image.equals(tv.image)) {
                tv.image = defs.expand(tv.image, true);
                tv.kind = getNumericType(tv.image);
            }

                        Long val = AddressEvaluator.evaluateToLong(tv.image);
                        pt.setTruth(true);
                        if (val != null) {
                                pt.image = val.toString();
                                pt.kind = NUMERIC;
                                if (val == 0) {
                                        pt.setTruth(false);
                                }
                        }
                }
//        if (pt.getTruth()==true) tv =(PPToken) getDef(pt);
//        if (tv!=null) {
//            tv.beginLine=t.beginLine; return tv;
//        } else return pt;
                {if (true) return pt;}
        break;
      default:
        jj_la1[40] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

  private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_10(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  private boolean jj_2_11(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_11(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  private boolean jj_2_12(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_12(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  private boolean jj_2_13(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_13(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  private boolean jj_2_14(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_14(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  private boolean jj_2_15(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_15(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  private boolean jj_2_16(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_16(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  private boolean jj_2_17(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_17(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(16, xla); }
  }

  private boolean jj_2_18(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_18(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(17, xla); }
  }

  private boolean jj_2_19(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_19(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(18, xla); }
  }

  private boolean jj_2_20(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_20(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(19, xla); }
  }

  private boolean jj_2_21(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_21(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(20, xla); }
  }

  private boolean jj_2_22(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_22(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(21, xla); }
  }

  private boolean jj_2_23(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_23(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(22, xla); }
  }

  private boolean jj_2_24(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_24(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(23, xla); }
  }

  private boolean jj_2_25(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_25(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(24, xla); }
  }

  private boolean jj_2_26(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_26(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(25, xla); }
  }

  private boolean jj_2_27(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_27(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(26, xla); }
  }

  private boolean jj_2_28(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_28(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(27, xla); }
  }

  private boolean jj_2_29(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_29(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(28, xla); }
  }

  private boolean jj_2_30(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_30(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(29, xla); }
  }

  private boolean jj_2_31(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_31(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(30, xla); }
  }

  private boolean jj_2_32(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_32(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(31, xla); }
  }

  private boolean jj_2_33(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_33(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(32, xla); }
  }

  private boolean jj_2_34(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_34(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(33, xla); }
  }

  private boolean jj_2_35(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_35(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(34, xla); }
  }

  private boolean jj_2_36(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_36(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(35, xla); }
  }

  private boolean jj_2_37(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_37(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(36, xla); }
  }

  private boolean jj_2_38(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_38(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(37, xla); }
  }

  private boolean jj_2_39(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_39(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(38, xla); }
  }

  private boolean jj_2_40(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_40(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(39, xla); }
  }

  private boolean jj_2_41(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_41(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(40, xla); }
  }

  private boolean jj_2_42(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_42(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(41, xla); }
  }

  private boolean jj_2_43(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_43(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(42, xla); }
  }

  private boolean jj_2_44(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_44(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(43, xla); }
  }

  private boolean jj_2_45(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_45(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(44, xla); }
  }

  private boolean jj_2_46(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_46(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(45, xla); }
  }

  private boolean jj_2_47(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_47(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(46, xla); }
  }

  private boolean jj_3R_56() {
    if (jj_3R_57()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_31()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_47() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(119)) {
    jj_scanpos = xsp;
    if (jj_scan_token(120)) {
    jj_scanpos = xsp;
    if (jj_scan_token(90)) {
    jj_scanpos = xsp;
    if (jj_scan_token(88)) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_97() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_47()) {
    jj_scanpos = xsp;
    if (jj_3R_110()) {
    jj_scanpos = xsp;
    if (jj_3R_111()) {
    jj_scanpos = xsp;
    if (jj_3R_112()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_145() {
    if (jj_3R_152()) return true;
    return false;
  }

  private boolean jj_3_30() {
    if (jj_3R_58()) return true;
    if (jj_3R_57()) return true;
    return false;
  }

  private boolean jj_3R_152() {
    if (jj_3R_57()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_30()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_104() {
    if (jj_3R_123()) return true;
    return false;
  }

  private boolean jj_3R_96() {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3_28() {
    if (jj_3R_56()) return true;
    return false;
  }

  private boolean jj_3R_77() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_96()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_97()) return true;
    return false;
  }

  private boolean jj_3R_135() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_28()) {
    jj_scanpos = xsp;
    if (jj_3R_145()) return true;
    }
    return false;
  }

  private boolean jj_3R_95() {
    if (jj_scan_token(MINUS)) return true;
    if (jj_3R_77()) return true;
    return false;
  }

  private boolean jj_3_45() {
    if (jj_3R_77()) return true;
    return false;
  }

  private boolean jj_3_29() {
    if (jj_3R_57()) return true;
    return false;
  }

  private boolean jj_3R_94() {
    if (jj_scan_token(PLUS)) return true;
    if (jj_3R_77()) return true;
    return false;
  }

  private boolean jj_3R_126() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_29()) {
    jj_scanpos = xsp;
    if (jj_3R_135()) return true;
    }
    return false;
  }

  private boolean jj_3R_103() {
    if (jj_3R_122()) return true;
    return false;
  }

  private boolean jj_3R_51() {
    if (jj_scan_token(QUOTED_TEXT)) return true;
    return false;
  }

  private boolean jj_3R_76() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_45()) {
    jj_scanpos = xsp;
    if (jj_3R_94()) {
    jj_scanpos = xsp;
    if (jj_3R_95()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_102() {
    if (jj_3R_120()) return true;
    if (jj_3R_121()) return true;
    return false;
  }

  private boolean jj_3_44() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(116)) {
    jj_scanpos = xsp;
    if (jj_scan_token(114)) {
    jj_scanpos = xsp;
    if (jj_scan_token(115)) return true;
    }
    }
    if (jj_3R_76()) return true;
    return false;
  }

  private boolean jj_3R_75() {
    if (jj_3R_76()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_44()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_101() {
    if (jj_3R_118()) return true;
    if (jj_3R_119()) return true;
    return false;
  }

  private boolean jj_3R_55() {
    if (jj_scan_token(OTHER_TEXT)) return true;
    return false;
  }

  private boolean jj_3R_50() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(69)) {
    jj_scanpos = xsp;
    if (jj_scan_token(7)) {
    jj_scanpos = xsp;
    if (jj_scan_token(159)) {
    jj_scanpos = xsp;
    if (jj_scan_token(177)) {
    jj_scanpos = xsp;
    if (jj_scan_token(148)) {
    jj_scanpos = xsp;
    if (jj_scan_token(151)) {
    jj_scanpos = xsp;
    if (jj_scan_token(155)) {
    jj_scanpos = xsp;
    if (jj_scan_token(124)) {
    jj_scanpos = xsp;
    if (jj_scan_token(169)) {
    jj_scanpos = xsp;
    if (jj_scan_token(176)) {
    jj_scanpos = xsp;
    if (jj_scan_token(137)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_22() {
    if (jj_3R_50()) return true;
    return false;
  }

  private boolean jj_3R_54() {
    if (jj_3R_51()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_22()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_43() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(113)) {
    jj_scanpos = xsp;
    if (jj_scan_token(112)) return true;
    }
    if (jj_3R_75()) return true;
    return false;
  }

  private boolean jj_3_41() {
    if (jj_scan_token(AND)) return true;
    if (jj_3R_73()) return true;
    return false;
  }

  private boolean jj_3R_53() {
    if (jj_scan_token(OTHER_TEXT)) return true;
    return false;
  }

  private boolean jj_3_16() {
    if (jj_3R_50()) return true;
    return false;
  }

  private boolean jj_3_25() {
    if (jj_3R_50()) return true;
    return false;
  }

  private boolean jj_3R_84() {
    if (jj_3R_50()) return true;
    return false;
  }

  private boolean jj_3R_74() {
    if (jj_3R_75()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_43()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_24() {
    if (jj_scan_token(OTHER_TEXT)) return true;
    return false;
  }

  private boolean jj_3R_52() {
    if (jj_scan_token(OUTER_TEXT)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_16()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_23() {
    if (jj_3R_50()) return true;
    return false;
  }

  private boolean jj_3_19() {
    if (jj_3R_50()) return true;
    return false;
  }

  private boolean jj_3_26() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_54()) {
    jj_scanpos = xsp;
    if (jj_3R_55()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3_23()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_24()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_25()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_83() {
    Token xsp;
    if (jj_3_26()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_26()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_100() {
    if (jj_3R_116()) return true;
    if (jj_3R_117()) return true;
    return false;
  }

  private boolean jj_3_20() {
    if (jj_scan_token(OTHER_TEXT)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_19()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_18() {
    if (jj_3R_51()) return true;
    return false;
  }

  private boolean jj_3_40() {
    if (jj_scan_token(XOR)) return true;
    if (jj_3R_72()) return true;
    return false;
  }

  private boolean jj_3_17() {
    if (jj_3R_50()) return true;
    return false;
  }

  private boolean jj_3_42() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(110)) {
    jj_scanpos = xsp;
    if (jj_scan_token(111)) return true;
    }
    if (jj_3R_74()) return true;
    return false;
  }

  private boolean jj_3_39() {
    if (jj_scan_token(OR)) return true;
    if (jj_3R_71()) return true;
    return false;
  }

  private boolean jj_3R_73() {
    if (jj_3R_74()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_42()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_21() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_52()) {
    jj_scanpos = xsp;
    if (jj_3R_53()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3_17()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_18()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_20()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_27() {
    Token xsp;
    if (jj_3_21()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_21()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_99() {
    if (jj_3R_114()) return true;
    if (jj_3R_115()) return true;
    return false;
  }

  private boolean jj_3R_80() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_99()) {
    jj_scanpos = xsp;
    if (jj_3R_100()) {
    jj_scanpos = xsp;
    if (jj_3R_101()) {
    jj_scanpos = xsp;
    if (jj_3R_102()) {
    jj_scanpos = xsp;
    if (jj_3R_103()) {
    jj_scanpos = xsp;
    if (jj_3R_104()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_39() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_27()) {
    jj_scanpos = xsp;
    if (jj_3R_83()) {
    jj_scanpos = xsp;
    if (jj_3R_84()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_72() {
    if (jj_3R_73()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_41()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_108() {
    if (jj_scan_token(QUOTED_VALUE)) return true;
    return false;
  }

  private boolean jj_3R_37() {
    if (jj_3R_80()) return true;
    return false;
  }

  private boolean jj_3R_71() {
    if (jj_3R_72()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_40()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_146() {
    if (jj_scan_token(HASINCLUDENEXT)) return true;
    return false;
  }

  private boolean jj_3R_125() {
    if (jj_scan_token(0)) return true;
    return false;
  }

  private boolean jj_3_5() {
    if (jj_3R_37()) return true;
    return false;
  }

  private boolean jj_3R_92() {
    if (jj_scan_token(VALUESCMT)) return true;
    return false;
  }

  private boolean jj_3R_134() {
    if (jj_3R_144()) return true;
    return false;
  }

  private boolean jj_3R_91() {
    if (jj_3R_108()) return true;
    return false;
  }

  private boolean jj_3R_133() {
    if (jj_3R_143()) return true;
    return false;
  }

  private boolean jj_3R_132() {
    if (jj_3R_142()) return true;
    return false;
  }

  private boolean jj_3R_131() {
    if (jj_3R_141()) return true;
    return false;
  }

  private boolean jj_3R_90() {
    if (jj_scan_token(VALUES)) return true;
    return false;
  }

  private boolean jj_3R_113() {
    if (jj_3R_71()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_39()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_130() {
    if (jj_3R_140()) return true;
    return false;
  }

  private boolean jj_3R_49() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_90()) {
    jj_scanpos = xsp;
    if (jj_3R_91()) {
    jj_scanpos = xsp;
    if (jj_3R_92()) {
    jj_scanpos = xsp;
    if (jj_scan_token(190)) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_129() {
    if (jj_3R_139()) return true;
    return false;
  }

  private boolean jj_3R_128() {
    if (jj_3R_138()) return true;
    return false;
  }

  private boolean jj_3_7() {
    if (jj_3R_40()) return true;
    return false;
  }

  private boolean jj_3R_105() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_124()) {
    jj_scanpos = xsp;
    if (jj_3R_125()) return true;
    }
    return false;
  }

  private boolean jj_3R_124() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_7()) {
    jj_scanpos = xsp;
    if (jj_3R_128()) {
    jj_scanpos = xsp;
    if (jj_3R_129()) {
    jj_scanpos = xsp;
    if (jj_3R_130()) {
    jj_scanpos = xsp;
    if (jj_3R_131()) {
    jj_scanpos = xsp;
    if (jj_3R_132()) {
    jj_scanpos = xsp;
    if (jj_3R_133()) {
    jj_scanpos = xsp;
    if (jj_3R_134()) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_82() {
    if (jj_3R_105()) return true;
    return false;
  }

  private boolean jj_3_6() {
    Token xsp;
    if (jj_3_5()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_5()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_116() {
    if (jj_scan_token(ELIF)) return true;
    return false;
  }

  private boolean jj_3R_98() {
    if (jj_3R_113()) return true;
    return false;
  }

  private boolean jj_3R_114() {
    if (jj_scan_token(IF)) return true;
    return false;
  }

  private boolean jj_3_4() {
    if (jj_3R_39()) return true;
    return false;
  }

  private boolean jj_3R_38() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_81()) {
    jj_scanpos = xsp;
    if (jj_3_6()) {
    jj_scanpos = xsp;
    if (jj_3R_82()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_81() {
    Token xsp;
    if (jj_3_4()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_4()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_137() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(98)) {
    jj_scanpos = xsp;
    if (jj_scan_token(96)) {
    jj_scanpos = xsp;
    if (jj_3R_146()) return true;
    }
    }
    if (jj_scan_token(BEGITEM)) return true;
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3_2() {
    if (jj_3R_37()) return true;
    return false;
  }

  private boolean jj_3R_122() {
    if (jj_scan_token(ELSE)) return true;
    return false;
  }

  private boolean jj_3R_79() {
    Token xsp;
    if (jj_3_2()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_2()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_36() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_3()) {
    jj_scanpos = xsp;
    if (jj_3R_79()) return true;
    }
    return false;
  }

  private boolean jj_3_3() {
    if (jj_3R_38()) return true;
    return false;
  }

  private boolean jj_3R_136() {
    if (jj_scan_token(DEFINED)) return true;
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_127() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_136()) {
    jj_scanpos = xsp;
    if (jj_3R_137()) return true;
    }
    return false;
  }

  private boolean jj_3R_123() {
    if (jj_scan_token(ENDIF)) return true;
    return false;
  }

  private boolean jj_3_1() {
    if (jj_3R_36()) return true;
    return false;
  }

  private boolean jj_3R_48() {
    if (jj_scan_token(MQUOTED_VALUE)) return true;
    return false;
  }

  private boolean jj_3R_143() {
    if (jj_scan_token(INFO_EXPRN)) return true;
    return false;
  }

  private boolean jj_3R_60() {
    if (jj_scan_token(QMARK)) return true;
    return false;
  }

  private boolean jj_3R_157() {
    if (jj_scan_token(GE)) return true;
    return false;
  }

  private boolean jj_3R_142() {
    if (jj_scan_token(WARNING_EXPRN)) return true;
    return false;
  }

  private boolean jj_3R_158() {
    if (jj_scan_token(GT)) return true;
    return false;
  }

  private boolean jj_3R_155() {
    if (jj_scan_token(LE)) return true;
    return false;
  }

  private boolean jj_3R_141() {
    if (jj_scan_token(ERROR_EXPRN)) return true;
    return false;
  }

  private boolean jj_3R_68() {
    if (jj_scan_token(LT)) return true;
    return false;
  }

  private boolean jj_3R_42() {
    if (jj_3R_87()) return true;
    return false;
  }

  private boolean jj_3R_47() {
    if (jj_scan_token(MACRORVCMT)) return true;
    return false;
  }

  private boolean jj_3R_121() {
    if (jj_scan_token(IFNDEF_EXPRN)) return true;
    return false;
  }

  private boolean jj_3R_66() {
    if (jj_scan_token(NEQ)) return true;
    return false;
  }

  private boolean jj_3R_64() {
    if (jj_scan_token(EQ)) return true;
    return false;
  }

  private boolean jj_3R_120() {
    if (jj_scan_token(IFNDEFED)) return true;
    return false;
  }

  private boolean jj_3R_58() {
    if (jj_scan_token(LOG_AND)) return true;
    return false;
  }

  private boolean jj_3R_59() {
    if (jj_scan_token(LOG_OR)) return true;
    return false;
  }

  private boolean jj_3R_119() {
    if (jj_scan_token(IFDEF_EXPRN)) return true;
    return false;
  }

  private boolean jj_3_14() {
    if (jj_3R_49()) return true;
    return false;
  }

  private boolean jj_3R_46() {
    if (jj_scan_token(MACRORV)) return true;
    return false;
  }

  private boolean jj_3R_118() {
    if (jj_scan_token(IFDEFED)) return true;
    return false;
  }

  private boolean jj_3R_156() {
    if (jj_3R_158()) return true;
    return false;
  }

  private boolean jj_3R_109() {
    if (jj_3R_98()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_156()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_140() {
    if (jj_scan_token(PRAGMA_EXPRN)) return true;
    return false;
  }

  private boolean jj_3_15() {
    Token xsp;
    if (jj_3_14()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_14()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_13() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_46()) {
    jj_scanpos = xsp;
    if (jj_3R_47()) {
    jj_scanpos = xsp;
    if (jj_3R_48()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_107() {
    Token xsp;
    if (jj_3_13()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_13()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3_15()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_86() {
    if (jj_3R_44()) return true;
    return false;
  }

  private boolean jj_3R_106() {
    if (jj_3R_49()) return true;
    return false;
  }

  private boolean jj_3R_87() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_106()) {
    jj_scanpos = xsp;
    if (jj_3R_107()) return true;
    }
    return false;
  }

  private boolean jj_3R_154() {
    if (jj_3R_157()) return true;
    return false;
  }

  private boolean jj_3R_93() {
    if (jj_3R_109()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_154()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_44() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(195)) {
    jj_scanpos = xsp;
    if (jj_scan_token(196)) return true;
    }
    return false;
  }

  private boolean jj_3R_153() {
    if (jj_3R_155()) return true;
    return false;
  }

  private boolean jj_3R_139() {
    if (jj_scan_token(CONSTITUENT)) return true;
    return false;
  }

  private boolean jj_3R_70() {
    if (jj_3R_93()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_153()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_38() {
    if (jj_3R_68()) return true;
    if (jj_3R_70()) return true;
    return false;
  }

  private boolean jj_3R_69() {
    if (jj_3R_70()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_38()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_89() {
    if (jj_3R_44()) return true;
    return false;
  }

  private boolean jj_3R_45() {
    Token xsp;
    if (jj_3R_89()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_89()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_85() {
    if (jj_scan_token(MANIFEST)) return true;
    Token xsp;
    if (jj_scan_token(67)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(67)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_37() {
    if (jj_3R_68()) return true;
    if (jj_3R_69()) return true;
    return false;
  }

  private boolean jj_3_9() {
    if (jj_3R_40()) return true;
    return false;
  }

  private boolean jj_3_12() {
    if (jj_scan_token(MANIFEST)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_45()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_67() {
    if (jj_3R_69()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_37()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_41() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_86()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(MACROARGSEND)) return true;
    return false;
  }

  private boolean jj_3_11() {
    if (jj_scan_token(MANIFEST)) return true;
    if (jj_3R_44()) return true;
    return false;
  }

  private boolean jj_3R_88() {
    if (jj_3R_87()) return true;
    return false;
  }

  private boolean jj_3R_43() {
    Token xsp;
    if (jj_3R_88()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_88()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_8() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_41()) {
    jj_scanpos = xsp;
    if (jj_3R_42()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_43()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_36() {
    if (jj_3R_66()) return true;
    if (jj_3R_67()) return true;
    return false;
  }

  private boolean jj_3_10() {
    if (jj_scan_token(MANIFEST)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_8()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_65() {
    if (jj_3R_67()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_36()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_40() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_10()) {
    jj_scanpos = xsp;
    if (jj_3_11()) {
    jj_scanpos = xsp;
    if (jj_3_12()) {
    jj_scanpos = xsp;
    if (jj_3R_85()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_151() {
    if (jj_scan_token(NUMERIC)) return true;
    return false;
  }

  private boolean jj_3_35() {
    if (jj_3R_64()) return true;
    if (jj_3R_65()) return true;
    return false;
  }

  private boolean jj_3R_144() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(178)) {
    jj_scanpos = xsp;
    if (jj_3R_151()) return true;
    }
    return false;
  }

  private boolean jj_3R_63() {
    if (jj_3R_65()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_35()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_78() {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3_34() {
    if (jj_3R_58()) return true;
    if (jj_3R_63()) return true;
    return false;
  }

  private boolean jj_3R_62() {
    if (jj_3R_63()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_34()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_150() {
    if (jj_scan_token(XSYMLINKPATH)) return true;
    return false;
  }

  private boolean jj_3R_149() {
    if (jj_scan_token(MACEXPPATH)) return true;
    return false;
  }

  private boolean jj_3_33() {
    if (jj_3R_59()) return true;
    if (jj_3R_62()) return true;
    return false;
  }

  private boolean jj_3R_61() {
    if (jj_3R_62()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_33()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_46() {
    if (jj_scan_token(BEGITEM)) return true;
    Token xsp;
    if (jj_3R_78()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_78()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(ENDITEM)) return true;
    return false;
  }

  private boolean jj_3R_148() {
    if (jj_scan_token(STANDARD)) return true;
    return false;
  }

  private boolean jj_3_32() {
    if (jj_3R_60()) return true;
    if (jj_3R_61()) return true;
    return false;
  }

  private boolean jj_3R_147() {
    if (jj_scan_token(RELATIVE)) return true;
    return false;
  }

  private boolean jj_3R_138() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_147()) {
    jj_scanpos = xsp;
    if (jj_3R_148()) {
    jj_scanpos = xsp;
    if (jj_3R_149()) {
    jj_scanpos = xsp;
    if (jj_3R_150()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_57() {
    if (jj_3R_61()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_32()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_112() {
    if (jj_scan_token(ITEM)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_46()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_117() {
    if (jj_3R_126()) return true;
    return false;
  }

  private boolean jj_3R_111() {
    if (jj_3R_127()) return true;
    return false;
  }

  private boolean jj_3_31() {
    if (jj_3R_59()) return true;
    if (jj_3R_57()) return true;
    return false;
  }

  private boolean jj_3R_110() {
    if (jj_scan_token(BEGITEM)) return true;
    if (jj_3R_126()) return true;
    if (jj_scan_token(ENDITEM)) return true;
    return false;
  }

  private boolean jj_3R_115() {
    if (jj_3R_126()) return true;
    return false;
  }

  /** Generated Token Manager. */
  public PreProcessorTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[41];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static private int[] jj_la1_4;
  static private int[] jj_la1_5;
  static private int[] jj_la1_6;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
      jj_la1_init_2();
      jj_la1_init_3();
      jj_la1_init_4();
      jj_la1_init_5();
      jj_la1_init_6();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x81,0x0,0x80,0x1,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_2() {
      jj_la1_2 = new int[] {0x3f0000f0,0x3f000000,0xf0,0x0,0x0,0x0,0x3f000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x50,0xc0,0xe0,0x20,0xc5000000,0xc5000000,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x40000000,0x5000000,0xc5000000,0x80000000,};
   }
   private static void jj_la1_init_3() {
      jj_la1_3 = new int[] {0x10800000,0x0,0x10000000,0x800000,0x800000,0x800000,0x0,0x0,0x800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x10000000,0x7830007,0x7830007,0x80,0x100,0x40,0x7,0x7,0xc000,0x30000,0x1c0000,0x30000,0x0,0x1800000,0x7830007,0x6000007,};
   }
   private static void jj_la1_init_4() {
      jj_la1_4 = new int[] {0xc89d0700,0x0,0x88900200,0x400d0500,0x400d0500,0x400d0500,0x0,0x50500,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x88900200,0x88900200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_5() {
      jj_la1_5 = new int[] {0x78312,0x0,0x30200,0x48112,0x40112,0x48112,0x0,0x0,0x40000,0x0,0x70000000,0x70000000,0x70000000,0x0,0x70000000,0x0,0x0,0x8000,0x0,0x0,0x70000000,0x70000000,0x0,0x0,0x30200,0x30200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_6() {
      jj_la1_6 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x18,0x40603c,0x406004,0x406004,0x18,0x406004,0x18,0x0,0x0,0x18,0x406000,0x406004,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[47];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with InputStream. */
  public PreProcessor(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public PreProcessor(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new PreProcessorTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 41; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 41; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public PreProcessor(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new PreProcessorTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 41; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 41; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public PreProcessor(PreProcessorTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 41; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(PreProcessorTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 41; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      jj_entries_loop: for (java.util.Iterator<?> it = jj_expentries.iterator(); it.hasNext();) {
        int[] oldentry = (int[])(it.next());
        if (oldentry.length == jj_expentry.length) {
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              continue jj_entries_loop;
            }
          }
          jj_expentries.add(jj_expentry);
          break jj_entries_loop;
        }
      }
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[218];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 41; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
          if ((jj_la1_4[i] & (1<<j)) != 0) {
            la1tokens[128+j] = true;
          }
          if ((jj_la1_5[i] & (1<<j)) != 0) {
            la1tokens[160+j] = true;
          }
          if ((jj_la1_6[i] & (1<<j)) != 0) {
            la1tokens[192+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 218; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 47; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
            case 10: jj_3_11(); break;
            case 11: jj_3_12(); break;
            case 12: jj_3_13(); break;
            case 13: jj_3_14(); break;
            case 14: jj_3_15(); break;
            case 15: jj_3_16(); break;
            case 16: jj_3_17(); break;
            case 17: jj_3_18(); break;
            case 18: jj_3_19(); break;
            case 19: jj_3_20(); break;
            case 20: jj_3_21(); break;
            case 21: jj_3_22(); break;
            case 22: jj_3_23(); break;
            case 23: jj_3_24(); break;
            case 24: jj_3_25(); break;
            case 25: jj_3_26(); break;
            case 26: jj_3_27(); break;
            case 27: jj_3_28(); break;
            case 28: jj_3_29(); break;
            case 29: jj_3_30(); break;
            case 30: jj_3_31(); break;
            case 31: jj_3_32(); break;
            case 32: jj_3_33(); break;
            case 33: jj_3_34(); break;
            case 34: jj_3_35(); break;
            case 35: jj_3_36(); break;
            case 36: jj_3_37(); break;
            case 37: jj_3_38(); break;
            case 38: jj_3_39(); break;
            case 39: jj_3_40(); break;
            case 40: jj_3_41(); break;
            case 41: jj_3_42(); break;
            case 42: jj_3_43(); break;
            case 43: jj_3_44(); break;
            case 44: jj_3_45(); break;
            case 45: jj_3_46(); break;
            case 46: jj_3_47(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
