/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Format;

import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.OffsetInstruction;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Util.AnnotatedOutput;

public class Instruction10t
extends OffsetInstruction {
    public static final Instruction.InstructionFactory Factory = new Factory();
    private int targetAddressOffset;

    public Instruction10t(Opcode opcode, int offA) {
        super(opcode);
        this.targetAddressOffset = offA;
        if (this.targetAddressOffset == 0) {
            throw new RuntimeException("The address offset cannot be 0. Use goto/32 instead.");
        }
    }

    private Instruction10t(Opcode opcode, byte[] buffer, int bufferIndex) {
        super(opcode);
        assert (buffer[bufferIndex] == opcode.value);
        this.targetAddressOffset = buffer[bufferIndex + 1];
        assert (this.targetAddressOffset != 0);
    }

    @Override
    protected void writeInstruction(AnnotatedOutput out, int currentCodeAddress) {
        if (this.targetAddressOffset == 0) {
            throw new RuntimeException("The address offset cannot be 0. Use goto/32 instead");
        }
        if (this.targetAddressOffset < -128 || this.targetAddressOffset > 127) {
            throw new RuntimeException("The address offset is out of range. It must be in [-128,-1] or [1, 127]");
        }
        out.writeByte(this.opcode.value);
        out.writeByte(this.targetAddressOffset);
    }

    @Override
    public void updateTargetAddressOffset(int targetAddressOffset) {
        this.targetAddressOffset = targetAddressOffset;
    }

    @Override
    public Format getFormat() {
        return Format.Format10t;
    }

    @Override
    public int getTargetAddressOffset() {
        return this.targetAddressOffset;
    }

    private static class Factory
    implements Instruction.InstructionFactory {
        private Factory() {
        }

        @Override
        public Instruction makeInstruction(DexFile dexFile, Opcode opcode, byte[] buffer, int bufferIndex) {
            return new Instruction10t(opcode, buffer, bufferIndex);
        }
    }
}

