/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.gadp.server;

import generic.concurrent.io.IOResult;
import generic.concurrent.io.ProcessConsumer;
import ghidra.dbg.DebuggerModelFactory;
import ghidra.dbg.gadp.client.GadpClient;
import ghidra.dbg.gadp.client.GadpTcpDebuggerModelFactory;
import ghidra.dbg.util.ConfigurableFactory;
import ghidra.util.Msg;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.channels.AsynchronousByteChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;

public abstract class AbstractGadpLocalDebuggerModelFactory
implements DebuggerModelFactory {
    public static final boolean LOG_AGENT_STDOUT = true;
    protected String host = "localhost";
    @ConfigurableFactory.FactoryOption(value="Agent interface address")
    public final ConfigurableFactory.Property<String> agentAddressOption = ConfigurableFactory.Property.fromAccessors(String.class, this::getAgentAddress, this::setAgentAddress);
    protected int port = 0;
    @ConfigurableFactory.FactoryOption(value="Agent TCP port")
    public final ConfigurableFactory.Property<Integer> agentPortOption = ConfigurableFactory.Property.fromAccessors(Integer.TYPE, this::getAgentPort, this::setAgentPort);
    protected int jdwpPort = -1;
    @ConfigurableFactory.FactoryOption(value="Open agent's JDWP port (-1 to disable, 0 for ephemeral)")
    public final ConfigurableFactory.Property<Integer> jdwpPortOption = ConfigurableFactory.Property.fromAccessors(Integer.TYPE, this::getJdwpPort, this::setJdwpPort);
    protected boolean jdwpSuspend = false;
    @ConfigurableFactory.FactoryOption(value="Suspend for JDWP")
    public final ConfigurableFactory.Property<Boolean> jdwpSuspendOption = ConfigurableFactory.Property.fromAccessors(Boolean.TYPE, this::isJdwpSuspend, this::setJdwpSuspend);

    protected abstract String getThreadName();

    protected abstract void completeCommandLine(List<String> var1);

    public String getAgentAddress() {
        return this.host;
    }

    public void setAgentAddress(String host) {
        this.host = host;
    }

    public int getAgentPort() {
        return this.port;
    }

    public void setAgentPort(int port) {
        this.port = port;
    }

    public int getJdwpPort() {
        return this.jdwpPort;
    }

    public void setJdwpPort(int jdwpPort) {
        this.jdwpPort = jdwpPort;
    }

    public boolean isJdwpSuspend() {
        return this.jdwpSuspend;
    }

    public void setJdwpSuspend(boolean jdwpSuspend) {
        this.jdwpSuspend = jdwpSuspend;
    }

    public CompletableFuture<GadpClient> build() {
        AgentThread thread = new AgentThread();
        thread.start();
        return thread.ready.thenCompose(__ -> {
            AgentOwningGadpTcpDebuggerModelFactory factory = new AgentOwningGadpTcpDebuggerModelFactory(thread);
            factory.setAgentPort(thread.port);
            return factory.build();
        });
    }

    class AgentThread
    extends Thread {
        int port;
        Process process;
        CompletableFuture<Void> ready;

        public AgentThread() {
            super(AbstractGadpLocalDebuggerModelFactory.this.getThreadName());
            this.ready = new CompletableFuture();
        }

        @Override
        public void run() {
            try {
                String line;
                ProcessBuilder builder = new ProcessBuilder(new String[0]);
                ArrayList<String> cmd = new ArrayList<String>();
                cmd.add("java");
                cmd.addAll(List.of("-cp", System.getProperty("java.class.path")));
                if (AbstractGadpLocalDebuggerModelFactory.this.jdwpPort >= 0) {
                    cmd.add("-agentlib:jdwp=server=y,transport=dt_socket,address=" + AbstractGadpLocalDebuggerModelFactory.this.jdwpPort + ",suspend=" + (AbstractGadpLocalDebuggerModelFactory.this.jdwpSuspend ? "y" : "n"));
                }
                AbstractGadpLocalDebuggerModelFactory.this.completeCommandLine(cmd);
                builder.command(cmd);
                this.process = builder.start();
                InputStream errorStream = this.process.getErrorStream();
                Future errorFuture = ProcessConsumer.consume((InputStream)errorStream);
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
                while (null != (line = reader.readLine())) {
                    Msg.info((Object)this, (Object)("AGENT: " + line));
                    if (line.startsWith("GADP Server listening on ")) {
                        String[] parts = line.split(":");
                        this.port = Integer.parseInt(parts[parts.length - 1]);
                    }
                    if (!"GADP Server model ready".equals(line)) continue;
                    this.ready.complete(null);
                }
                if (!this.ready.isDone()) {
                    IOResult errorResult = (IOResult)errorFuture.get();
                    String errorMessage = errorResult.getOutputAsString();
                    if (errorMessage != null) {
                        this.ready.completeExceptionally(new RuntimeException("Agent terminated with error: " + errorMessage));
                    } else {
                        this.ready.completeExceptionally(new RuntimeException("Agent terminated unexpectedly"));
                    }
                }
            }
            catch (Throwable e) {
                this.ready.completeExceptionally(e);
            }
        }
    }

    static class AgentOwningGadpTcpDebuggerModelFactory
    extends GadpTcpDebuggerModelFactory {
        private final AgentThread agentThread;

        public AgentOwningGadpTcpDebuggerModelFactory(AgentThread agentThread) {
            this.agentThread = agentThread;
        }

        @Override
        protected GadpClient createClient(String description, AsynchronousByteChannel channel) {
            return new AgentOwningGadpClient(description, channel, this.agentThread);
        }
    }

    static class AgentOwningGadpClient
    extends GadpClient {
        private final AgentThread agentThread;

        public AgentOwningGadpClient(String description, AsynchronousByteChannel channel, AgentThread agentThread) {
            super(description, channel);
            this.agentThread = agentThread;
        }

        @Override
        public CompletableFuture<Void> close() {
            return super.close().whenComplete((v, e) -> {
                this.agentThread.process.destroy();
                this.agentThread.interrupt();
            });
        }
    }
}

