/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.UnableToSwingException;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.swing.SwingUtilities;
import utilities.util.reflection.ReflectionUtilities;

public class Swing {
    private static final String SWING_TIMEOUT_SECONDS_PROPERTY = Swing.class.getName().toLowerCase() + ".timeout.seconds";
    private static final int SWING_TIMEOUT_SECONDS_DEFAULT_VALUE = 20;
    private static final int SWING_TIMEOUT_SECONDS_VALUE = Swing.loadTimeout();
    private static final String SWING_RUN_ERROR_MSG = "Unexpected exception running a task in the Swing Thread:  ";
    public static final String GSWING_THREAD_POOL_NAME = "GSwing Worker";

    private static int loadTimeout() {
        String timeoutString = System.getProperty(SWING_TIMEOUT_SECONDS_PROPERTY, Integer.toString(20));
        try {
            return Integer.parseInt(timeoutString);
        }
        catch (NumberFormatException e) {
            return 20;
        }
    }

    public static boolean isSwingThread() {
        if (Swing.isInHeadlessMode()) {
            return true;
        }
        return SwingUtilities.isEventDispatchThread();
    }

    public static void allowSwingToProcessEvents() {
        Runnable r = () -> {};
        Swing.runNow(r);
        Swing.runNow(r);
        Swing.runNow(r);
    }

    public static boolean assertSwingThread(String errorMessage) {
        if (!Swing.isSwingThread()) {
            Throwable t = ReflectionUtilities.filterJavaThrowable(new AssertException(errorMessage));
            Msg.error(Swing.class, errorMessage, t);
            return false;
        }
        return true;
    }

    public static void runLater(Runnable r) {
        Swing.doRun(r, false, SWING_RUN_ERROR_MSG);
    }

    public static void runIfSwingOrRunLater(Runnable r) {
        if (Swing.isInHeadlessMode()) {
            r.run();
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    public static <T> T runNow(Supplier<T> s) {
        AtomicReference ref = new AtomicReference();
        Swing.runNow(() -> ref.set(s.get()));
        return (T)ref.get();
    }

    public static void runNow(Runnable r) {
        try {
            Swing.runNow(r, SWING_TIMEOUT_SECONDS_VALUE, TimeUnit.SECONDS);
        }
        catch (UnableToSwingException e) {
            String warning = "Timed-out waiting to run a Swing task--potential deadlock!";
            if (SystemUtilities.isInReleaseMode()) {
                Throwable threadDump = ReflectionUtilities.createJavaFilteredThrowable();
                Msg.error(Swing.class, warning + "\nThreads State:\n" + threadDump);
                throw new RuntimeException(warning, e);
            }
            String originator = Swing.class.getName();
            Msg.debug(originator, warning + "  Ignore this message if debugging");
            Swing.doRun(r, true, SWING_RUN_ERROR_MSG);
        }
    }

    public static void runNow(Runnable r, long timeout, TimeUnit unit) throws UnableToSwingException {
        if (Swing.isInHeadlessMode() || SystemUtilities.isEventDispatchThread()) {
            Swing.doRun(r, true, SWING_RUN_ERROR_MSG);
            return;
        }
        CyclicBarrier start = new CyclicBarrier(2);
        CyclicBarrier end = new CyclicBarrier(2);
        Swing.runLater(() -> {
            if (!Swing.waitFor(start)) {
                return;
            }
            try {
                r.run();
            }
            finally {
                Swing.waitFor(end);
            }
        });
        if (!Swing.waitFor(start, timeout, unit)) {
            return;
        }
        Swing.waitFor(end);
    }

    private static boolean waitFor(CyclicBarrier barrier, long timeout, TimeUnit unit) throws UnableToSwingException {
        try {
            barrier.await(timeout, unit);
            return true;
        }
        catch (InterruptedException interruptedException) {
        }
        catch (BrokenBarrierException | TimeoutException e) {
            throw new UnableToSwingException("Timed-out waiting for Swing thread lock in " + timeout + " " + unit);
        }
        return false;
    }

    private static boolean waitFor(CyclicBarrier barrier) {
        try {
            barrier.await();
            return true;
        }
        catch (InterruptedException | BrokenBarrierException exception) {
            return false;
        }
    }

    private static boolean isInHeadlessMode() {
        return SystemUtilities.isInHeadlessMode();
    }

    private static void doRun(Runnable r, boolean wait, String errorMessage) {
        if (Swing.isInHeadlessMode()) {
            r.run();
            return;
        }
        if (!wait) {
            SwingUtilities.invokeLater(r);
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
            return;
        }
        try {
            SwingUtilities.invokeAndWait(r);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            Msg.error(Swing.class, errorMessage + "\nException Message: " + e.getMessage(), e);
        }
    }

    private Swing() {
    }
}

