/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.decompiler.ClangFieldToken;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.app.plugin.core.decompile.actions.RenameVariableTask;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Function;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.HelpLocation;
import ghidra.util.UndefinedFunction;

public class RenameLocalAction
extends AbstractDecompilerAction {
    public RenameLocalAction() {
        super("Rename Variable");
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionRenameVariable"));
        this.setPopupMenuData(new MenuData(new String[]{"Rename Variable"}, "Decompile"));
        this.setKeyBindingData(new KeyBindingData(76, 0));
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        Function function = context.getFunction();
        if (function == null || function instanceof UndefinedFunction) {
            return false;
        }
        ClangToken tokenAtCursor = context.getTokenAtCursor();
        if (tokenAtCursor == null) {
            return false;
        }
        if (tokenAtCursor instanceof ClangFieldToken) {
            return false;
        }
        HighSymbol highSymbol = RenameLocalAction.findHighSymbolFromToken(tokenAtCursor, context.getHighFunction());
        if (highSymbol == null) {
            return false;
        }
        return !highSymbol.isGlobal();
    }

    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        PluginTool tool = context.getTool();
        ClangToken tokenAtCursor = context.getTokenAtCursor();
        HighSymbol highSymbol = RenameLocalAction.findHighSymbolFromToken(tokenAtCursor, context.getHighFunction());
        RenameVariableTask nameTask = new RenameVariableTask(tool, context.getProgram(), context.getComponentProvider(), tokenAtCursor, highSymbol, SourceType.USER_DEFINED);
        nameTask.runTask(true);
    }
}

